/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.effect;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.trique.gemforged.effect.GemforgedEffects;
import org.joml.Vector3f;

public class PhoenixEffect
extends MobEffect {
    private static final String MODID = "gemforged";
    private static final ResourceLocation MOVE_ID = ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"rage_move");
    private static final double BASE_MOVE_MULT = 0.25;
    private static final Map<UUID, SavedState> STATES = new HashMap<UUID, SavedState>();
    private static final DustParticleOptions RED = new DustParticleOptions(new Vector3f(1.0f, 0.05f, 0.02f), 2.0f);
    private static final DustParticleOptions ORANGE = new DustParticleOptions(new Vector3f(0.7725f, 0.2353f, 0.0627f), 2.0f);
    private static final DustParticleOptions YELLOW = new DustParticleOptions(new Vector3f(0.9725f, 0.7294f, 0.3843f), 2.0f);

    public PhoenixEffect() {
        super(MobEffectCategory.BENEFICIAL, 16742912);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, MOVE_ID, 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public void onEffectStarted(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 pos = player.position();
            STATES.put(player.getUUID(), new SavedState(pos, player.getYRot(), player.getXRot(), player.getHealth()));
        }
    }

    public void onEffectRemoved(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            STATES.remove(player.getUUID());
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel level2 = (ServerLevel)level;
        Vec3 look = entity.getLookAngle();
        Vec3 pos = entity.position();
        double speed = entity.getDeltaMovement().length();
        int densityBoost = (int)Math.min(10.0, Math.floor(speed * 25.0));
        int perSegParticles = 6 + densityBoost;
        int segments = 3;
        double segStep = 0.5;
        double backDist = 0.75 + entity.getRandom().nextDouble() * 0.35;
        double baseX = pos.x - look.x * backDist;
        double baseY = pos.y + 0.55;
        double baseZ = pos.z - look.z * backDist;
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 side = up.cross(look).normalize();
        Vec3 upTilt = look.cross(side).normalize();
        for (int s = 0; s < segments; ++s) {
            double tBack = (double)s * segStep;
            double cx = baseX - look.x * tBack;
            double cy = baseY - 0.05 * (double)s;
            double cz = baseZ - look.z * tBack;
            double r = 0.24 + 0.06 * (double)s;
            for (int i = 0; i < perSegParticles; ++i) {
                double a = Math.PI * 2 * (double)i / (double)perSegParticles + (double)entity.tickCount * 0.28;
                Vec3 offset = side.scale(r * (double)Mth.cos((float)((float)a))).add(upTilt.scale(r * (double)Mth.sin((float)((float)a)) * 1.8));
                double px = cx + offset.x;
                double py = cy + offset.y;
                double pz = cz + offset.z;
                int sel = (s + i) % 3;
                DustParticleOptions dust = sel == 0 ? RED : (sel == 1 ? ORANGE : YELLOW);
                level2.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (entity.tickCount % 50 == 0) {
            level2.playSound(null, pos.x, pos.y, pos.z, SoundEvents.BLAZE_SHOOT, SoundSource.PLAYERS, 0.5f, 0.1f + entity.getRandom().nextFloat() * 0.2f);
        }
        return true;
    }

    public static boolean tryRevive(Player player) {
        SavedState state = STATES.get(player.getUUID());
        if (state == null) {
            return false;
        }
        player.setHealth(state.health);
        player.teleportTo(state.pos.x, state.pos.y, state.pos.z);
        player.setYRot(state.yaw);
        player.setXRot(state.pitch);
        STATES.remove(player.getUUID());
        player.removeEffect(GemforgedEffects.PHOENIX);
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            Vec3 pos = player.position();
            level2.playSound(null, pos.x, pos.y, pos.z, SoundEvents.FIREWORK_ROCKET_BLAST, SoundSource.PLAYERS, 2.0f, 1.0f);
            level2.playSound(null, pos.x, pos.y, pos.z, SoundEvents.BLAZE_BURN, SoundSource.PLAYERS, 1.5f, 0.8f);
            int rings = 5;
            int pointsPerRing = 120;
            double maxRadius = 8.0;
            for (int r = 0; r < rings; ++r) {
                double radius = maxRadius / (double)rings * (double)(r + 1);
                double yBase = pos.y + 0.3 + (double)r * 0.2;
                for (int i = 0; i < pointsPerRing; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)pointsPerRing;
                    double px = pos.x + radius * Math.cos(angle);
                    double pz = pos.z + radius * Math.sin(angle);
                    double py = yBase + Math.sin((double)i * 0.15 + (double)r) * 0.2;
                    int selector = (i + r) % 3;
                    DustParticleOptions dust = selector == 0 ? RED : (selector == 1 ? ORANGE : YELLOW);
                    level2.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            int columns = 16;
            for (int col = 0; col < columns; ++col) {
                double angle = Math.PI * 2 * (double)col / (double)columns;
                double px = pos.x + Math.cos(angle) * 2.0;
                double pz = pos.z + Math.sin(angle) * 2.0;
                for (int h = 0; h < 20; ++h) {
                    double py = pos.y + 0.2 + (double)h * 0.15;
                    DustParticleOptions dust = h > 13 ? YELLOW : (h > 6 ? ORANGE : RED);
                    level2.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            level2.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, pos.x, pos.y + 1.0, pos.z, 3, 1.0, 1.0, 1.0, 0.0);
        }
        return true;
    }

    private record SavedState(Vec3 pos, float yaw, float pitch, float health) {
    }
}

