/*
 * Decompiled with CFR 0.152.
 */
package net.trique.gemforged.effect;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class ShimmerRageEffect
extends MobEffect {
    private static final String MODID = "gemforged";
    private static final ResourceLocation ATKDAM_ID = ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"shimmer_rage_attack_damage");
    private static final ResourceLocation SCALE_ID = ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"shimmer_rage_scale");
    private static final ResourceLocation HEALTH_ID = ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"shimmer_rage_max_health");
    private static final ResourceLocation JUMP_ID = ResourceLocation.fromNamespaceAndPath((String)"gemforged", (String)"shimmer_rage_jump");
    private static final double ATKDAM_MULT = 1.0;
    private static final double SCALE_MULT = 0.75;
    private static final double HEALTH_MULT = 1.0;
    private static final double JUMP_MULT = 0.5;
    private static final DustParticleOptions ROYAL_PURPLE = new DustParticleOptions(new Vector3f(0.55f, 0.0f, 0.85f), 2.0f);
    private static final DustParticleOptions DEEP_VIOLET = new DustParticleOptions(new Vector3f(0.38f, 0.0f, 0.72f), 2.0f);

    public ShimmerRageEffect() {
        super(MobEffectCategory.BENEFICIAL, 9055202);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ATKDAM_ID, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.SCALE, SCALE_ID, 0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.MAX_HEALTH, HEALTH_ID, 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        this.addAttributeModifier(Attributes.JUMP_STRENGTH, JUMP_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel level2 = (ServerLevel)level;
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 2, true, true, true));
        Vec3 look = entity.getLookAngle();
        Vec3 pos = entity.position();
        double backDist = 0.8 + entity.getRandom().nextDouble() * 0.4;
        double baseX = pos.x - look.x * backDist;
        double baseY = pos.y + 0.6;
        double baseZ = pos.z - look.z * backDist;
        int segments = 4;
        int perSegParticles = 8;
        double segStep = 0.55;
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 side = up.cross(look).normalize();
        Vec3 upTilt = look.cross(side).normalize();
        for (int s = 0; s < segments; ++s) {
            double tBack = (double)s * segStep;
            double cx = baseX - look.x * tBack;
            double cy = baseY - 0.05 * (double)s;
            double cz = baseZ - look.z * tBack;
            double r = 0.25 + 0.05 * (double)s;
            for (int i = 0; i < perSegParticles; ++i) {
                double a = Math.PI * 2 * (double)i / (double)perSegParticles + (double)entity.tickCount * 0.25;
                Vec3 offset = side.scale(r * (double)Mth.cos((float)((float)a))).add(upTilt.scale(r * (double)Mth.sin((float)((float)a)) * 2.0));
                double px = cx + offset.x;
                double py = cy + offset.y;
                double pz = cz + offset.z;
                DustParticleOptions dust = (s + i) % 2 == 0 ? ROYAL_PURPLE : DEEP_VIOLET;
                level2.sendParticles((ParticleOptions)dust, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
                if (i % 4 != 0) continue;
                level2.sendParticles((ParticleOptions)ParticleTypes.END_ROD, px, py, pz, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (entity.tickCount % 60 == 0) {
            level2.playSound(null, pos.x, pos.y, pos.z, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.PLAYERS, 1.5f, 0.1f + entity.getRandom().nextFloat() * 0.2f);
        }
        return true;
    }
}

