/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.dumbsh__.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EndSkullBlock
extends FallingBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final MapCodec<EndSkullBlock> CODEC = EndSkullBlock.simpleCodec(EndSkullBlock::new);

    public MapCodec<EndSkullBlock> codec() {
        return CODEC;
    }

    public EndSkullBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.BONE_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)EndSkullBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{EndSkullBlock.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)2.0, (double)6.0), EndSkullBlock.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)2.0, (double)8.0), EndSkullBlock.box((double)9.0, (double)0.0, (double)11.0, (double)11.0, (double)2.0, (double)12.0), EndSkullBlock.box((double)5.0, (double)0.0, (double)11.0, (double)7.0, (double)2.0, (double)12.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)EndSkullBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{EndSkullBlock.box((double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)2.0, (double)12.0), EndSkullBlock.box((double)6.0, (double)1.0, (double)8.0, (double)10.0, (double)2.0, (double)10.0), EndSkullBlock.box((double)5.0, (double)0.0, (double)4.0, (double)7.0, (double)2.0, (double)5.0), EndSkullBlock.box((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)2.0, (double)5.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)EndSkullBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{EndSkullBlock.box((double)4.0, (double)0.0, (double)5.0, (double)6.0, (double)2.0, (double)11.0), EndSkullBlock.box((double)6.0, (double)1.0, (double)6.0, (double)8.0, (double)2.0, (double)10.0), EndSkullBlock.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)7.0), EndSkullBlock.box((double)11.0, (double)0.0, (double)9.0, (double)12.0, (double)2.0, (double)11.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)EndSkullBlock.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape[])new VoxelShape[]{EndSkullBlock.box((double)10.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0), EndSkullBlock.box((double)8.0, (double)1.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), EndSkullBlock.box((double)4.0, (double)0.0, (double)9.0, (double)5.0, (double)2.0, (double)11.0), EndSkullBlock.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)2.0, (double)7.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

