/*
 * Decompiled with CFR 0.152.
 */
package com.fernsehheft.setspawn;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetSpawn
extends JavaPlugin {
    private File spawnPointsFile;
    private FileConfiguration spawnPointsConfig;
    private File homesFile;
    private FileConfiguration homesConfig;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, TeleportTask> teleportTasks = new HashMap<UUID, TeleportTask>();

    public void onEnable() {
        this.createAndLoadConfigs();
        this.getCommand("setspawn").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("spawn").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("setlobby").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("lobby").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("sethub").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("hub").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("delspawn").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("dellobby").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("delhub").setExecutor((CommandExecutor)new CommandHandler());
        this.getCommand("sethome").setExecutor((CommandExecutor)new HomeCommandHandler());
        this.getCommand("home").setExecutor((CommandExecutor)new HomeCommandHandler());
        this.getCommand("homenames").setExecutor((CommandExecutor)new HomeCommandHandler());
        this.getCommand("delhome").setExecutor((CommandExecutor)new DelHomeCommandHandler());
        this.getCommand("setspawnpoint").setExecutor((CommandExecutor)new SpawnPointCommandHandler());
    }

    public void onDisable() {
        try {
            this.spawnPointsConfig.save(this.spawnPointsFile);
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createAndLoadConfigs() {
        this.saveDefaultConfig();
        this.getConfig().addDefault("prefix", (Object)"&b[TeleportPlugin]&r");
        this.getConfig().addDefault("max_homes", (Object)5);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.spawnPointsFile = new File(this.getDataFolder(), "spawnpoints.yml");
        if (!this.spawnPointsFile.exists()) {
            try {
                this.spawnPointsFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.spawnPointsConfig = YamlConfiguration.loadConfiguration((File)this.spawnPointsFile);
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private void reloadAllConfigs() {
        this.reloadConfig();
        this.spawnPointsConfig = YamlConfiguration.loadConfiguration((File)this.spawnPointsFile);
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    private String getPrefix() {
        String prefix = this.getConfig().getString("prefix", "&b[TeleportPlugin]&r");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix) + " ";
    }

    private void teleportToNamedLocation(Player player, String name, Location startLocation, boolean isNamedLocation) {
        long secondsLeft;
        String path;
        FileConfiguration config = isNamedLocation ? this.spawnPointsConfig : this.homesConfig;
        Location targetLocation = (Location)config.get(path = isNamedLocation ? name.toLowerCase() : player.getUniqueId().toString() + "." + name.toLowerCase());
        if (targetLocation == null) {
            player.sendMessage(this.getPrefix() + "\u00a7cThe teleport point '" + name + "' does not exist.");
            return;
        }
        String cooldownPath = isNamedLocation ? name.toLowerCase() : "home";
        long cooldownTime = (long)this.getConfig().getInt(cooldownPath + ".cooldown", -1) * 1000L;
        if (this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = this.cooldowns.get(player.getUniqueId()) / 1000L + cooldownTime / 1000L - System.currentTimeMillis() / 1000L) > 0L) {
            player.sendMessage(this.getPrefix() + "\u00a7cYou must wait " + secondsLeft + " seconds before you can use this command again.");
            return;
        }
        long waitTime = this.getConfig().getInt("teleport_wait_time", 5);
        boolean moveCheckEnabled = this.getConfig().getBoolean("teleport_move_check", true);
        if (waitTime > 0L) {
            player.sendMessage(this.getPrefix() + "\u00a7eTeleporting in " + waitTime + " seconds. Please do not move!");
            this.teleportTasks.put(player.getUniqueId(), new TeleportTask(player, targetLocation, waitTime, moveCheckEnabled, startLocation));
        } else {
            player.teleport(targetLocation);
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
        }
    }

    private class CommandHandler
    implements CommandExecutor {
        private CommandHandler() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(SetSpawn.this.getPrefix() + "This command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            String cmdName = command.getName().toLowerCase();
            if (!SetSpawn.this.getConfig().getBoolean(cmdName + ".enabled", true) && !cmdName.startsWith("del")) {
                player.sendMessage(SetSpawn.this.getPrefix() + "This command is disabled.");
                return true;
            }
            String globalTeleportTarget = SetSpawn.this.getConfig().getString("global_teleport.target", "").toLowerCase();
            if (SetSpawn.this.getConfig().getBoolean("global_teleport.enabled") && !globalTeleportTarget.isEmpty() && (cmdName.equals("spawn") || cmdName.equals("lobby") || cmdName.equals("hub"))) {
                SetSpawn.this.teleportToNamedLocation(player, globalTeleportTarget, player.getLocation(), true);
                return true;
            }
            switch (cmdName) {
                case "sethub": 
                case "setlobby": 
                case "setspawn": {
                    if (!player.hasPermission("teleport.set")) {
                        player.sendMessage(SetSpawn.this.getPrefix() + "You do not have permission for this.");
                        return true;
                    }
                    this.saveLocation(player, cmdName.substring(3));
                    break;
                }
                case "hub": 
                case "lobby": 
                case "spawn": {
                    SetSpawn.this.teleportToNamedLocation(player, cmdName, player.getLocation(), true);
                    break;
                }
                case "delhub": 
                case "dellobby": 
                case "delspawn": {
                    if (!player.hasPermission("teleport.delete")) {
                        player.sendMessage(SetSpawn.this.getPrefix() + "You do not have permission for this.");
                        return true;
                    }
                    this.deleteLocation(player, cmdName.substring(3));
                }
            }
            return true;
        }

        private void saveLocation(Player player, String name) {
            SetSpawn.this.spawnPointsConfig.set(name.toLowerCase(), (Object)player.getLocation());
            try {
                SetSpawn.this.spawnPointsConfig.save(SetSpawn.this.spawnPointsFile);
                player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aThe " + name + " point has been successfully saved.");
            }
            catch (IOException e) {
                player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cError saving the point.");
                e.printStackTrace();
            }
        }

        private void deleteLocation(Player player, String name) {
            String pointName = name.toLowerCase();
            if (SetSpawn.this.spawnPointsConfig.contains(pointName)) {
                SetSpawn.this.spawnPointsConfig.set(pointName, null);
                try {
                    SetSpawn.this.spawnPointsConfig.save(SetSpawn.this.spawnPointsFile);
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aThe " + name + " point has been successfully deleted.");
                }
                catch (IOException e) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cError deleting the point.");
                    e.printStackTrace();
                }
            } else {
                player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cThe " + name + " point does not exist.");
            }
        }
    }

    private class DelHomeCommandHandler
    implements CommandExecutor {
        private DelHomeCommandHandler() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(SetSpawn.this.getPrefix() + "This command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            UUID playerId = player.getUniqueId();
            String playerHomesPath = playerId.toString();
            if (args.length != 1) {
                player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cUsage: /delhome <name>");
                return true;
            }
            String homeName = args[0].toLowerCase();
            String fullPath = playerHomesPath + "." + homeName;
            if (SetSpawn.this.homesConfig.contains(fullPath)) {
                Set remainingHomes;
                SetSpawn.this.homesConfig.set(fullPath, null);
                Set set = remainingHomes = SetSpawn.this.homesConfig.getConfigurationSection(playerHomesPath) != null ? SetSpawn.this.homesConfig.getConfigurationSection(playerHomesPath).getKeys(false) : null;
                if (remainingHomes != null && remainingHomes.isEmpty()) {
                    SetSpawn.this.homesConfig.set(playerHomesPath, null);
                }
                try {
                    SetSpawn.this.homesConfig.save(SetSpawn.this.homesFile);
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aYour home '" + homeName + "' has been successfully deleted.");
                }
                catch (IOException e) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cError deleting your home.");
                    e.printStackTrace();
                }
            } else {
                player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYour home '" + homeName + "' does not exist.");
            }
            return true;
        }
    }

    private class HomeCommandHandler
    implements CommandExecutor {
        private HomeCommandHandler() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(SetSpawn.this.getPrefix() + "This command can only be run by a player.");
                return true;
            }
            Player player = (Player)sender;
            String cmdName = command.getName().toLowerCase();
            UUID playerId = player.getUniqueId();
            if (cmdName.equals("sethome")) {
                Set currentHomes;
                if (args.length != 1) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cUsage: /sethome <name>");
                    return true;
                }
                int maxHomes = SetSpawn.this.getConfig().getInt("max_homes", 5);
                Set set = currentHomes = SetSpawn.this.homesConfig.contains(playerId.toString()) ? SetSpawn.this.homesConfig.getConfigurationSection(playerId.toString()).getKeys(false) : null;
                if (currentHomes != null && currentHomes.size() >= maxHomes) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou have reached the maximum number of homes (" + maxHomes + ").");
                    return true;
                }
                String homeName = args[0].toLowerCase();
                SetSpawn.this.homesConfig.set(playerId.toString() + "." + homeName, (Object)player.getLocation());
                try {
                    SetSpawn.this.homesConfig.save(SetSpawn.this.homesFile);
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aYour home '" + homeName + "' has been saved.");
                }
                catch (IOException e) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cError saving your home.");
                    e.printStackTrace();
                }
            } else if (cmdName.equals("home")) {
                if (args.length == 0) {
                    if (!SetSpawn.this.homesConfig.contains(playerId.toString())) {
                        player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou have no homes saved. Use /sethome <name>.");
                        return true;
                    }
                    Set homeNames = SetSpawn.this.homesConfig.getConfigurationSection(playerId.toString()).getKeys(false);
                    if (homeNames.isEmpty()) {
                        player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou have no homes saved. Use /sethome <name>.");
                    } else {
                        player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aYour homes: " + String.join((CharSequence)", ", homeNames));
                    }
                    return true;
                }
                String homeName = args[0].toLowerCase();
                SetSpawn.this.teleportToNamedLocation(player, homeName, player.getLocation(), false);
            } else if (cmdName.equals("homenames")) {
                if (!SetSpawn.this.homesConfig.contains(playerId.toString())) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou have no homes saved.");
                    return true;
                }
                Set homeNames = SetSpawn.this.homesConfig.getConfigurationSection(playerId.toString()).getKeys(false);
                if (homeNames.isEmpty()) {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou have no homes saved.");
                } else {
                    player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aYour homes: " + String.join((CharSequence)", ", homeNames));
                }
            }
            return true;
        }
    }

    private class SpawnPointCommandHandler
    implements CommandExecutor {
        private SpawnPointCommandHandler() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("teleport.reload")) {
                    sender.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cYou do not have permission to reload the plugin.");
                    return true;
                }
                SetSpawn.this.reloadAllConfigs();
                sender.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aAll config files have been reloaded.");
                return true;
            }
            return false;
        }
    }

    private class TeleportTask
    extends BukkitRunnable {
        private final Player player;
        private final Location targetLocation;
        private final long initialWaitTime;
        private final boolean moveCheckEnabled;
        private final Location startLocation;
        private long timeLeft;

        public TeleportTask(Player player, Location targetLocation, long waitTime, boolean moveCheckEnabled, Location startLocation) {
            this.player = player;
            this.targetLocation = targetLocation;
            this.initialWaitTime = waitTime;
            this.moveCheckEnabled = moveCheckEnabled;
            this.startLocation = startLocation;
            this.timeLeft = waitTime;
            this.runTaskTimer((Plugin)SetSpawn.this, 0L, 20L);
        }

        public void run() {
            if (this.player == null || !this.player.isOnline()) {
                this.cancel();
                SetSpawn.this.teleportTasks.remove(this.player.getUniqueId());
                return;
            }
            if (this.moveCheckEnabled && this.hasMoved()) {
                this.player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7cTeleport cancelled because you moved.");
                this.cancel();
                SetSpawn.this.teleportTasks.remove(this.player.getUniqueId());
                return;
            }
            if (this.timeLeft <= 0L) {
                this.player.teleport(this.targetLocation);
                SetSpawn.this.cooldowns.put(this.player.getUniqueId(), System.currentTimeMillis());
                this.player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7aTeleport complete.");
                this.cancel();
                SetSpawn.this.teleportTasks.remove(this.player.getUniqueId());
            } else {
                this.player.sendMessage(SetSpawn.this.getPrefix() + "\u00a7eTeleporting in " + this.timeLeft + " seconds...");
                --this.timeLeft;
            }
        }

        private boolean hasMoved() {
            return this.startLocation.distanceSquared(this.player.getLocation()) > 0.010000000000000002;
        }
    }
}

