/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer;

import binge.software.redstoneSignalVisualizer.BatchRedstoneSignalPayload;
import binge.software.redstoneSignalVisualizer.RedstoneSignalType;
import binge.software.redstoneSignalVisualizer.ServerSettingsTracker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class RedstoneSignalTracker {
    private static final Int2ObjectMap<List<class_2338>> radiusToPositionsCache = new Int2ObjectOpenHashMap();
    private static final Map<UUID, Set<class_2338>> playerComparators = new HashMap<UUID, Set<class_2338>>();
    private static final Map<UUID, Long> playerLastUpdateTimeMap = new HashMap<UUID, Long>();
    private static final Map<UUID, Set<class_2338>> toRemoveCache = new HashMap<UUID, Set<class_2338>>();

    public static void registerPayload() {
        PayloadTypeRegistry.playS2C().register(BatchRedstoneSignalPayload.ID, BatchRedstoneSignalPayload.CODEC);
    }

    /*
     * Could not resolve type clashes
     */
    public static void trackComparatorsAroundPlayers(class_3218 world) {
        long currentTime = System.currentTimeMillis();
        if (world.method_18456().isEmpty()) {
            return;
        }
        for (Object player : world.method_18456()) {
            class_2338 pos;
            Object offset2;
            if (!ServerSettingsTracker.hasModInstalled((class_3222)player)) continue;
            UUID playerId2 = player.method_5667();
            long playerUpdateDelay = ServerSettingsTracker.getPlayerUpdateDelay((class_3222)player);
            long lastUpdateTime = playerLastUpdateTimeMap.getOrDefault(playerId2, 0L);
            if (currentTime - lastUpdateTime < playerUpdateDelay) continue;
            playerLastUpdateTimeMap.put(playerId2, currentTime);
            class_2338 playerPos = player.method_24515();
            int radius = ServerSettingsTracker.getPlayerRadius((class_3222)player);
            Set previousComparators = playerComparators.getOrDefault(player.method_5667(), new HashSet());
            HashSet<class_2338> currentComparators = new HashSet<class_2338>();
            List<class_2338> positions = RedstoneSignalTracker.getPrecomputedPositions(radius);
            int MAX_BATCH_SIZE = 1000;
            ArrayList<RedstoneSignalData> allSignals = new ArrayList<RedstoneSignalData>();
            for (Object offset2 : positions) {
                int receivedPower;
                if (allSignals.size() >= 1000) break;
                pos = playerPos.method_10081((class_2382)offset2);
                class_2680 blockState = world.method_8320(pos);
                if (blockState.method_26204() instanceof class_2286) {
                    int signal = RedstoneSignalTracker.getComparatorOutput(world, pos, blockState);
                    if (signal > 0) {
                        boolean isSubtractMode;
                        currentComparators.add(pos);
                        boolean bl = isSubtractMode = blockState.method_11654((class_2769)class_2286.field_10789) == class_2747.field_12578;
                        if (allSignals.size() < 1000) {
                            allSignals.add(new RedstoneSignalData(pos, signal, isSubtractMode, RedstoneSignalType.COMPARATOR));
                        }
                    } else if (previousComparators.contains(pos) && allSignals.size() < 1000) {
                        allSignals.add(new RedstoneSignalData(pos, -1, false, RedstoneSignalType.COMPARATOR));
                    }
                }
                if ((receivedPower = world.method_49804(pos)) <= 0 || allSignals.size() >= 1000) continue;
                allSignals.add(new RedstoneSignalData(pos, receivedPower, false, RedstoneSignalType.RECEIVE));
            }
            Set toRemove = toRemoveCache.computeIfAbsent(playerId2, k -> new HashSet());
            toRemove.clear();
            toRemove.addAll(previousComparators);
            toRemove.removeAll(currentComparators);
            offset2 = toRemove.iterator();
            while (offset2.hasNext()) {
                pos = (class_2338)offset2.next();
                if (allSignals.size() >= 1000) break;
                allSignals.add(new RedstoneSignalData(pos, -1, false, RedstoneSignalType.COMPARATOR));
            }
            ArrayList batches = new ArrayList();
            ArrayList<RedstoneSignalData> currentBatch = new ArrayList<RedstoneSignalData>(1000);
            for (RedstoneSignalData signal : allSignals) {
                if (currentBatch.size() >= 1000) {
                    batches.add(currentBatch);
                    currentBatch = new ArrayList(1000);
                }
                currentBatch.add(signal);
            }
            if (!currentBatch.isEmpty()) {
                batches.add(currentBatch);
            }
            for (List batch : batches) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new BatchRedstoneSignalPayload(batch));
            }
            playerComparators.put(player.method_5667(), currentComparators);
        }
        HashSet<UUID> connectedPlayerIds = new HashSet<UUID>();
        for (class_3222 player : world.method_18456()) {
            connectedPlayerIds.add(player.method_5667());
        }
        playerLastUpdateTimeMap.keySet().removeIf(playerId -> !connectedPlayerIds.contains(playerId));
        playerComparators.keySet().removeIf(playerId -> !connectedPlayerIds.contains(playerId));
        HashSet<UUID> playersToRemove = new HashSet<UUID>(playerLastUpdateTimeMap.keySet());
        playersToRemove.removeAll(connectedPlayerIds);
        playersToRemove.forEach(ServerSettingsTracker::removePlayer);
    }

    private static List<class_2338> getPrecomputedPositions(int radius) {
        return (List)radiusToPositionsCache.computeIfAbsent(radius, RedstoneSignalTracker::precomputePositions);
    }

    private static List<class_2338> precomputePositions(int radius) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int radiusSquared = radius * radius;
        for (int x = 0; x <= radius; ++x) {
            for (int y = 0; y <= radius; ++y) {
                for (int z = 0; z <= radius; ++z) {
                    int distSquared = x * x + y * y + z * z;
                    if (distSquared > radiusSquared) continue;
                    RedstoneSignalTracker.addSymmetricPositions(positions, x, y, z);
                }
            }
        }
        return positions;
    }

    private static void addSymmetricPositions(List<class_2338> positions, int x, int y, int z) {
        for (int sx = -1; sx <= 1; sx += 2) {
            for (int sy = -1; sy <= 1; sy += 2) {
                for (int sz = -1; sz <= 1; sz += 2) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    positions.add(new class_2338(sx * x, sy * y, sz * z));
                }
            }
        }
    }

    private static int getComparatorOutput(class_3218 world, class_2338 pos, class_2680 state) {
        return world.method_49808(pos, (class_2350)state.method_11654((class_2769)class_2286.field_11177));
    }

    public record RedstoneSignalData(class_2338 blockPos, int signal, boolean isSubtractMode, RedstoneSignalType type) {
        public RedstoneSignalData(class_2338 blockPos, int signal, boolean isSubtractMode) {
            this(blockPos, signal, isSubtractMode, RedstoneSignalType.COMPARATOR);
        }
    }
}

