/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer;

import binge.software.redstoneSignalVisualizer.ModPresencePayload;
import binge.software.redstoneSignalVisualizer.ModStatusPayload;
import binge.software.redstoneSignalVisualizer.RadiusSettingPayload;
import binge.software.redstoneSignalVisualizer.UpdateDelaySettingPayload;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;

public class ServerSettingsTracker {
    private static final Map<UUID, Integer> playerRadiusMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> playerUpdateDelayMap = new HashMap<UUID, Long>();
    private static final Set<UUID> playersWithMod = new HashSet<UUID>();

    public static void registerPayload() {
        System.out.println("Registered Payload.");
        PayloadTypeRegistry.playC2S().register(RadiusSettingPayload.ID, RadiusSettingPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateDelaySettingPayload.ID, UpdateDelaySettingPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ModPresencePayload.ID, ModPresencePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ModStatusPayload.ID, ModStatusPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RadiusSettingPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            int radius = payload.radius();
            System.out.println("Received radius update from player " + player.method_5477().getString() + ": " + radius);
            playerRadiusMap.put(player.method_5667(), radius);
        });
        ServerPlayNetworking.registerGlobalReceiver(UpdateDelaySettingPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            long updateDelay = payload.updateDelay();
            System.out.println("Received update delay from player " + player.method_5477().getString() + ": " + updateDelay);
            playerUpdateDelayMap.put(player.method_5667(), updateDelay);
        });
        ServerPlayNetworking.registerGlobalReceiver(ModPresencePayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            UUID playerId = player.method_5667();
            System.out.println("Player " + player.method_5477().getString() + " has the mod installed");
        });
        ServerPlayNetworking.registerGlobalReceiver(ModStatusPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            UUID playerId = player.method_5667();
            boolean enabled = payload.enabled();
            System.out.println("Player " + player.method_5477().getString() + " has " + (enabled ? "enabled" : "disabled") + " the mod");
            if (enabled) {
                playersWithMod.add(playerId);
            } else {
                playersWithMod.remove(playerId);
            }
        });
    }

    public static int getPlayerRadius(class_3222 player) {
        return playerRadiusMap.getOrDefault(player.method_5667(), 16);
    }

    public static long getPlayerUpdateDelay(class_3222 player) {
        return playerUpdateDelayMap.getOrDefault(player.method_5667(), 100L);
    }

    public static boolean hasModInstalled(class_3222 player) {
        return playersWithMod.contains(player.method_5667());
    }

    public static void removePlayer(UUID playerId) {
        playerRadiusMap.remove(playerId);
        playerUpdateDelayMap.remove(playerId);
        playersWithMod.remove(playerId);
    }
}

