/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer.client;

import binge.software.redstoneSignalVisualizer.client.ColorSliderWidget;
import binge.software.redstoneSignalVisualizer.client.SignalColor;
import binge.software.redstoneSignalVisualizer.client.VisualizerSettings;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class ColorOptionsScreen
extends class_437 {
    private final class_437 parent;
    private static final int SLIDER_WIDTH = 200;
    private static final int SLIDER_HEIGHT = 20;
    private static final int PREVIEW_HEIGHT = 20;
    private static final int PREVIEW_WIDTH = 50;
    private static final ColorConsumer DEFAULT_COLOR_CONSUMER = color -> SignalColor.DEFAULT.setValue(color);
    private static final ColorConsumer OBSTRUCTED_COLOR_CONSUMER = color -> SignalColor.OBSTRUCTED.setValue(color);
    private static final ColorConsumer EMITTER_COLOR_CONSUMER = color -> SignalColor.EMITTER.setValue(color);
    private static final ColorConsumer COMPARATOR_COLOR_CONSUMER = color -> SignalColor.COMPARATOR_NORMAL.setValue(color);
    private static final ColorConsumer COMPARATOR_SUBTRACT_COLOR_CONSUMER = color -> SignalColor.COMPARATOR_SUBTRACT.setValue(color);

    protected ColorOptionsScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Color Options"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int startY = this.field_22790 / 6;
        this.addColorSlider("Receiver Default Color", startY, SignalColor.DEFAULT.getValue(), DEFAULT_COLOR_CONSUMER);
        this.addColorSlider("Receiver Obstructed Color", startY + 30, SignalColor.OBSTRUCTED.getValue(), OBSTRUCTED_COLOR_CONSUMER);
        this.addColorSlider("Emitter Color", startY + 60, SignalColor.EMITTER.getValue(), EMITTER_COLOR_CONSUMER);
        this.addColorSlider("Comparator Color", startY + 90, SignalColor.COMPARATOR_NORMAL.getValue(), COMPARATOR_COLOR_CONSUMER);
        this.addColorSlider("Comparator Subtract Color", startY + 120, SignalColor.COMPARATOR_SUBTRACT.getValue(), COMPARATOR_SUBTRACT_COLOR_CONSUMER);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"Done"), button -> {
            this.field_22787.method_1507(this.parent);
            VisualizerSettings.saveSettings();
        }).method_46434(this.field_22789 / 2 - 100, startY + 150, 200, 20).method_46431());
    }

    private void addColorSlider(String label, int y, int initialColor, ColorConsumer consumer) {
        float[] hsb = Color.RGBtoHSB(initialColor >> 16 & 0xFF, initialColor >> 8 & 0xFF, initialColor & 0xFF, null);
        this.method_37063((class_364)new ColorSliderWidget(this.field_22789 / 2 - 100, y, 200, 20, class_2561.method_30163((String)label), hsb[0], 0, value -> {
            int newColor = Color.HSBtoRGB(value, 1.0f, 1.0f);
            consumer.accept(newColor);
            VisualizerSettings.saveSettings();
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        int startY = this.field_22790 / 6;
        int previewX = this.field_22789 / 2 + 100 + 10;
        context.method_25294(previewX, startY, previewX + 50, startY + 20, SignalColor.DEFAULT.getValue() | 0xFF000000);
        context.method_25294(previewX, startY + 30, previewX + 50, startY + 30 + 20, SignalColor.OBSTRUCTED.getValue() | 0xFF000000);
        context.method_25294(previewX, startY + 60, previewX + 50, startY + 60 + 20, SignalColor.EMITTER.getValue() | 0xFF000000);
        context.method_25294(previewX, startY + 90, previewX + 50, startY + 90 + 20, SignalColor.COMPARATOR_NORMAL.getValue() | 0xFF000000);
        context.method_25294(previewX, startY + 120, previewX + 50, startY + 120 + 20, SignalColor.COMPARATOR_SUBTRACT.getValue() | 0xFF000000);
        context.method_27535(this.field_22793, this.field_22785, (this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, 15, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface ColorConsumer {
        public void accept(int var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    static interface FloatConsumer {
        public void accept(float var1);
    }
}

