/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer.client;

import binge.software.redstoneSignalVisualizer.client.RedstoneSignalVisualizerClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class RedstoneSignalChecker {
    private final Map<class_2338, RedstoneSignalVisualizerClient.SignalData> receivedRedstonePowerMap;
    private final Map<class_2338, RedstoneSignalVisualizerClient.SignalData> emittedRedstonePowerMap;
    private final AtomicBoolean isChecking;
    private final ExecutorService executorService;
    private final boolean showReceives;
    private final boolean showEmits;
    private final int radius;
    private final List<class_2338> precomputedPositions;

    public RedstoneSignalChecker(Map<class_2338, RedstoneSignalVisualizerClient.SignalData> receivedRedstonePowerMap, Map<class_2338, RedstoneSignalVisualizerClient.SignalData> emittedRedstonePowerMap, AtomicBoolean isChecking, ExecutorService executorService, boolean showReceives, boolean showEmits, int radius, List<class_2338> precomputedPositions) {
        this.receivedRedstonePowerMap = receivedRedstonePowerMap;
        this.emittedRedstonePowerMap = emittedRedstonePowerMap;
        this.isChecking = isChecking;
        this.executorService = executorService;
        this.showReceives = showReceives;
        this.showEmits = showEmits;
        this.radius = radius;
        this.precomputedPositions = precomputedPositions;
    }

    public void checkRedstoneAroundPlayer(class_746 player) {
        if (this.isChecking.get()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            return;
        }
        this.isChecking.set(true);
        this.executorService.submit(() -> this.lambda$checkRedstoneAroundPlayer$3(player, (class_1937)world, client));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$checkRedstoneAroundPlayer$3(class_746 player, class_1937 world, class_310 client) {
        ArrayList<class_2338> positions;
        ConcurrentHashMap<class_2338, RedstoneSignalVisualizerClient.SignalData> newReceivedMap = new ConcurrentHashMap<class_2338, RedstoneSignalVisualizerClient.SignalData>();
        ConcurrentHashMap<class_2338, RedstoneSignalVisualizerClient.SignalData> newEmittedMap = new ConcurrentHashMap<class_2338, RedstoneSignalVisualizerClient.SignalData>();
        RedstoneSignalChecker redstoneSignalChecker = this;
        synchronized (redstoneSignalChecker) {
            positions = new ArrayList<class_2338>(this.precomputedPositions);
        }
        HashSet<class_2338> checkPositions = new HashSet<class_2338>(positions.size());
        for (class_2338 offset : positions) {
            checkPositions.add(player.method_24515().method_10081((class_2382)offset));
        }
        for (class_2338 pos : checkPositions) {
            int receivedPower;
            if (this.showReceives && (receivedPower = world.method_49804(pos)) > 0) {
                newReceivedMap.put(pos, new RedstoneSignalVisualizerClient.SignalData(receivedPower));
            }
            if (!this.showEmits) continue;
            boolean hasEmittedPower = false;
            for (class_2350 direction : class_2350.values()) {
                int emittedPower = world.method_49808(pos, direction);
                if (emittedPower <= 0) continue;
                hasEmittedPower = true;
                int currentSignal = newEmittedMap.containsKey(pos) ? ((RedstoneSignalVisualizerClient.SignalData)newEmittedMap.get((Object)pos)).signal : 0;
                int maxSignal = Math.max(emittedPower, currentSignal);
                newEmittedMap.put(pos, new RedstoneSignalVisualizerClient.SignalData(maxSignal));
            }
        }
        client.execute(() -> {
            RedstoneSignalVisualizerClient.SignalData existingData;
            RedstoneSignalVisualizerClient.SignalData newData;
            class_2338 pos;
            long staleDuration = RedstoneSignalVisualizerClient.updateDelay;
            long currentTime = System.currentTimeMillis();
            this.receivedRedstonePowerMap.entrySet().removeIf(entry -> currentTime - ((RedstoneSignalVisualizerClient.SignalData)entry.getValue()).lastSeenTimestamp > staleDuration);
            this.emittedRedstonePowerMap.entrySet().removeIf(entry -> currentTime - ((RedstoneSignalVisualizerClient.SignalData)entry.getValue()).lastSeenTimestamp > staleDuration);
            for (Map.Entry entry2 : newReceivedMap.entrySet()) {
                pos = (class_2338)entry2.getKey();
                newData = (RedstoneSignalVisualizerClient.SignalData)entry2.getValue();
                existingData = this.receivedRedstonePowerMap.get(pos);
                if (existingData == null || existingData.signal != newData.signal) {
                    this.receivedRedstonePowerMap.put(pos, newData);
                    continue;
                }
                existingData.refresh();
            }
            for (Map.Entry entry2 : newEmittedMap.entrySet()) {
                pos = (class_2338)entry2.getKey();
                newData = (RedstoneSignalVisualizerClient.SignalData)entry2.getValue();
                existingData = this.emittedRedstonePowerMap.get(pos);
                if (existingData == null || existingData.signal != newData.signal) {
                    this.emittedRedstonePowerMap.put(pos, newData);
                    continue;
                }
                existingData.refresh();
            }
            this.isChecking.set(false);
        });
    }
}

