/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer.client;

import binge.software.redstoneSignalVisualizer.client.RedstoneSignalVisualizerClient;
import binge.software.redstoneSignalVisualizer.client.SignalColor;
import java.util.Collections;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class RedstoneSignalRenderer {
    private static final Quaternionf Y_180 = new Quaternionf().rotateY((float)Math.toRadians(180.0));
    private static final Quaternionf Z_180 = new Quaternionf().rotateZ((float)Math.toRadians(180.0));
    private static final float EMIT_SIGNAL_OFFSET = -5.0f;
    private static final float RECEIVE_SIGNAL_OFFSET = 5.0f;
    private static final float COMPARATOR_SIGNAL_OFFSET = -5.0f;

    public static void renderRedstoneSignals(class_4587 matrices, class_746 player, boolean modEnabled, Map<class_2338, RedstoneSignalVisualizerClient.SignalData> receivedRedstonePowerMap, Map<class_2338, RedstoneSignalVisualizerClient.SignalData> emittedRedstonePowerMap, boolean showReceives, boolean showEmits) {
        class_2338 pos;
        if (!modEnabled) {
            return;
        }
        int radiusSquared = RedstoneSignalVisualizerClient.radius * RedstoneSignalVisualizerClient.radius;
        class_2338 playerPos = player.method_24515();
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        Map<Object, RedstoneSignalVisualizerClient.ComparatorData> comparatorData = RedstoneSignalVisualizerClient.showComparators ? RedstoneSignalVisualizerClient.getComparatorSignals() : Collections.emptyMap();
        matrices.method_22903();
        if (showEmits) {
            for (Map.Entry<Object, Object> entry : emittedRedstonePowerMap.entrySet()) {
                pos = (class_2338)entry.getKey();
                if (playerPos.method_10262((class_2382)pos) > (double)radiusSquared) continue;
                RedstoneSignalRenderer.renderSignalForBlock(matrices, cameraPos, client, textRenderer, pos, ((RedstoneSignalVisualizerClient.SignalData)entry.getValue()).signal, SignalColor.EMITTER.getValue(), SignalColor.EMITTER.getValue(), -5.0f);
            }
        }
        if (showReceives) {
            for (Map.Entry<Object, Object> entry : receivedRedstonePowerMap.entrySet()) {
                pos = (class_2338)entry.getKey();
                if (playerPos.method_10262((class_2382)pos) > (double)radiusSquared) continue;
                RedstoneSignalRenderer.renderSignalForBlock(matrices, cameraPos, client, textRenderer, pos, ((RedstoneSignalVisualizerClient.SignalData)entry.getValue()).signal, SignalColor.DEFAULT.getValue(), SignalColor.OBSTRUCTED.getValue(), 5.0f);
            }
        }
        for (Map.Entry<Object, Object> entry : comparatorData.entrySet()) {
            pos = (class_2338)entry.getKey();
            if (playerPos.method_10262((class_2382)pos) > (double)radiusSquared) continue;
            RedstoneSignalVisualizerClient.ComparatorData data = (RedstoneSignalVisualizerClient.ComparatorData)entry.getValue();
            RedstoneSignalRenderer.renderSignalForBlock(matrices, cameraPos, client, textRenderer, pos, data.signal, data.isSubtractMode ? SignalColor.COMPARATOR_SUBTRACT.getValue() : SignalColor.COMPARATOR_NORMAL.getValue(), data.isSubtractMode ? SignalColor.COMPARATOR_SUBTRACT.getValue() : SignalColor.COMPARATOR_NORMAL.getValue(), -5.0f);
        }
        matrices.method_22909();
    }

    private static void renderSignalForBlock(class_4587 matrices, class_243 cameraPos, class_310 client, class_327 textRenderer, class_2338 blockPos, int signalStrength, int airColor, int nonAirColor, float yOffset) {
        class_243 blockPosVec = class_243.method_24953((class_2382)blockPos).method_1020(cameraPos);
        matrices.method_22903();
        matrices.method_22904(blockPosVec.field_1352, blockPosVec.field_1351, blockPosVec.field_1350);
        matrices.method_22907((Quaternionfc)client.method_1561().field_4686.method_23767());
        matrices.method_22907((Quaternionfc)Y_180);
        matrices.method_22907((Quaternionfc)Z_180);
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        matrices.method_22904(0.0, (double)yOffset, 0.1);
        boolean isAir = client.field_1687.method_8320(blockPos).method_26215();
        int baseColor = isAir ? airColor : nonAirColor;
        int alpha = 255;
        class_2561 text = class_2561.method_30163((String)String.valueOf(signalStrength));
        int textColor = alpha << 24 | baseColor & 0xFFFFFF;
        textRenderer.method_30882(text, (float)(-textRenderer.method_27525((class_5348)text)) / 2.0f, 0.0f, textColor, true, matrices.method_23760().method_23761(), (class_4597)client.method_22940().method_23000(), class_327.class_6415.field_33994, 0, 0xF000F0, true);
        matrices.method_22909();
    }
}

