/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer.client;

import binge.software.redstoneSignalVisualizer.BatchRedstoneSignalPayload;
import binge.software.redstoneSignalVisualizer.ModPresencePayload;
import binge.software.redstoneSignalVisualizer.ModStatusPayload;
import binge.software.redstoneSignalVisualizer.RadiusSettingPayload;
import binge.software.redstoneSignalVisualizer.RedstoneSignalTracker;
import binge.software.redstoneSignalVisualizer.UpdateDelaySettingPayload;
import binge.software.redstoneSignalVisualizer.client.OptionsScreen;
import binge.software.redstoneSignalVisualizer.client.RedstoneSignalChecker;
import binge.software.redstoneSignalVisualizer.client.RedstoneSignalRenderer;
import binge.software.redstoneSignalVisualizer.client.SignalColor;
import binge.software.redstoneSignalVisualizer.client.VisualizerSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class RedstoneSignalVisualizerClient
implements ClientModInitializer {
    private static final Map<class_2338, ComparatorData> comparatorSignalMap = new ConcurrentHashMap<class_2338, ComparatorData>();
    public static boolean modEnabled = true;
    public static int radius = 10;
    public static long updateDelay = 100L;
    public static boolean showEmits = true;
    public static boolean showReceives = true;
    public static boolean showComparators = true;
    private long lastCheckTime = 0L;
    private final Map<class_2338, SignalData> receivedRedstonePowerMap = new ConcurrentHashMap<class_2338, SignalData>();
    private final Map<class_2338, SignalData> emittedRedstonePowerMap = new ConcurrentHashMap<class_2338, SignalData>();
    private static class_304 openOptionsKey;
    private static RedstoneSignalVisualizerClient INSTANCE;
    private final AtomicBoolean isChecking = new AtomicBoolean(false);
    private final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private List<class_2338> precomputedPositions = new ArrayList<class_2338>();

    public void onInitializeClient() {
        VisualizerSettings.loadSettings();
        this.recalculatePrecomputedPositions();
        INSTANCE = this;
        openOptionsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.redstone_signal_visualizer.open_options", class_3675.class_307.field_1668, 79, "category.redstone_signal_visualizer"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            long currentTime;
            if (openOptionsKey.method_1436()) {
                client.method_1507((class_437)new OptionsScreen(class_2561.method_30163((String)"Redstone Signal Visualizer Options")));
            }
            if ((currentTime = System.currentTimeMillis()) - this.lastCheckTime >= updateDelay) {
                class_746 player = client.field_1724;
                if (player != null) {
                    new RedstoneSignalChecker(this.receivedRedstonePowerMap, this.emittedRedstonePowerMap, this.isChecking, this.executorService, showReceives, showEmits, radius, this.precomputedPositions).checkRedstoneAroundPlayer(player);
                }
                this.lastCheckTime = currentTime;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            ClientPlayNetworking.send((class_8710)new ModPresencePayload());
            ClientPlayNetworking.send((class_8710)new ModStatusPayload(modEnabled));
            this.sendRadiusToServer(radius);
            this.sendUpdateDelayToServer(updateDelay);
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> {
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player != null) {
                RedstoneSignalRenderer.renderRedstoneSignals(context.matrixStack(), player, modEnabled, this.receivedRedstonePowerMap, this.emittedRedstonePowerMap, showReceives, showEmits);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(BatchRedstoneSignalPayload.ID, (payload, context) -> context.client().execute(() -> {
            for (RedstoneSignalTracker.RedstoneSignalData signal : payload.signals()) {
                switch (signal.type()) {
                    case COMPARATOR: {
                        if (signal.signal() == -1) {
                            comparatorSignalMap.remove(signal.blockPos());
                            break;
                        }
                        ComparatorData existingData = comparatorSignalMap.get(signal.blockPos());
                        if (existingData != null && existingData.signal == signal.signal() && existingData.isSubtractMode == signal.isSubtractMode()) break;
                        comparatorSignalMap.put(signal.blockPos(), new ComparatorData(signal.signal(), signal.isSubtractMode()));
                        break;
                    }
                    case RECEIVE: {
                        if (signal.signal() == -1) {
                            this.receivedRedstonePowerMap.remove(signal.blockPos());
                            break;
                        }
                        this.receivedRedstonePowerMap.put(signal.blockPos(), new SignalData(signal.signal()));
                        break;
                    }
                    case EMIT: {
                        if (signal.signal() == -1) {
                            this.emittedRedstonePowerMap.remove(signal.blockPos());
                            break;
                        }
                        this.emittedRedstonePowerMap.put(signal.blockPos(), new SignalData(signal.signal()));
                    }
                }
            }
        }));
    }

    public synchronized void recalculatePrecomputedPositions() {
        this.precomputedPositions = this.precomputePositions(radius);
    }

    private List<class_2338> precomputePositions(int radius) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        int radiusSquared = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x * x + y * y + z * z > radiusSquared) continue;
                    positions.add(new class_2338(x, y, z));
                }
            }
        }
        return positions;
    }

    public static RedstoneSignalVisualizerClient getInstance() {
        return INSTANCE;
    }

    public static void setModEnabled(boolean enabled) {
        RedstoneSignalVisualizerClient instance;
        modEnabled = enabled;
        if (!enabled && (instance = RedstoneSignalVisualizerClient.getInstance()) != null) {
            instance.receivedRedstonePowerMap.clear();
            instance.emittedRedstonePowerMap.clear();
            comparatorSignalMap.clear();
        }
        ClientPlayNetworking.send((class_8710)new ModStatusPayload(enabled));
    }

    public static void setColorDefault(int c) {
        SignalColor.DEFAULT.setValue(c);
    }

    public static void setColorObstructed(int c) {
        SignalColor.OBSTRUCTED.setValue(c);
    }

    public static void setColorEmitter(int c) {
        SignalColor.EMITTER.setValue(c);
    }

    public static int getColorDefault() {
        return SignalColor.DEFAULT.getValue();
    }

    public static int getColorObstructed() {
        return SignalColor.OBSTRUCTED.getValue();
    }

    public static int getColorEmitter() {
        return SignalColor.EMITTER.getValue();
    }

    public static Map<class_2338, ComparatorData> getComparatorSignals() {
        return comparatorSignalMap;
    }

    public void sendRadiusToServer(int radius) {
        ClientPlayNetworking.send((class_8710)new RadiusSettingPayload(radius));
    }

    public void sendUpdateDelayToServer(long updateDelay) {
        ClientPlayNetworking.send((class_8710)new UpdateDelaySettingPayload(updateDelay));
    }

    public static SignalData getReceivedSignalData(class_2338 pos) {
        return RedstoneSignalVisualizerClient.getInstance().receivedRedstonePowerMap.get(pos);
    }

    @Environment(value=EnvType.CLIENT)
    public static class SignalData {
        public final int signal;
        public long lastSeenTimestamp;

        public SignalData(int signal) {
            this.signal = signal;
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public void refresh() {
            this.lastSeenTimestamp = System.currentTimeMillis();
        }

        public boolean isStale(long timeout) {
            return System.currentTimeMillis() - this.lastSeenTimestamp > timeout;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ComparatorData {
        public final int signal;
        public final boolean isSubtractMode;

        public ComparatorData(int signal, boolean isSubtractMode) {
            this.signal = signal;
            this.isSubtractMode = isSubtractMode;
        }
    }
}

