/*
 * Decompiled with CFR 0.152.
 */
package binge.software.redstoneSignalVisualizer.client;

import binge.software.redstoneSignalVisualizer.client.RedstoneSignalVisualizerClient;
import binge.software.redstoneSignalVisualizer.client.SignalColor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class VisualizerSettings {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("redstone_visualizer.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean modEnabled;
    public int radius;
    public long updateDelay;
    public boolean showEmits;
    public boolean showReceives;
    public int colorDefault;
    public int colorObstructed;
    public int colorEmitter;
    public boolean showComparators;
    public boolean stackSignals;
    public int colorComparatorSubtract;
    public int colorComparatorNormal;

    public static void saveSettings() {
        VisualizerSettings settings = new VisualizerSettings();
        settings.modEnabled = RedstoneSignalVisualizerClient.modEnabled;
        settings.radius = RedstoneSignalVisualizerClient.radius;
        settings.updateDelay = RedstoneSignalVisualizerClient.updateDelay;
        settings.showEmits = RedstoneSignalVisualizerClient.showEmits;
        settings.showReceives = RedstoneSignalVisualizerClient.showReceives;
        settings.colorDefault = SignalColor.DEFAULT.getValue();
        settings.colorObstructed = SignalColor.OBSTRUCTED.getValue();
        settings.colorEmitter = SignalColor.EMITTER.getValue();
        settings.showComparators = RedstoneSignalVisualizerClient.showComparators;
        settings.colorComparatorSubtract = SignalColor.COMPARATOR_SUBTRACT.getValue();
        settings.colorComparatorNormal = SignalColor.COMPARATOR_NORMAL.getValue();
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)settings), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save redstone visualizer settings: " + e.getMessage());
        }
    }

    public static void loadSettings() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                VisualizerSettings settings = (VisualizerSettings)GSON.fromJson(json, VisualizerSettings.class);
                RedstoneSignalVisualizerClient.modEnabled = settings.modEnabled;
                RedstoneSignalVisualizerClient.radius = settings.radius;
                RedstoneSignalVisualizerClient.updateDelay = settings.updateDelay;
                RedstoneSignalVisualizerClient.showEmits = settings.showEmits;
                RedstoneSignalVisualizerClient.showReceives = settings.showReceives;
                SignalColor.DEFAULT.setValue(settings.colorDefault);
                SignalColor.OBSTRUCTED.setValue(settings.colorObstructed);
                SignalColor.EMITTER.setValue(settings.colorEmitter);
                RedstoneSignalVisualizerClient.showComparators = settings.showComparators;
                SignalColor.COMPARATOR_NORMAL.setValue(settings.colorComparatorNormal);
                SignalColor.COMPARATOR_SUBTRACT.setValue(settings.colorComparatorSubtract);
            }
        }
        catch (JsonSyntaxException | IOException e) {
            System.err.println("Failed to load redstone visualizer settings: " + e.getMessage());
        }
    }
}

