package com.craftycorvid.improvedSigns.mixin;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1822;
import net.minecraft.class_1827;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.craftycorvid.improvedSigns.ImprovedSignsMod.MOD_CONFIG;


@Mixin(class_1822.class)
public class SignItemMixin extends class_1827 {
    public SignItemMixin(class_2248 standingBlock, class_2248 wallBlock,
            class_2350 verticalAttachmentDirection, net.minecraft.class_1792.class_1793 settings) {
        super(standingBlock, wallBlock, verticalAttachmentDirection, settings);
    }

    @Inject(method = "postPlacement", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/block/AbstractSignBlock;openEditScreen(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/block/entity/SignBlockEntity;Z)V"),
            cancellable = true)
    protected void postPlacement(class_2338 pos, class_1937 world, @Nullable class_1657 player,
            class_1799 stack, class_2680 state, CallbackInfoReturnable<Boolean> info) {
        Optional<class_2487> optNbtCompound =
                stack.method_58695(class_9334.field_49628, class_9279.field_49302).method_57461()
                        .method_10562("BlockEntityTag");
        if (optNbtCompound.isPresent()) {
            info.cancel();
        }
    }

    @Inject(at = @At(value = "INVOKE",
            target = "Lnet/minecraft/block/AbstractSignBlock;openEditScreen(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/block/entity/SignBlockEntity;Z)V"),
            method = "postPlacement", cancellable = true)
    private void onPlacement(final class_2338 pos, final class_1937 world, final class_1657 player,
            final class_1799 stack, final class_2680 state,
            final CallbackInfoReturnable<Boolean> info) {
        if (MOD_CONFIG.disableSignEditOnPlace)
            info.cancel();
    }
}
