/*
 * Decompiled with CFR 0.152.
 */
package com.craftycorvid.improvedSigns.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private static final File configFile = FabricLoader.getInstance().getConfigDir().resolve("improved-signs.json").toFile();
    public boolean disableSignEditOnPlace = false;
    public boolean enableSignPassthrough = true;
    public boolean enableSignRetain = true;
    public boolean enableSignCopy = true;
    public boolean serverSideSignTextPreview = true;
    public boolean retainDyeOnSignCopy = false;
    public boolean enableFramePassthrough = true;
    public boolean enableInvisibleFrames = true;
    public InvisibleFrameEnum invisibleFrameItem = InvisibleFrameEnum.AMETHYST_SHARD;

    public static ModConfig loadConfig() {
        ModConfig config = null;
        if (configFile.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));){
                config = (ModConfig)gson.fromJson((Reader)fileReader, ModConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("[improved-signs] Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new ModConfig();
        }
        config.saveConfig();
        return config;
    }

    public void saveConfig() {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static enum InvisibleFrameEnum {
        AMETHYST_SHARD,
        GLASS_PANE;

    }
}

