/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common;

import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.EventBus;
import sh.okx.civmodern.common.gui.screen.MainConfigScreen;
import sh.okx.civmodern.common.macro.AttackMacro;
import sh.okx.civmodern.common.macro.HoldKeyMacro;
import sh.okx.civmodern.common.macro.IceRoadMacro;
import sh.okx.civmodern.common.radar.Radar;

public abstract class AbstractCivModernMod {
    private static AbstractCivModernMod INSTANCE;
    private static final Logger LOGGER;
    private final class_304 configBinding;
    private final class_304 holdLeftBinding;
    private final class_304 holdRightBinding;
    private final class_304 iceRoadBinding;
    private final class_304 attackBinding;
    private CivMapConfig config;
    private ColourProvider colourProvider;
    private Radar radar;
    private HoldKeyMacro leftMacro;
    private HoldKeyMacro rightMacro;
    private IceRoadMacro iceRoadMacro;
    private AttackMacro attackMacro;
    public final EventBus eventBus = new EventBus("CivModernEvents");

    public AbstractCivModernMod() {
        this.configBinding = new class_304("key.civmodern.config", class_3675.class_307.field_1668, 82, "category.civmodern");
        this.holdLeftBinding = new class_304("key.civmodern.left", class_3675.class_307.field_1668, 45, "category.civmodern");
        this.holdRightBinding = new class_304("key.civmodern.right", class_3675.class_307.field_1668, 61, "category.civmodern");
        this.iceRoadBinding = new class_304("key.civmodern.ice", class_3675.class_307.field_1668, 259, "category.civmodern");
        this.attackBinding = new class_304("key.civmodern.attack", class_3675.class_307.field_1668, 48, "category.civmodern");
        if (INSTANCE != null) {
            throw new IllegalStateException("AbstractCivModernMod initialised twice");
        }
        INSTANCE = this;
    }

    public final void init() {
        this.registerKeyBinding(this.configBinding);
        this.registerKeyBinding(this.holdLeftBinding);
        this.registerKeyBinding(this.holdRightBinding);
        this.registerKeyBinding(this.attackBinding);
        this.registerKeyBinding(this.iceRoadBinding);
    }

    public final void enable() {
        this.loadConfig();
        this.loadRadar();
        this.eventBus.register(this);
        class_315 options = class_310.method_1551().field_1690;
        this.leftMacro = new HoldKeyMacro(this, this.holdLeftBinding, options.field_1886);
        this.rightMacro = new HoldKeyMacro(this, this.holdRightBinding, options.field_1904);
        this.iceRoadMacro = new IceRoadMacro(this, this.config, this.iceRoadBinding);
        this.attackMacro = new AttackMacro(this, this.attackBinding, options.field_1886);
    }

    public abstract void registerKeyBinding(class_304 var1);

    @Subscribe
    private void tick(@NotNull ClientTickEvent event) {
        while (this.configBinding.method_1436()) {
            class_310.method_1551().method_1507(this.newConfigGui(null));
        }
    }

    private void loadConfig() {
        Properties properties = new Properties();
        Path gameDir = class_310.method_1551().field_1697.toPath();
        File configFile = gameDir.resolve("config").resolve("civmodern.properties").toFile();
        try {
            if (!configFile.exists()) {
                InputStream resource = AbstractCivModernMod.class.getResourceAsStream("/civmodern.properties");
                byte[] buffer = new byte[resource.available()];
                resource.read(buffer);
                FileOutputStream fos = new FileOutputStream(configFile);
                fos.write(buffer);
            }
            FileInputStream input = new FileInputStream(configFile);
            properties.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.config = new CivMapConfig(configFile, properties);
    }

    private void loadRadar() {
        this.colourProvider = new ColourProvider(this.config);
        this.radar = new Radar(this.config, this.eventBus, this.colourProvider);
    }

    public ColourProvider getColourProvider() {
        return this.colourProvider;
    }

    @NotNull
    public class_437 newConfigGui(class_437 previousScreen) {
        return new MainConfigScreen(this.config, this.colourProvider, previousScreen);
    }

    public static AbstractCivModernMod getInstance() {
        return INSTANCE;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

