/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.screen;

import java.text.DecimalFormat;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.gui.Alignment;
import sh.okx.civmodern.common.gui.DoubleValue;
import sh.okx.civmodern.common.gui.screen.AbstractConfigScreen;
import sh.okx.civmodern.common.gui.screen.MainConfigScreen;
import sh.okx.civmodern.common.gui.widget.ColourTextEditBox;
import sh.okx.civmodern.common.gui.widget.DoubleOptionUpdateableSliderWidget;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;
import sh.okx.civmodern.common.gui.widget.TextRenderable;
import sh.okx.civmodern.common.gui.widget.ToggleButton;
import sh.okx.civmodern.common.mixins.ScreenAccessor;

final class RadarConfigScreen
extends AbstractConfigScreen {
    public static final class_2960 ROLLBACK_ICON = class_2960.method_43902((String)"civmodern", (String)"gui/rollback.png");
    private final ColourProvider colourProvider;
    private HsbColourPicker bgPicker;
    private HsbColourPicker fgPicker;

    public RadarConfigScreen(@NotNull CivMapConfig config, @NotNull ColourProvider colourProvider, @NotNull MainConfigScreen parent) {
        super(config, Objects.requireNonNull(parent), (class_2561)class_2561.method_43471((String)"civmodern.screen.radar.title"));
        this.colourProvider = Objects.requireNonNull(colourProvider);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37060(new TextRenderable.CentreAligned(this.field_22793, this.centreX, this.getHeaderY(), this.field_22785));
        int leftSideX = this.centreX - 5 - 150;
        int rightSideX = this.centreX + 5;
        int offsetY = this.getBodyY(this.field_22790 / 8);
        this.bgPicker = this.addColourPicker(leftSideX, offsetY + 190, 0xE8E3E3, (class_2561)class_2561.method_43470((String)"Background colour"), this.config::getRadarBgColour, this.config::setRadarBgColour, this.colourProvider::setTemporaryRadarBackgroundColour);
        this.fgPicker = this.addColourPicker(rightSideX, offsetY + 190, 852482, (class_2561)class_2561.method_43470((String)"Line colour"), this.config::getRadarColour, this.config::setRadarColour, this.colourProvider::setTemporaryRadarForegroundColour);
        this.method_37063((class_364)new ToggleButton(this.centreX - 75, offsetY, 150, (class_2561)class_2561.method_43471((String)"civmodern.screen.radar.enabled"), this.config::isRadarEnabled, this.config::setRadarEnabled, class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.screen.radar.enabled.tooltip")), ToggleButton.DEFAULT_NARRATION));
        offsetY += 24;
        this.method_37063((class_364)new ToggleButton(leftSideX, offsetY, 150, (class_2561)class_2561.method_43471((String)"civmodern.screen.radar.messages"), this.config::isPingEnabled, this.config::setPingEnabled, class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.screen.radar.messages.tooltip")), ToggleButton.DEFAULT_NARRATION));
        this.method_37063((class_364)new ToggleButton(rightSideX, offsetY, 150, (class_2561)class_2561.method_43471((String)"civmodern.screen.radar.pings"), this.config::isPingSoundEnabled, this.config::setPingSoundEnabled, class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.screen.radar.pings.tooltip")), ToggleButton.DEFAULT_NARRATION));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)"civmodern.screen.radar.alignment", (Object[])new Object[]{this.config.getAlignment().toString()}), button -> {
            Alignment next = this.config.getAlignment().next();
            this.config.setAlignment(next);
            button.method_25355((class_2561)class_2561.method_43469((String)"civmodern.screen.radar.alignment", (Object[])new Object[]{next.toString()}));
        }).method_46433(leftSideX, offsetY += 24).method_46431());
        this.method_37063((class_364)new ToggleButton(rightSideX, offsetY, 150, (class_2561)class_2561.method_43471((String)"civmodern.screen.radar.items"), this.config::isShowItems, this.config::setShowItems, class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.screen.radar.items.tooltip")), ToggleButton.DEFAULT_NARRATION));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(rightSideX, offsetY += 24, 150, 20, 0.0, 1.0, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("##%");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getTransparency();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setTransparency((float)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.transparency", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(leftSideX, offsetY, 150, 20, 0.0, 1.0, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("##%");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getBackgroundTransparency();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setBackgroundTransparency((float)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.background_transparency", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(leftSideX, offsetY += 24, 150, 20, 0.5, 2.0, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("#.#");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getIconSize();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setIconSize((float)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.iconsize", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(rightSideX, offsetY, 150, 20, 0.0, 2.0, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("#.#");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getTextSize();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setTextSize((float)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.textsize", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(leftSideX, offsetY += 24, 150, 20, 25.0, 250.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRadarSize();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRadarSize((int)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.size", (Object[])new Object[]{Integer.toString((int)value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(rightSideX, offsetY, 150, 20, 1.0, 8.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRadarCircles();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRadarCircles((int)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.circles", (Object[])new Object[]{Integer.toString((int)value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(leftSideX, offsetY += 24, 150, 20, 0.0, 300.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getX();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setX((int)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.x", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(rightSideX, offsetY, 150, 20, 0.0, 300.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getY();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setY((int)value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.y", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.method_37063((class_364)new DoubleOptionUpdateableSliderWidget(leftSideX, offsetY += 24, 150, 20, 20.0, 150.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRange();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRange(value);
            }

            @Override
            @NotNull
            public class_2561 getText(double value) {
                return class_2561.method_43469((String)"civmodern.screen.radar.range", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)"civmodern.screen.radar.log", (Object[])new Object[]{this.config.isRadarLogarithm() ? class_2561.method_43471((String)"civmodern.screen.radar.log.logarithmic") : class_2561.method_43471((String)"civmodern.screen.radar.log.linear")}), button -> {
            this.config.setRadarLogarithm(!this.config.isRadarLogarithm());
            button.method_25355((class_2561)class_2561.method_43469((String)"civmodern.screen.radar.log", (Object[])new Object[]{this.config.isRadarLogarithm() ? class_2561.method_43471((String)"civmodern.screen.radar.log.logarithmic") : class_2561.method_43471((String)"civmodern.screen.radar.log.linear")}));
        }).method_46433(rightSideX, offsetY).method_46431());
        offsetY += 24;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            this.config.save();
            class_310.method_1551().method_1507(this.parent);
        }).method_46433(this.centreX - 75, this.getFooterY(offsetY += 32)).method_46431());
    }

    @NotNull
    private HsbColourPicker addColourPicker(int offsetX, int offsetY, int defaultColour, @NotNull class_2561 label, @NotNull IntSupplier colourGetter, @NotNull IntConsumer colourSetter, @NotNull Consumer<Integer> preview) {
        int innerCenterX = offsetX + 75;
        this.method_37060(new TextRenderable.CentreAligned(this.field_22793, innerCenterX, offsetY, label));
        Objects.requireNonNull(this.field_22793);
        ColourTextEditBox colourEditBox = (ColourTextEditBox)this.method_37063((class_364)new ColourTextEditBox(this.field_22793, innerCenterX - 30, offsetY += 9 + 2, 60, 20, colourGetter, colourSetter));
        HsbColourPicker hsb = (HsbColourPicker)this.method_37063((class_364)new HsbColourPicker(innerCenterX - 30 - 4 - 20, offsetY, 20, 20, colourGetter.getAsInt(), colour -> {
            colourEditBox.setColourFromInt((int)colour);
            colourSetter.accept((int)colour);
        }, preview, this::closePickers));
        this.method_37063((class_364)new ImageButton(innerCenterX + 30 + 4, offsetY, 20, 20, ROLLBACK_ICON, button -> {
            colourEditBox.setColourFromInt(defaultColour);
            colourSetter.accept(defaultColour);
            hsb.close();
        }));
        return hsb;
    }

    @Override
    public void method_25419() {
        this.config.save();
        this.colourProvider.setTemporaryRadarBackgroundColour(null);
        this.colourProvider.setTemporaryRadarForegroundColour(null);
        super.method_25419();
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        if (this.fgPicker != null) {
            this.fgPicker.method_16014(mouseX, mouseY);
        }
        if (this.bgPicker != null) {
            this.bgPicker.method_16014(mouseX, mouseY);
        }
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).civmodern$getRenderables()) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    private void closePickers() {
        if (this.fgPicker != null) {
            this.fgPicker.close();
        }
        if (this.bgPicker != null) {
            this.bgPicker.close();
        }
    }
}

