/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_10868;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import sh.okx.civmodern.common.gui.Texture;
import sh.okx.civmodern.common.gui.widget.HUSLColorConverter;

public class HsbColourPicker
extends class_339 {
    private static final class_2960 COLOUR_PICKER_ICON = class_2960.method_60655((String)"civmodern", (String)"gui/colour.png");
    private final class_10868 hueSelector;
    private final GpuTextureView hueSelectorTextureView;
    private final class_10868 saturationBrightnessTexture;
    private final GpuTextureView saturationBrightnessTextureView;
    private final Consumer<Integer> colourConsumer;
    private final Consumer<Integer> previewConsumer;
    private int hue = 0;
    private boolean mouseOverGrid = false;
    private boolean showPalette = false;
    private boolean updateTexture = true;
    private boolean hueMouseDown = false;
    private final Runnable closeable;
    private int renderY;
    private boolean rvisible = true;

    public HsbColourPicker(int x, int y, int width, int height, int colour, Consumer<Integer> colourConsumer, Consumer<Integer> previewConsumer, Runnable closeable) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"HSB Colour Picker"));
        this.hue = this.getHue(colour);
        this.closeable = closeable;
        this.hueSelector = this.getHueSelector();
        this.hueSelectorTextureView = RenderSystem.getDevice().createTextureView((GpuTexture)this.hueSelector);
        this.saturationBrightnessTexture = (class_10868)RenderSystem.getDevice().createTexture("satb", 5, TextureFormat.RGBA8, 101, 101, 1, 1);
        this.saturationBrightnessTextureView = RenderSystem.getDevice().createTextureView((GpuTexture)this.saturationBrightnessTexture);
        this.colourConsumer = colourConsumer;
        this.previewConsumer = previewConsumer;
    }

    public void setRVisible(boolean rvisible) {
        this.rvisible = rvisible;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.rvisible) {
            return;
        }
        this.renderY = this.method_46427() + 101 > class_310.method_1551().method_22683().method_4502() ? this.method_46427() - 101 - this.field_22759 : this.method_46427();
        guiGraphics.method_25291(class_10799.field_56883, COLOUR_PICKER_ICON, this.method_46426(), this.method_46427(), 0.0f, this.method_25367() ? 20.0f : 0.0f, this.field_22758, this.field_22759, 20, 40, -1);
        if (this.showPalette) {
            if (this.updateTexture) {
                this.updateTexture(this.hue);
                this.updateTexture = false;
            }
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)this.method_46426(), (float)(this.renderY + this.field_22759));
            guiGraphics.field_59826.method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)this.saturationBrightnessTextureView), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), 0, 0, 101, 101, 0.0f, 1.0f, 0.0f, 1.0f, -1, guiGraphics.field_44659.method_70863()));
            guiGraphics.field_59826.method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)this.hueSelectorTextureView), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), 106, 0, 116, 101, 0.0f, 1.0f, 0.0f, 1.0f, -1, guiGraphics.field_44659.method_70863()));
            float hueOffset = (float)this.hue / 360.0f * 100.0f;
            int cursorX = 106;
            int cursorY = (int)hueOffset;
            guiGraphics.method_25294(cursorX, cursorY, cursorX + 10, cursorY + 1, -1);
            guiGraphics.method_51448().popMatrix();
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.previewConsumer != null) {
            if (this.field_22763 && this.field_22764 && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
                int saturation = (int)(mouseX - (double)this.method_46426());
                int brightness = (int)(mouseY - (double)this.renderY - (double)this.field_22759);
                this.mouseOverGrid = true;
                this.previewConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            } else if (this.mouseOverGrid) {
                this.previewConsumer.accept(null);
            }
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.showPalette) {
            this.closeable.run();
        }
        this.showPalette = !this.showPalette;
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.hueMouseDown) {
            this.setHue(mouseX, mouseY, 0, true);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        if (super.method_25405(mouseX, mouseY)) {
            return true;
        }
        return this.field_22763 && this.field_22764 && this.showPalette && (this.isOverGrid(mouseX, mouseY) || mouseY >= (double)(this.renderY + this.field_22759) && mouseY <= (double)(this.renderY + this.field_22759 + 101) && mouseX >= (double)(this.method_46426() + 106) && mouseX <= (double)(this.method_46426() + 106 + 10));
    }

    public void method_25357(double d, double e) {
        this.hueMouseDown = false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.selectColour(mouseX, mouseY, button) || this.setHue(mouseX, mouseY, button, false) || super.method_25402(mouseX, mouseY, button);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private boolean selectColour(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && button == 0 && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
            int saturation = (int)(mouseX - (double)this.method_46426());
            int brightness = (int)(mouseY - (double)this.renderY - (double)this.field_22759);
            this.colourConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            this.showPalette = false;
            return true;
        }
        return false;
    }

    private boolean setHue(double mouseX, double mouseY, int button, boolean force) {
        if (this.field_22763 && this.field_22764 && button == 0 && this.showPalette) {
            if (!(force || mouseY >= (double)(this.renderY + this.field_22759) && mouseY <= (double)(this.renderY + this.field_22759 + 101))) {
                return false;
            }
            if (force || mouseX >= (double)(this.method_46426() + 106) && mouseX <= (double)(this.method_46426() + 106 + 10)) {
                this.hueMouseDown = true;
                double yOffset = mouseY - (double)(this.renderY + this.field_22759);
                int newHue = class_3532.method_15340((int)((int)(yOffset / 102.0 * 360.0)), (int)0, (int)360);
                if (newHue != this.hue) {
                    this.hue = newHue;
                    this.updateTexture = true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isOverGrid(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + 101) && mouseY >= (double)(this.renderY + this.field_22759) && mouseY < (double)(this.renderY + this.field_22759 + 101);
    }

    private void updateTexture(int hue) {
        class_1011 n = new class_1011(101, 101, false);
        for (int saturation = 0; saturation <= 100; ++saturation) {
            for (int brightness = 0; brightness <= 100; ++brightness) {
                int rgb = this.toRgb(hue, saturation, brightness) & 0xFFFFFF;
                n.method_61941(saturation, brightness, 0xFF000000 | rgb);
            }
        }
        this.saturationBrightnessTexture.setAddressMode(AddressMode.CLAMP_TO_EDGE);
        this.saturationBrightnessTexture.setUseMipmaps(false);
        RenderSystem.getDevice().createCommandEncoder().writeToTexture((GpuTexture)this.saturationBrightnessTexture, n);
    }

    private int toRgb(int hue, int sat, int bright) {
        double[] rgbArr = HUSLColorConverter.hsluvToRgb(new double[]{hue, sat, bright});
        return (int)(rgbArr[0] * 255.0) << 16 | (int)(rgbArr[1] * 255.0) << 8 | (int)(rgbArr[2] * 255.0);
    }

    private int getHue(int colour) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        return (int)Math.round(HUSLColorConverter.rgbToHsluv(new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0})[0]);
    }

    private class_10868 getHueSelector() {
        class_10868 hueSelector = (class_10868)RenderSystem.getDevice().createTexture("hue", 5, TextureFormat.RGBA8, 1, 360, 1, 1);
        int[] rgbaValues = new int[360];
        for (int i = 0; i < 360; ++i) {
            int rgb = this.toRgb(i, 100, 50);
            rgbaValues[i] = rgb << 8 | 0xFF;
        }
        Texture t = new Texture(hueSelector.method_68427(), 1, 360);
        t.setPixels(rgbaValues);
        t.update();
        return hueSelector;
    }

    public void close() {
        this.showPalette = false;
        this.saturationBrightnessTextureView.close();
    }
}

