/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_638;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.BlockStateChangeEvent;
import sh.okx.civmodern.common.events.ChatReceivedEvent;
import sh.okx.civmodern.common.events.ChunkLoadEvent;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.JoinEvent;
import sh.okx.civmodern.common.events.LeaveEvent;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;
import sh.okx.civmodern.common.events.RespawnEvent;
import sh.okx.civmodern.common.events.WorldRenderLastEvent;
import sh.okx.civmodern.common.map.MapCache;
import sh.okx.civmodern.common.map.MapFolder;
import sh.okx.civmodern.common.map.Minimap;
import sh.okx.civmodern.common.map.RenderQueue;
import sh.okx.civmodern.common.map.converters.JourneymapConverter;
import sh.okx.civmodern.common.map.converters.VoxelMapConverter;
import sh.okx.civmodern.common.map.screen.ImportAvailable;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoints;
import sh.okx.civmodern.common.map.waypoints.Waypoints;
import sh.okx.civmodern.common.mixins.StorageSourceAccessor;

public class WorldListener {
    private final CivMapConfig config;
    private final ColourProvider provider;
    private MapCache cache;
    private MapFolder file;
    private Minimap minimap;
    private Waypoints waypoints;
    private Thread converter = null;
    private long seed = -1L;
    private PlayerWaypoints playerWaypoints;
    private final List<class_1923> loadedChunks = new ArrayList<class_1923>();

    public WorldListener(CivMapConfig config, ColourProvider colourProvider) {
        this.config = config;
        this.provider = colourProvider;
    }

    @Subscribe
    public void onLoad(JoinEvent event) {
        String name;
        String type;
        long tempSeed = this.seed;
        this.onUnload(null);
        this.setSeed(tempSeed);
        if (this.seed == -1L) {
            AbstractCivModernMod.LOGGER.warn("World seed is not set");
            return;
        }
        if (class_310.method_1551().method_1542()) {
            type = "sp";
            name = ((StorageSourceAccessor)class_310.method_1551().method_1576()).getStorageSource().method_27005();
        } else {
            type = "mp";
            name = class_310.method_1551().method_1558().field_3761;
        }
        class_638 level = class_310.method_1551().field_1687;
        String dimension = level.method_27983().method_29177().method_12832();
        Path civmapFolder = class_310.method_1551().field_1697.toPath().resolve("civmap");
        File mapDirectory = civmapFolder.resolve(type).resolve(name.replace(":", "_")).resolve(dimension).resolve(String.valueOf(this.seed)).toFile();
        String oldType = type.equals("sp") ? "c" : "s";
        File oldMapDirectory = civmapFolder.resolve(oldType).resolve(name.replace(":", "_")).resolve(dimension).toFile();
        if (!mapDirectory.exists() && oldMapDirectory.exists()) {
            AbstractCivModernMod.LOGGER.info("Migrating map folder from old structure: " + oldMapDirectory.getAbsolutePath() + " to " + mapDirectory.getAbsolutePath());
            mapDirectory.mkdirs();
            File oldSqliteFile = oldMapDirectory.toPath().resolve("map.sqlite").toFile();
            File newSqliteFile = mapDirectory.toPath().resolve("map.sqlite").toFile();
            boolean sqliteResult = oldSqliteFile.renameTo(newSqliteFile);
            if (!sqliteResult) {
                AbstractCivModernMod.LOGGER.warn("Failed to move sqlite file from " + oldSqliteFile.getAbsolutePath() + " to " + newSqliteFile.getAbsolutePath());
            } else {
                AbstractCivModernMod.LOGGER.info("Moved sqlite file from " + oldSqliteFile.getAbsolutePath() + " to " + newSqliteFile.getAbsolutePath());
            }
            AbstractCivModernMod.LOGGER.info("Finished migrating map folder from old structure");
        } else {
            mapDirectory.mkdirs();
        }
        this.file = new MapFolder(mapDirectory);
        this.waypoints = new Waypoints(this.file.getConnection());
        this.playerWaypoints = new PlayerWaypoints();
        ArrayList<String> importableMapMods = new ArrayList<String>();
        if (this.file.getHistory().settings.enableImportPrompt) {
            VoxelMapConverter voxelMapConverter = new VoxelMapConverter(this.file, name, dimension, level.method_30349());
            JourneymapConverter journeymapConverter = new JourneymapConverter(this.file, name, dimension, level.method_30349());
            if (!voxelMapConverter.hasAlreadyConverted() && voxelMapConverter.filesAvailable()) {
                importableMapMods.add("VoxelMap");
            }
            if (!journeymapConverter.hasAlreadyConverted() && journeymapConverter.filesAvailable()) {
                importableMapMods.add("Journeymap");
            }
            if (!importableMapMods.isEmpty()) {
                class_310.method_1551().method_1507((class_437)new ImportAvailable(importableMapMods.toArray(new String[0]), mod -> {
                    this.converter = new Thread(() -> {
                        try {
                            switch (mod) {
                                case "VoxelMap": {
                                    voxelMapConverter.convert();
                                    break;
                                }
                                case "Journeymap": {
                                    journeymapConverter.convert();
                                    break;
                                }
                                case "close": {
                                    return;
                                }
                                case "neverShowAgain": {
                                    this.file.getHistory().settings.enableImportPrompt = false;
                                    this.file.saveHistory();
                                    return;
                                }
                                default: {
                                    AbstractCivModernMod.LOGGER.warn("Unknown mod for import: " + mod);
                                    return;
                                }
                            }
                            class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)"Import Done"), (class_2561)class_2561.method_43470((String)("CivMap has finished importing " + mod))));
                        }
                        finally {
                            class_310.method_1551().execute(() -> {
                                this.cache = new MapCache(this.file);
                                this.minimap = new Minimap(this.waypoints, this.playerWaypoints, this.cache, this.config, this.provider);
                                for (class_1923 chunk : this.loadedChunks) {
                                    class_2818 levelChunk = level.method_8497(chunk.field_9181, chunk.field_9180);
                                    if (levelChunk == null) continue;
                                    this.cache.updateChunk(levelChunk);
                                }
                                this.loadedChunks.clear();
                            });
                        }
                    }, "Map converter");
                    this.converter.start();
                }));
                return;
            }
        }
        AbstractCivModernMod.LOGGER.info("No mods available for import, using existing map data");
        this.converter = null;
        this.cache = new MapCache(this.file);
        this.minimap = new Minimap(this.waypoints, this.playerWaypoints, this.cache, this.config, this.provider);
    }

    @Subscribe
    public void onUnload(LeaveEvent event) {
        if (this.converter != null && this.converter.isAlive()) {
            this.converter.interrupt();
            try {
                this.converter.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.converter = null;
        if (this.cache != null) {
            this.cache.save();
            this.cache.free();
        }
        this.minimap = null;
        this.cache = null;
        if (this.waypoints != null) {
            this.waypoints.save();
        }
        this.playerWaypoints = null;
        this.waypoints = null;
        if (this.file != null) {
            this.file.close();
        }
        this.file = null;
        this.loadedChunks.clear();
    }

    @Subscribe
    public void onRespawn(RespawnEvent event) {
        this.onLoad(null);
    }

    public MapCache getCache() {
        return this.cache;
    }

    @Subscribe
    public void onChunkLoad(ChunkLoadEvent event) {
        if (this.config.isMappingEnabled()) {
            if (this.cache != null) {
                this.cache.updateChunk(event.chunk());
            } else {
                this.loadedChunks.add(event.chunk().method_12004());
            }
        }
    }

    @Subscribe
    public void onChunkLoad(BlockStateChangeEvent event) {
        if (this.cache != null && this.config.isMappingEnabled()) {
            this.cache.updateChunk(event.level().method_8500(event.pos()));
        }
    }

    @Subscribe
    public void onRender(PostRenderGameOverlayEvent event) {
        RenderQueue.runAll();
        if (this.minimap != null) {
            this.minimap.onRender(event);
        }
    }

    @Subscribe
    public void onRender(WorldRenderLastEvent event) {
        if (this.waypoints != null) {
            this.waypoints.onRender(event);
        }
    }

    @Subscribe
    public void onTick(ClientTickEvent event) {
        if (this.playerWaypoints != null) {
            this.playerWaypoints.tick();
        }
    }

    @Subscribe
    public void onChat(ChatReceivedEvent event) {
        if (this.playerWaypoints != null) {
            this.playerWaypoints.acceptSnitchHit(event.message());
        }
    }

    public void cycleMinimapZoom() {
        if (this.minimap != null) {
            this.minimap.cycleZoom();
        }
    }

    public Waypoints getWaypoints() {
        return this.waypoints;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public PlayerWaypoints getPlayerWaypoints() {
        return this.playerWaypoints;
    }
}

