/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.screen;

import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.renderstate.LineElementRenderState;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11256;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.gui.widget.ImageButton;
import sh.okx.civmodern.common.map.MapCache;
import sh.okx.civmodern.common.map.RegionAtlasTexture;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.screen.EditWaypointModal;
import sh.okx.civmodern.common.map.screen.NewWaypointModal;
import sh.okx.civmodern.common.map.screen.PositionContextMenu;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoint;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoints;
import sh.okx.civmodern.common.map.waypoints.Waypoint;
import sh.okx.civmodern.common.map.waypoints.Waypoints;
import sh.okx.civmodern.common.mixins.ScreenAccessor;
import sh.okx.civmodern.common.navigation.AutoNavigation;
import sh.okx.civmodern.common.rendering.BlitRenderState;
import sh.okx.civmodern.common.rendering.ChevronRenderState;
import sh.okx.civmodern.common.rendering.CivModernPipelines;

public class MapScreen
extends class_437 {
    private static final int BOAT_PREVIEW_LINE_COLOUR = -65536;
    private static float zoom = 1.0f;
    private final AbstractCivModernMod mod;
    private final class_304 key;
    private final MapCache mapCache;
    private final AutoNavigation navigation;
    private final Waypoints waypoints;
    private final PlayerWaypoints playerWaypoints;
    private final CivMapConfig config;
    private NewWaypointModal newWaypointModal;
    private EditWaypointModal editWaypointModal;
    private ImageButton openWaypointButton;
    private PositionContextMenu positionContextMenu;
    private double x;
    private double y;
    private Waypoint hoveredWaypoint;
    private int mouseBlockX;
    private int mouseBlockY;
    private boolean targeting = false;
    private boolean boating = false;
    private Waypoint newWaypoint;
    private final Set<RegionKey> yLevelInterests = new HashSet<RegionKey>();
    private boolean changedConfig = false;

    public MapScreen(AbstractCivModernMod mod, class_304 key, CivMapConfig config, MapCache mapCache, AutoNavigation navigation, Waypoints waypoints, PlayerWaypoints playerWaypoints) {
        super((class_2561)class_2561.method_43471((String)"civmodern.screen.map.title"));
        this.mod = mod;
        this.key = key;
        this.config = config;
        this.mapCache = mapCache;
        this.waypoints = waypoints;
        this.playerWaypoints = playerWaypoints;
        class_1041 window = class_310.method_1551().method_22683();
        this.x = class_310.method_1551().field_1724.method_23317() - (double)((float)window.method_4489() * zoom / 2.0f);
        this.y = class_310.method_1551().field_1724.method_23321() - (double)((float)window.method_4506() * zoom / 2.0f);
        this.navigation = navigation;
    }

    protected void method_25426() {
        ImageButton boatButton = new ImageButton(10, 10, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/boat.png"), imbg -> {
            this.boating = !this.boating;
        });
        boatButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.map.boat.tooltip")));
        this.method_37063((class_364)boatButton);
        this.newWaypointModal = new NewWaypointModal(this.waypoints);
        if (this.newWaypoint == null) {
            class_746 player = class_310.method_1551().field_1724;
            this.newWaypointModal.open("", player.method_31477(), player.method_31478() + 1, player.method_31479());
        } else {
            this.newWaypointModal.open(this.newWaypoint.name(), this.newWaypoint.x(), this.newWaypoint.y(), this.newWaypoint.z());
            this.newWaypointModal.setVisible(true);
        }
        this.editWaypointModal = new EditWaypointModal(this.waypoints);
        this.positionContextMenu = new PositionContextMenu(this.waypoints, this.newWaypointModal);
        this.method_37063(this.positionContextMenu);
        this.openWaypointButton = new ImageButton(this.field_22789 / 2 - 22, 10, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/new.png"), imbg -> {
            if (this.editWaypointModal.isTargeting()) {
                return;
            }
            this.newWaypointModal.setVisible(!this.newWaypointModal.isVisible());
            if (this.newWaypointModal.isVisible()) {
                this.editWaypointModal.setVisible(false);
                this.editWaypointModal.setWaypoint(null);
            }
        });
        this.openWaypointButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.map.newwaypoint.tooltip")));
        this.method_37063((class_364)this.openWaypointButton);
        ImageButton targetButton = new ImageButton(this.field_22789 / 2 + 2, 10, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/target.png"), imbg -> {
            this.waypoints.setTarget(null);
            this.targeting = !this.targeting;
        });
        targetButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.map.highlight.tooltip")));
        this.method_37063((class_364)targetButton);
        this.method_37063(this.newWaypointModal);
        this.method_37063(this.editWaypointModal);
        class_2960 togglePlayersImage = this.config.isPlayerWaypointsEnabled() ? class_2960.method_60655((String)"civmodern", (String)"gui/toggleplayersoff.png") : class_2960.method_60655((String)"civmodern", (String)"gui/toggleplayers.png");
        ImageButton togglePlayers = new ImageButton(this.field_22789 - 30, 10, 20, 20, togglePlayersImage, imbg -> {
            this.config.setPlayerWaypointsEnabled(!this.config.isPlayerWaypointsEnabled());
            this.changedConfig = true;
            if (this.config.isPlayerWaypointsEnabled()) {
                imbg.setImage(class_2960.method_60655((String)"civmodern", (String)"gui/toggleplayersoff.png"));
            } else {
                imbg.setImage(class_2960.method_60655((String)"civmodern", (String)"gui/toggleplayers.png"));
            }
        });
        togglePlayers.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"civmodern.map.players.tooltip")));
        this.method_37063((class_364)togglePlayers);
    }

    public void setNewWaypoint(Waypoint waypoint) {
        this.newWaypoint = waypoint;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        Matrix3x2fStack matrices = guiGraphics.method_51448();
        float scale = (float)class_310.method_1551().method_22683().method_4495() * zoom;
        class_1041 window = class_310.method_1551().method_22683();
        if (!this.positionContextMenu.isVisible()) {
            this.mouseBlockX = (int)Math.floor((double)((float)mouseX * scale) + this.x);
            this.mouseBlockY = (int)Math.floor((double)((float)mouseY * scale) + this.y);
        }
        guiGraphics.method_25294(0, 0, window.method_4489(), window.method_4506(), -16777216);
        ArrayList<BlitRenderState.Renderer> renderers = new ArrayList<BlitRenderState.Renderer>();
        int screenX = 0;
        while ((float)screenX < (float)window.method_4489() * zoom + 4096.0f) {
            int screenY = 0;
            while ((float)screenY < (float)window.method_4506() * zoom + 4096.0f) {
                float realX = (float)this.x + (float)screenX;
                float realY = (float)this.y + (float)screenY;
                float renderX = realX - this.floatMod(realX, 4096.0f);
                float renderY = realY - this.floatMod(realY, 4096.0f);
                RegionKey key = new RegionKey(Math.floorDiv((int)renderX, 4096), Math.floorDiv((int)renderY, 4096));
                RegionAtlasTexture texture = this.mapCache.getTexture(key);
                if (texture != null) {
                    renderers.add(texture.draw(guiGraphics, renderX - (float)this.x, renderY - (float)this.y, scale));
                }
                screenY += 4096;
            }
            screenX += 4096;
        }
        guiGraphics.field_59826.method_70922((class_11256)new BlitRenderState(guiGraphics, (source, stack) -> renderers.forEach(r -> r.render(source, stack))));
        matrices.pushMatrix();
        matrices.translate(0.0f, -1.0f);
        List<Waypoint> waypointList = this.waypoints.getWaypoints();
        HashMap<String, List> waypointByIcon = new HashMap<String, List>();
        for (Waypoint waypoint : waypointList) {
            if (this.editWaypointModal.getWaypoint() == waypoint && this.editWaypointModal.hasChanged()) continue;
            waypointByIcon.computeIfAbsent(waypoint.icon(), k -> new ArrayList()).add(waypoint);
        }
        for (List waypointGroup : waypointByIcon.values()) {
            double z;
            double x;
            for (Waypoint waypoint : waypointGroup) {
                matrices.pushMatrix();
                x = (double)waypoint.x() + 0.5;
                z = (double)waypoint.z() + 0.5;
                matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
                waypoint.render2D(guiGraphics);
                matrices.popMatrix();
                class_1060 textureManager = class_310.method_1551().method_1531();
                class_1044 abstractTexture = textureManager.method_4619(waypoint.resourceLocation());
                abstractTexture.method_4527(true, true);
            }
            for (Waypoint waypoint : waypointGroup) {
                if (waypoint.name().isBlank()) continue;
                matrices.pushMatrix();
                x = (double)waypoint.x() + 0.5;
                z = (double)waypoint.z() + 0.5;
                matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
                class_327 font = class_310.method_1551().field_1772;
                String str = waypoint.name();
                matrices.translate(0.0f, -16.0f);
                class_5250 comp = class_2561.method_43470((String)str);
                guiGraphics.method_51439(font, (class_2561)comp, -font.method_27525((class_5348)comp) / 2, 0, -1, false);
                guiGraphics.method_25294(-font.method_27525((class_5348)comp) / 2, -1, font.method_27525((class_5348)comp) / 2, 9, 0x3F000000);
                matrices.popMatrix();
            }
        }
        if (this.config.isPlayerWaypointsEnabled()) {
            for (PlayerWaypoint waypoint : this.playerWaypoints.getWaypoints()) {
                boolean old = waypoint.timestamp().until(Instant.now(), ChronoUnit.MINUTES) >= 10L;
                int colour = (old ? 119 : 255) << 24 | 0xFFFFFF;
                int bgcolour = (old ? 102 : 204) << 24 | 0xCCCCCC;
                matrices.pushMatrix();
                double x = (double)waypoint.x() + 0.5;
                double z = (double)waypoint.z() + 0.5;
                matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
                waypoint.render(guiGraphics, colour);
                matrices.scale(0.8f, 0.8f);
                class_327 font = class_310.method_1551().field_1772;
                String str = waypoint.playerName();
                matrices.translate(0.0f, -16.0f);
                if (zoom <= 2.0f) {
                    class_5250 comp = class_2561.method_43470((String)str);
                    guiGraphics.method_51439(font, (class_2561)comp, (int)((float)(-font.method_27525((class_5348)comp)) / 2.0f), 0, colour, true);
                    class_5250 comp2 = class_2561.method_43470((String)("(" + MapScreen.getAgo(waypoint.timestamp()) + ")"));
                    guiGraphics.method_51439(font, (class_2561)comp2, (int)((float)(-font.method_27525((class_5348)comp2)) / 2.0f), 24, colour, true);
                }
                matrices.popMatrix();
            }
        }
        if (this.targeting || this.newWaypointModal.isTargeting()) {
            matrices.pushMatrix();
            matrices.translate((float)mouseX, (float)mouseY);
            Waypoint targetWaypoint = new Waypoint("", 0, 0, 0, this.targeting ? "target" : "waypoint", 0xFF0000);
            int transparency = this.newWaypointModal.isTargeting() ? 127 : 255;
            class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(targetWaypoint.resourceLocation());
            abstractTexture.method_4527(true, true);
            targetWaypoint.render2D(guiGraphics, transparency);
            matrices.popMatrix();
        }
        if (this.newWaypointModal.isVisible()) {
            try {
                double x = (double)this.newWaypointModal.getX() + 0.5;
                double z = (double)this.newWaypointModal.getZ() + 0.5;
                matrices.pushMatrix();
                matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
                Waypoint targetWaypoint = new Waypoint("", 0, 0, 0, "waypoint", this.newWaypointModal.getPreviewColour());
                targetWaypoint.render2D(guiGraphics);
                matrices.popMatrix();
                class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(targetWaypoint.resourceLocation());
                abstractTexture.method_4527(true, true);
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if (this.hoveredWaypoint != null) {
            matrices.pushMatrix();
            double x = (double)this.hoveredWaypoint.x() + 0.5;
            double z = (double)this.hoveredWaypoint.z() + 0.5;
            matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
            class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(this.hoveredWaypoint.resourceLocation());
            abstractTexture.method_4527(true, true);
            guiGraphics.method_25291(class_10799.field_56883, class_2960.method_60655((String)"civmodern", (String)"map/focus.png"), -8, -8, 0.0f, 0.0f, 16, 16, 16, 16, -1);
            matrices.popMatrix();
        } else if (!(this.targeting || this.editWaypointModal.isTargeting() || this.newWaypointModal.isTargeting())) {
            matrices.pushMatrix();
            matrices.translate((float)(((double)this.mouseBlockX - this.x) / (double)scale), (float)(((double)this.mouseBlockY - this.y) / (double)scale + 1.0));
            matrices.scale(1.0f / scale, 1.0f / scale);
            int size = 1;
            guiGraphics.method_25291(class_10799.field_56883, class_2960.method_60655((String)"civmodern", (String)"map/focus.png"), 0, 0, 0.0f, 0.0f, size, size, size, size, -1);
            matrices.popMatrix();
        }
        if (this.editWaypointModal.isTargeting() || this.editWaypointModal.getWaypoint() != null && this.editWaypointModal.hasChanged()) {
            matrices.pushMatrix();
            if (this.editWaypointModal.isTargeting()) {
                matrices.translate((float)mouseX, (float)mouseY);
            } else {
                double x = (double)this.editWaypointModal.getX() + 0.5;
                double z = (double)this.editWaypointModal.getZ() + 0.5;
                matrices.translate((float)((x - this.x) / (double)scale), (float)((z - this.y) / (double)scale));
            }
            Waypoint targetWaypoint = new Waypoint("", 0, 0, 0, this.editWaypointModal.getWaypoint().icon(), this.editWaypointModal.getPreviewColour());
            class_1044 abstractTexture = class_310.method_1551().method_1531().method_4619(targetWaypoint.resourceLocation());
            abstractTexture.method_4527(true, true);
            if (this.editWaypointModal.getPreviewColour() != this.editWaypointModal.getColour()) {
                targetWaypoint.render2D(guiGraphics);
            } else {
                targetWaypoint.render2D(guiGraphics, 127);
            }
            class_327 font = class_310.method_1551().field_1772;
            String str = this.editWaypointModal.getName();
            if (!str.isBlank()) {
                matrices.translate(0.0f, -16.0f);
                class_5250 comp = class_2561.method_43470((String)str);
                guiGraphics.method_27535(font, (class_2561)comp, -font.method_27525((class_5348)comp) / 2, 0, -1);
                guiGraphics.method_25294(-font.method_27525((class_5348)comp) / 2, -1, font.method_27525((class_5348)comp) / 2, 9, 0x3F000000);
            }
            matrices.popMatrix();
        }
        class_746 player = class_310.method_1551().field_1724;
        float prx = (float)(player.method_23317() - this.x) / scale;
        float pry = (float)(player.method_23321() - this.y) / scale;
        matrices.pushMatrix();
        int chevron = 0xFF000000 | this.mod.getColourProvider().getChevronColour();
        matrices.translate(prx, pry);
        matrices.scale(4.0f, 4.0f);
        matrices.rotate((float)Math.toRadians(player.method_5705(delta) % 360.0f));
        guiGraphics.field_59826.method_70919((class_11244)new ChevronRenderState(CivModernPipelines.GUI_TRIANGLE_STRIP_BLEND, new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), guiGraphics.field_44659.method_70863(), chevron));
        matrices.popMatrix();
        Deque<class_241> dests = this.navigation.getDestinations();
        if (this.boating || !dests.isEmpty()) {
            float pz;
            float px;
            ArrayList<class_241> points = new ArrayList<class_241>();
            if (player.method_5854() != null) {
                px = (float)class_3532.method_16436((double)delta, (double)player.method_5854().field_6038, (double)player.method_5854().method_23317());
                pz = (float)class_3532.method_16436((double)delta, (double)player.method_5854().field_5989, (double)player.method_5854().method_23321());
            } else {
                px = (float)player.method_23317();
                pz = (float)player.method_23321();
            }
            points.add(new class_241(px, pz));
            points.addAll(dests);
            if (this.boating) {
                points.add(new class_241((float)mouseX * scale + (float)this.x, (float)mouseY * scale + (float)this.y));
            }
            for (int i = 0; i < points.size() - 1; ++i) {
                class_241 from = (class_241)points.get(i);
                class_241 to = (class_241)points.get(i + 1);
                double dx = ((double)to.field_1343 - this.x) / (double)scale - ((double)from.field_1343 - this.x) / (double)scale;
                double dy = ((double)to.field_1342 - this.y) / (double)scale - ((double)from.field_1342 - this.y) / (double)scale;
                float dist = (float)class_3532.method_39241((double)dx, (double)dy) + 0.5f;
                matrices.pushMatrix();
                matrices.translate((float)(((double)to.field_1343 - this.x) / (double)scale), (float)(((double)to.field_1342 - this.y) / (double)scale));
                guiGraphics.method_51448().rotate((float)class_3532.method_15349((double)dx, (double)(-dy)));
                guiGraphics.field_59826.method_70919((class_11244)new LineElementRenderState(CivModernPipelines.GUI_QUADS, new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), guiGraphics.field_44659.method_70863(), 0, 0, 0, (int)dist, 1.0, Color.ofArgb((int)-65536)));
                matrices.popMatrix();
            }
        }
        matrices.popMatrix();
        matrices.pushMatrix();
        float textScale = 1.0f;
        matrices.scale(textScale, textScale);
        int px = (int)Math.floor((float)mouseX * scale + (float)this.x);
        int pz = (int)Math.floor((float)mouseY * scale + (float)this.y);
        RegionKey key = this.mapCache.getRegionKey(px, pz);
        if (this.yLevelInterests.add(key)) {
            this.mapCache.addReference(key);
        }
        Short y = this.mapCache.getYLevel(px, pz);
        guiGraphics.method_25300(this.field_22793, "(%d, %s, %d)".formatted(px, y == null ? "?" : Short.toString(y), pz), (int)((float)(this.field_22789 / 2) / textScale), (int)((float)(this.field_22790 - 16) / textScale), -1);
        matrices.popMatrix();
        for (class_4068 renderable : ((ScreenAccessor)((Object)this)).civmodern$getRenderables()) {
            renderable.method_25394(guiGraphics, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        class_1041 window = class_310.method_1551().method_22683();
        float scale = (float)window.method_4495() * zoom;
        if ((this.targeting || this.newWaypointModal.isTargeting() || this.editWaypointModal.isTargeting()) && button == 0) {
            double mouseWorldX = mouseX * (double)scale + this.x - 0.5;
            double mouseWorldY = mouseY * (double)scale + this.y - 0.5;
            int x = (int)Math.round(mouseWorldX);
            int z = (int)Math.round(mouseWorldY);
            Short yLevel = this.mapCache.getYLevel(x, z);
            if (this.newWaypointModal.isTargeting()) {
                this.newWaypointModal.setTargetResult(x, yLevel == null ? this.newWaypointModal.getY() : yLevel + 2, z);
            } else if (this.editWaypointModal.isTargeting()) {
                this.editWaypointModal.setTargetResult(x, yLevel == null ? this.newWaypointModal.getY() : yLevel + 2, z);
            } else {
                this.waypoints.setTarget(new Waypoint("", x, yLevel == null ? 64 : yLevel + 2, z, "target", 0xFF0000));
                this.targeting = false;
            }
            return true;
        }
        if (this.newWaypointModal.isVisible() && button == 1) {
            this.newWaypointModal.setVisible(false);
            return true;
        }
        if (this.editWaypointModal.isVisible() && button == 1) {
            this.editWaypointModal.setVisible(false);
            this.editWaypointModal.setWaypoint(null);
            return true;
        }
        if (this.boating && button == 1) {
            double mouseWorldX = mouseX * (double)scale + this.x;
            double mouseWorldY = mouseY * (double)scale + this.y;
            if (class_437.method_25442()) {
                this.navigation.getDestinations().pollLast();
            } else if (class_437.method_25441()) {
                this.navigation.reset();
            } else {
                this.navigation.addDestination(new class_241((float)mouseWorldX, (float)mouseWorldY));
            }
            return true;
        }
        if (this.hoveredWaypoint != null && button == 0 && this.editWaypointModal.getWaypoint() != this.hoveredWaypoint) {
            this.editWaypointModal.setWaypoint(this.hoveredWaypoint);
            this.editWaypointModal.setVisible(true);
            this.newWaypointModal.setVisible(false);
        }
        return false;
    }

    public boolean method_25406(double x, double y, int button) {
        if (super.method_25406(x, y, button)) {
            return true;
        }
        class_1041 window = class_310.method_1551().method_22683();
        float scale = (float)window.method_4495() * zoom;
        if (!this.boating) {
            if (this.hoveredWaypoint == null && button == 1 && !this.positionContextMenu.isVisible()) {
                Short yLevel = this.mapCache.getYLevel(this.mouseBlockX, this.mouseBlockY);
                this.positionContextMenu.open(this.mouseBlockX, yLevel, this.mouseBlockY, (int)(((double)this.mouseBlockX - this.x) / (double)scale), (int)(((double)this.mouseBlockY - this.y + 1.0) / (double)scale + 1.0));
                this.positionContextMenu.setVisible(true);
                return true;
            }
            if (this.positionContextMenu.isVisible() && !this.positionContextMenu.method_25405(x, y)) {
                this.positionContextMenu.setVisible(false);
                return true;
            }
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        class_1041 window = class_310.method_1551().method_22683();
        float scale = (float)window.method_4495() * zoom;
        List<Waypoint> waypointList = this.waypoints.getWaypoints();
        Waypoint closest = null;
        double mouseWorldX = mouseX * (double)scale + this.x;
        double mouseWorldY = mouseY * (double)scale + this.y;
        this.hoveredWaypoint = null;
        for (Waypoint waypoint : waypointList) {
            if (waypoint.equals(this.waypoints.getTarget())) continue;
            if (closest == null) {
                closest = waypoint;
                continue;
            }
            if (!(Math.abs((double)waypoint.x() - mouseWorldX) + Math.abs((double)waypoint.z() - mouseWorldY) < Math.abs((double)closest.x() - mouseWorldX) + Math.abs((double)closest.z() - mouseWorldY))) continue;
            closest = waypoint;
        }
        if (closest != null) {
            double offsetX = ((double)closest.x() + 0.5 - mouseWorldX) / (double)scale;
            double offsetY = ((double)closest.z() + 0.5 - mouseWorldY) / (double)scale;
            if (Math.abs(offsetX) < 8.0 && Math.abs(offsetY) < 8.0) {
                this.hoveredWaypoint = closest;
            }
        }
        this.editWaypointModal.method_16014(mouseX, mouseY);
        this.newWaypointModal.method_16014(mouseX, mouseY);
        super.method_16014(mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDirY, double scrollDir) {
        if (super.method_25401(mouseX, mouseY, scrollDirY, scrollDir)) {
            return true;
        }
        if (scrollDir < 0.0 && zoom < 32.0f) {
            class_1041 window = class_310.method_1551().method_22683();
            float scale = (float)window.method_4495() * zoom;
            double centreX = this.x + (double)((float)window.method_4489() * zoom) * 0.5;
            double centreY = this.y + (double)((float)window.method_4506() * zoom) * 0.5;
            double mouseWorldX = mouseX * (double)scale + this.x;
            double mouseWorldY = mouseY * (double)scale + this.y;
            this.x = mouseWorldX - (mouseWorldX - centreX) / 0.5 - (double)((float)window.method_4489() * (zoom *= 2.0f) / 2.0f);
            this.y = mouseWorldY - (mouseWorldY - centreY) / 0.5 - (double)((float)window.method_4506() * zoom / 2.0f);
        } else if (scrollDir > 0.0 && (double)zoom > 0.03125) {
            class_1041 window = class_310.method_1551().method_22683();
            float scale = (float)window.method_4495() * zoom;
            double centreX = this.x + (double)((float)window.method_4489() * zoom) * 0.5;
            double centreY = this.y + (double)((float)window.method_4506() * zoom) * 0.5;
            double mouseWorldX = mouseX * (double)scale + this.x;
            double mouseWorldY = mouseY * (double)scale + this.y;
            this.x = mouseWorldX - (mouseWorldX - centreX) * 0.5 - (double)((float)window.method_4489() * (zoom /= 2.0f) / 2.0f);
            this.y = mouseWorldY - (mouseWorldY - centreY) * 0.5 - (double)((float)window.method_4506() * zoom / 2.0f);
        }
        return true;
    }

    public boolean method_25403(double x, double y, int button, double changeX, double changeY) {
        if (super.method_25403(x, y, button, changeX, changeY)) {
            return true;
        }
        if (this.positionContextMenu.isVisible() && !this.positionContextMenu.method_25405(x, y)) {
            this.positionContextMenu.setVisible(false);
            return true;
        }
        if (button == 0 || button == 1) {
            double scale = (float)class_310.method_1551().method_22683().method_4495() * zoom;
            this.x -= changeX * scale;
            this.y -= changeY * scale;
            return true;
        }
        return false;
    }

    private float floatMod(float x, float y) {
        return x - (float)Math.floor(x / y) * y;
    }

    public void method_49589() {
        this.yLevelInterests.clear();
    }

    public void method_25432() {
        for (RegionKey key : this.yLevelInterests) {
            this.mapCache.removeReference(key);
        }
        this.yLevelInterests.clear();
        if (this.changedConfig) {
            this.config.save();
        }
    }

    public static String getAgo(Instant timestamp) {
        long lastDigit;
        Instant now = Instant.now();
        long minutesDiff = timestamp.until(now, ChronoUnit.MINUTES);
        if (minutesDiff > 0L) {
            return minutesDiff + "m ago";
        }
        long secondsDiff = timestamp.until(now, ChronoUnit.SECONDS);
        if ((secondsDiff -= (lastDigit = secondsDiff % 10L)) < 10L) {
            return "now";
        }
        return secondsDiff + "s ago";
    }

    public boolean method_25404(int i, int j, int k) {
        if (this.key.method_1417(i, j) && !this.newWaypointModal.isVisible() && !this.editWaypointModal.isVisible()) {
            class_310.method_1551().method_1507(null);
            return true;
        }
        return super.method_25404(i, j, k);
    }
}

