/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.waypoints;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoint;

public class PlayerWaypoints {
    private final Map<UUID, PlayerWaypoint> waypoints = new HashMap<UUID, PlayerWaypoint>();
    private final Map<String, PlayerWaypoint> unfilledWaypoints = new HashMap<String, PlayerWaypoint>();
    private static final Pattern SNITCH_PATTERN = Pattern.compile("^(Enter|Login|Logout) +(\\w+) +(.+) +\\[(-?\\d+) (-?\\d+) (-?\\d+)] +(\\[.+])?$");

    public Collection<PlayerWaypoint> getWaypoints() {
        return this.waypoints.values();
    }

    public void acceptSnitchHit(class_2561 message) {
        int z;
        int y;
        int x;
        boolean hasDistance;
        StringBuilder acc = new StringBuilder();
        for (class_2561 component : message.method_44746()) {
            class_7417 class_74172 = component.method_10851();
            if (!(class_74172 instanceof class_8828)) continue;
            class_8828 text = (class_8828)class_74172;
            char[] charArray = text.comp_737().toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\u00a7') {
                    ++i;
                    continue;
                }
                acc.append(c);
            }
        }
        Matcher snitchMatcher = SNITCH_PATTERN.matcher(acc);
        if (!snitchMatcher.matches()) {
            return;
        }
        String playerName = snitchMatcher.group(2);
        String snitchName = snitchMatcher.group(3);
        boolean bl = hasDistance = snitchMatcher.group(7) != null;
        if (playerName == null || snitchName == null || !hasDistance) {
            return;
        }
        if (playerName.equals(class_310.method_1551().field_1724.method_7334().getName())) {
            return;
        }
        try {
            x = Integer.parseInt(snitchMatcher.group(4));
            y = Integer.parseInt(snitchMatcher.group(5));
            z = Integer.parseInt(snitchMatcher.group(6));
        }
        catch (NumberFormatException ex) {
            return;
        }
        class_640 player = null;
        for (class_640 info : class_310.method_1551().field_1724.field_3944.method_2880()) {
            String name = info.method_2966().getName();
            if (!name.equals(playerName)) continue;
            player = info;
        }
        if (player == null) {
            this.unfilledWaypoints.put(playerName, new PlayerWaypoint(playerName, null, x, y, z, null, Instant.now()));
        } else {
            this.waypoints.put(player.method_2966().getId(), new PlayerWaypoint(player.method_2966().getName(), player.method_2966().getId(), x, y, z, player.method_52810().comp_1626(), Instant.now()));
        }
    }

    public void tick() {
        Iterator<Map.Entry<String, PlayerWaypoint>> it = this.unfilledWaypoints.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, PlayerWaypoint> waypoint = it.next();
            if (waypoint.getValue().timestamp().until(Instant.now(), ChronoUnit.SECONDS) > 30L) {
                it.remove();
                continue;
            }
            for (class_640 info : class_310.method_1551().field_1724.field_3944.method_2880()) {
                String name = info.method_2966().getName();
                if (!name.equals(waypoint.getKey())) continue;
                PlayerWaypoint value = waypoint.getValue();
                this.waypoints.put(info.method_2966().getId(), new PlayerWaypoint(info.method_2966().getName(), info.method_2966().getId(), value.x(), value.y(), value.z(), info.method_52810().comp_1626(), value.timestamp()));
                it.remove();
            }
        }
    }
}

