/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.waypoints;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import sh.okx.civmodern.common.events.WorldRenderLastEvent;
import sh.okx.civmodern.common.map.waypoints.Waypoint;

public class Waypoints {
    private final Int2ObjectMap<Int2ObjectMap<Int2ObjectMap<Waypoint>>> waypoints = new Int2ObjectOpenHashMap();
    private Waypoint target;
    private final Connection connection;

    public Waypoints(Connection connection) {
        this.connection = connection;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Connection connection = this.connection;
        synchronized (connection) {
            try (Statement statement = this.connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT name, x, y, z, icon, colour FROM waypoints");
                while (resultSet.next()) {
                    this.addWaypoint(new Waypoint(resultSet.getString("name"), resultSet.getInt("x"), resultSet.getInt("y"), resultSet.getInt("z"), resultSet.getString("icon"), resultSet.getInt("colour")));
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                this.connection.setAutoCommit(false);
                try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO waypoints VALUES (?, ?, ?, ?, ?, ?) ON CONFLICT DO UPDATE SET name = ?, icon = ?, colour = ?");
                     Statement delete = this.connection.createStatement();){
                    delete.executeUpdate("DELETE FROM waypoints");
                    for (Int2ObjectMap zEntry : this.waypoints.values()) {
                        for (Int2ObjectMap yEntry : zEntry.values()) {
                            for (Waypoint waypoint : yEntry.values()) {
                                statement.setString(1, waypoint.name());
                                statement.setInt(2, waypoint.x());
                                statement.setInt(3, waypoint.y());
                                statement.setInt(4, waypoint.z());
                                statement.setString(5, "waypoint");
                                statement.setInt(6, waypoint.colour());
                                statement.setString(7, waypoint.name());
                                statement.setString(8, "waypoint");
                                statement.setInt(9, waypoint.colour());
                                statement.addBatch();
                            }
                        }
                    }
                    statement.executeBatch();
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.connection.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void addWaypoint(Waypoint waypoint) {
        ((Int2ObjectMap)((Int2ObjectMap)this.waypoints.computeIfAbsent(waypoint.x(), k -> new Int2ObjectOpenHashMap())).computeIfAbsent(waypoint.z(), k -> new Int2ObjectOpenHashMap())).put(waypoint.y(), (Object)waypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        Int2ObjectMap wz;
        Int2ObjectMap wx = (Int2ObjectMap)this.waypoints.get(waypoint.x());
        if (wx != null && (wz = (Int2ObjectMap)wx.get(waypoint.z())) != null) {
            wz.remove(waypoint.y());
        }
    }

    public Waypoint getTarget() {
        return this.target;
    }

    public void setTarget(Waypoint target) {
        this.target = target;
    }

    public List<Waypoint> getWaypoints() {
        ArrayList<Waypoint> list = new ArrayList<Waypoint>();
        for (Int2ObjectMap map : this.waypoints.values()) {
            for (Int2ObjectMap i : map.values()) {
                list.addAll((Collection<Waypoint>)i.values());
            }
        }
        if (this.target != null) {
            list.add(this.target);
        }
        return list;
    }

    public List<Waypoint> getWaypoints(int x, int y, int z, int distance) {
        ArrayList<Waypoint> nearbyWaypoints = new ArrayList<Waypoint>();
        for (Waypoint waypoint : this.getWaypoints()) {
            int dz;
            int dx = Math.abs(waypoint.x() - x);
            if (dx * dx + (dz = Math.abs(waypoint.z() - z)) * dz >= distance * distance) continue;
            nearbyWaypoints.add(waypoint);
        }
        return nearbyWaypoints;
    }

    public void onRender(WorldRenderLastEvent event) {
        class_746 player = class_310.method_1551().field_1724;
        List<Waypoint> nearbyWaypoints = this.getWaypoints(player.method_31477(), player.method_31478(), player.method_31479(), 2000);
        if (this.getTarget() != null) {
            nearbyWaypoints.add(this.getTarget());
        }
        Collections.sort(nearbyWaypoints, (c, r) -> Integer.compare((r.x() - player.method_31477()) * (r.x() - player.method_31477()) + (r.z() - player.method_31479()) * (r.z() - player.method_31479()), (c.x() - player.method_31477()) * (c.x() - player.method_31477()) + (c.z() - player.method_31479()) * (c.z() - player.method_31479())));
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_4587 matrices = event.stack();
        class_243 pos = camera.method_19326();
        for (Waypoint waypoint : nearbyWaypoints) {
            double z;
            double y;
            double x = (double)waypoint.x() + 0.5 - pos.field_1352;
            float distance = (float)class_3532.method_33825((double)x, (double)(y = (double)waypoint.y() + 0.5 - pos.field_1351), (double)(z = (double)waypoint.z() + 0.5 - pos.field_1350));
            if (distance <= 1.0f) continue;
            matrices.method_22903();
            float maxDistance = class_310.method_1551().field_1690.method_38521() * 16 * 4 - 2;
            float adjustedDistance = distance;
            if (distance > maxDistance) {
                x = x / (double)distance * (double)maxDistance;
                y = y / (double)distance * (double)maxDistance;
                z = z / (double)distance * (double)maxDistance;
                adjustedDistance = maxDistance;
            }
            matrices.method_22904(x, y, z);
            adjustedDistance = (adjustedDistance * 0.1f + 1.0f) * 0.0266f;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-camera.method_19330()));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
            matrices.method_22905(-adjustedDistance, -adjustedDistance, -adjustedDistance);
            int k = (int)(this.getTransparency(distance, 0.11f) * 255.0f) << 24;
            class_1060 textureManager = class_310.method_1551().method_1531();
            class_1044 abstractTexture = textureManager.method_4619(waypoint.resourceLocation());
            abstractTexture.method_4527(true, true);
            waypoint.render(event.source(), matrices.method_23760().method_23761(), 8, k);
            matrices.method_22909();
        }
        class_4597 source = event.source();
        int rendered = 0;
        Collections.reverse(nearbyWaypoints);
        for (int i = 0; i < nearbyWaypoints.size() && rendered < 100; ++i, ++rendered) {
            double z;
            double y;
            double x;
            float distance;
            double waypointDistance;
            Waypoint waypoint = nearbyWaypoints.get(i);
            if (!this.isPointedAt(waypoint, waypointDistance = class_3532.method_33825((double)(waypoint.x() - player.method_31477()), (double)(waypoint.y() - player.method_31478()), (double)(waypoint.z() - player.method_31479())), class_310.method_1551().method_1560(), event.tickDelta()) || (distance = (float)class_3532.method_33825((double)(x = (double)waypoint.x() + 0.5 - pos.field_1352), (double)(y = (double)waypoint.y() + 0.5 - pos.field_1351), (double)(z = (double)waypoint.z() + 0.5 - pos.field_1350))) <= 1.0f) continue;
            matrices.method_22903();
            float maxDistance = class_310.method_1551().field_1690.method_38521() * 16 * 4 - 2;
            float adjustedDistance = distance;
            if (distance > maxDistance) {
                x = x / (double)distance * (double)maxDistance;
                y = y / (double)distance * (double)maxDistance;
                z = z / (double)distance * (double)maxDistance;
                adjustedDistance = maxDistance;
            }
            matrices.method_22904(x, y, z);
            adjustedDistance = (adjustedDistance * 0.1f + 1.0f) * 0.0266f;
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-camera.method_19330()));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(camera.method_19329()));
            matrices.method_22905(-adjustedDistance, -adjustedDistance, -adjustedDistance);
            class_327 font = class_310.method_1551().field_1772;
            String str = waypoint.name() + (waypoint.name().isBlank() ? "" : " ") + "(" + (int)waypointDistance + ")";
            matrices.method_46416(0.0f, -20.0f, 0.0f);
            Matrix4f last = matrices.method_23760().method_23761();
            int k = (int)(this.getTransparency(distance, 0.44f) * 63.0f) << 24;
            int k2 = (int)(this.getTransparency(distance, 0.11f) * 255.0f) << 24;
            float bgOpacity = class_310.method_1551().field_1690.method_19343(0.25f);
            int bgColor = (int)(bgOpacity * 255.0f) << 24;
            font.method_27521(str, (float)(-font.method_1727(str)) / 2.0f, 0.0f, 0x20FFFFFF, false, last, source, class_327.class_6415.field_33993, k, 0);
            font.method_27521(str, (float)(-font.method_1727(str)) / 2.0f, 0.0f, k2 | 0xFFFFFF, false, last, source, class_327.class_6415.field_33994, bgColor, 0);
            matrices.method_22909();
        }
    }

    private float getTransparency(float distance, float clamp) {
        if (distance < 3.0f) {
            return class_3532.method_15363((float)((distance - 1.0f) / 2.0f), (float)clamp, (float)1.0f);
        }
        return 1.0f;
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, class_1297 cameraEntity, float partialTicks) {
        class_243 cameraPos = cameraEntity.method_5836(partialTicks);
        double degrees = 4.0 + Math.min(4.0 / distance, 4.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance * 2.0;
        class_243 cameraPosPlusDirection = cameraEntity.method_5828(partialTicks);
        class_243 cameraPosPlusDirectionTimesDistance = cameraPos.method_1031(cameraPosPlusDirection.field_1352 * distance, cameraPosPlusDirection.field_1351 * distance, cameraPosPlusDirection.field_1350 * distance);
        class_238 axisalignedbb = new class_238((double)((float)waypoint.x() + 0.5f) - size, (double)((float)waypoint.y() + 0.5f) - size, (double)((float)waypoint.z() + 0.5f) - size, (double)((float)waypoint.x() + 0.5f) + size, (double)((float)waypoint.y() + 0.5f) + size, (double)((float)waypoint.z() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.method_992(cameraPos, cameraPosPlusDirectionTimesDistance);
        if (axisalignedbb.method_1006(cameraPos)) {
            return distance >= 1.0;
        }
        return raytraceresult.isPresent();
    }
}

