/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sh.okx.civmodern.common.parser.WaypointParseState;

public record ParsedWaypoint(String name, int x, int y, int z, int textPosStart, int textPosEnd) {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ParsedWaypoint> parseWaypoints(String text) {
        ArrayList<ParsedWaypoint> waypoints = new ArrayList<ParsedWaypoint>();
        char[] chars = text.toCharArray();
        WaypointParseState state = WaypointParseState.START;
        int startPos = 0;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        HashMap<String, String> kvPairs = new HashMap<String, String>();
        for (int i = 0; i < chars.length; ++i) {
            if (state == WaypointParseState.START) {
                if (chars[i] != '[') continue;
                startPos = i;
                state = WaypointParseState.WAYPOINT_KEY;
                continue;
            }
            if (state == WaypointParseState.WAYPOINT_KEY) {
                if (chars[i] == ':') {
                    state = WaypointParseState.WAYPOINT_VALUE;
                    continue;
                }
                if (chars[i] == ']') {
                    state = WaypointParseState.START;
                    key = new StringBuilder();
                    value = new StringBuilder();
                    kvPairs.clear();
                    continue;
                }
                key.append(chars[i]);
                continue;
            }
            if (state != WaypointParseState.WAYPOINT_VALUE) continue;
            if (chars[i] == ',') {
                state = WaypointParseState.WAYPOINT_KEY;
                kvPairs.put(key.toString(), value.toString());
                key = new StringBuilder();
                value = new StringBuilder();
                continue;
            }
            if (chars[i] == ']') {
                state = WaypointParseState.START;
                kvPairs.put(key.toString(), value.toString());
                key = new StringBuilder();
                value = new StringBuilder();
                String name = "";
                Integer x = null;
                Integer y = null;
                Integer z = null;
                try {
                    for (Map.Entry kvPair : kvPairs.entrySet()) {
                        String parsedKey = (String)kvPair.getKey();
                        String parsedValue = (String)kvPair.getValue();
                        if (parsedKey.equalsIgnoreCase("name")) {
                            name = parsedValue;
                            continue;
                        }
                        if (parsedKey.equalsIgnoreCase("x")) {
                            x = Integer.parseInt(parsedValue);
                            continue;
                        }
                        if (parsedKey.equalsIgnoreCase("y")) {
                            y = Integer.parseInt(parsedValue);
                            continue;
                        }
                        if (!parsedKey.equalsIgnoreCase("z")) continue;
                        z = Integer.parseInt(parsedValue);
                    }
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                finally {
                    kvPairs.clear();
                }
                if (x == null || y == null || z == null) continue;
                waypoints.add(new ParsedWaypoint(name, x, y, z, startPos, i + 1));
                continue;
            }
            value.append(chars[i]);
        }
        return waypoints;
    }
}

