/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common;

import com.google.common.eventbus.Subscribe;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.EventBus;
import sh.okx.civmodern.common.gui.screen.MainConfigScreen;
import sh.okx.civmodern.common.macro.AttackMacro;
import sh.okx.civmodern.common.macro.HoldKeyMacro;
import sh.okx.civmodern.common.macro.IceRoadMacro;
import sh.okx.civmodern.common.radar.Radar;

public abstract class AbstractCivModernMod {
    private static AbstractCivModernMod INSTANCE;
    private static final Logger LOGGER;
    private final KeyMapping configBinding;
    private final KeyMapping holdLeftBinding;
    private final KeyMapping holdRightBinding;
    private final KeyMapping iceRoadBinding;
    private final KeyMapping attackBinding;
    private CivMapConfig config;
    private ColourProvider colourProvider;
    private Radar radar;
    private HoldKeyMacro leftMacro;
    private HoldKeyMacro rightMacro;
    private IceRoadMacro iceRoadMacro;
    private AttackMacro attackMacro;
    public final EventBus eventBus = new EventBus("CivModernEvents");

    public AbstractCivModernMod() {
        this.configBinding = new KeyMapping("key.civmodern.config", InputConstants.Type.KEYSYM, 82, "category.civmodern");
        this.holdLeftBinding = new KeyMapping("key.civmodern.left", InputConstants.Type.KEYSYM, 45, "category.civmodern");
        this.holdRightBinding = new KeyMapping("key.civmodern.right", InputConstants.Type.KEYSYM, 61, "category.civmodern");
        this.iceRoadBinding = new KeyMapping("key.civmodern.ice", InputConstants.Type.KEYSYM, 259, "category.civmodern");
        this.attackBinding = new KeyMapping("key.civmodern.attack", InputConstants.Type.KEYSYM, 48, "category.civmodern");
        if (INSTANCE != null) {
            throw new IllegalStateException("AbstractCivModernMod initialised twice");
        }
        INSTANCE = this;
    }

    public final void init() {
        this.registerKeyBinding(this.configBinding);
        this.registerKeyBinding(this.holdLeftBinding);
        this.registerKeyBinding(this.holdRightBinding);
        this.registerKeyBinding(this.attackBinding);
        this.registerKeyBinding(this.iceRoadBinding);
    }

    public final void enable() {
        this.loadConfig();
        this.loadRadar();
        this.eventBus.register(this);
        Options options = Minecraft.getInstance().options;
        this.leftMacro = new HoldKeyMacro(this, this.holdLeftBinding, options.keyAttack);
        this.rightMacro = new HoldKeyMacro(this, this.holdRightBinding, options.keyUse);
        this.iceRoadMacro = new IceRoadMacro(this, this.config, this.iceRoadBinding);
        this.attackMacro = new AttackMacro(this, this.attackBinding, options.keyAttack);
    }

    public abstract void registerKeyBinding(KeyMapping var1);

    @Subscribe
    private void tick(@NotNull ClientTickEvent event) {
        while (this.configBinding.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new MainConfigScreen(this, this.config));
        }
    }

    private void loadConfig() {
        Properties properties = new Properties();
        Path gameDir = Minecraft.getInstance().gameDirectory.toPath();
        File configFile = gameDir.resolve("config").resolve("civmodern.properties").toFile();
        try {
            if (!configFile.exists()) {
                InputStream resource = AbstractCivModernMod.class.getResourceAsStream("/civmodern.properties");
                byte[] buffer = new byte[resource.available()];
                resource.read(buffer);
                FileOutputStream fos = new FileOutputStream(configFile);
                fos.write(buffer);
            }
            FileInputStream input = new FileInputStream(configFile);
            properties.load(input);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.config = new CivMapConfig(configFile, properties);
    }

    private void loadRadar() {
        this.colourProvider = new ColourProvider(this.config);
        this.radar = new Radar(this.config, this.eventBus, this.colourProvider);
    }

    public ColourProvider getColourProvider() {
        return this.colourProvider;
    }

    @NotNull
    public Screen newConfigGui(Screen previousScreen) {
        return new MainConfigScreen(this, this.config);
    }

    public static AbstractCivModernMod getInstance() {
        return INSTANCE;
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

