/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import sh.okx.civmodern.common.gui.Texture;
import sh.okx.civmodern.common.gui.screen.ScreenCloseable;
import sh.okx.civmodern.common.gui.widget.HUSLColorConverter;

public class HsbColourPicker
extends AbstractWidget {
    private static final ResourceLocation COLOUR_PICKER_ICON = ResourceLocation.tryBuild((String)"civmodern", (String)"gui/colour.png");
    private final Texture hueSelector;
    private final Texture saturationBrightnessTexture;
    private final Consumer<Integer> colourConsumer;
    private final Consumer<Integer> previewConsumer;
    private int hue = 0;
    private boolean mouseOverGrid = false;
    private boolean showPalette = false;
    private boolean updateTexture = true;
    private boolean hueMouseDown = false;
    private final ScreenCloseable closeable;
    private int renderY;

    public HsbColourPicker(int x, int y, int width, int height, int colour, Consumer<Integer> colourConsumer, Consumer<Integer> previewConsumer, ScreenCloseable closeable) {
        super(x, y, width, height, (Component)Component.literal((String)"HSB Colour Picker"));
        this.hue = this.getHue(colour);
        this.closeable = closeable;
        this.hueSelector = this.getHueSelector();
        this.saturationBrightnessTexture = new Texture(128, 128);
        this.colourConsumer = colourConsumer;
        this.previewConsumer = previewConsumer;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderY = this.getX() + 101 > Minecraft.getInstance().getWindow().getGuiScaledHeight() ? this.getY() - 101 - this.height : this.getY();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COLOUR_PICKER_ICON);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(COLOUR_PICKER_ICON, this.getX(), this.getY(), 10, 0.0f, this.isHoveredOrFocused() ? 20.0f : 0.0f, this.width, this.height, 20, 40);
        if (this.showPalette) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.updateTexture) {
                this.updateTexture(this.saturationBrightnessTexture, this.hue);
                this.updateTexture = false;
            }
            this.saturationBrightnessTexture.bind();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Matrix4f matrix4f = guiGraphics.pose().last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, (float)this.getX(), (float)(this.renderY + this.height), 0.0f).setUv(0.0f, 0.0f);
            bufferBuilder.addVertex(matrix4f, (float)this.getX(), (float)(this.renderY + this.height + 128), 0.0f).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 128), (float)(this.renderY + this.height + 128), 0.0f).setUv(1.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 128), (float)(this.renderY + this.height), 0.0f).setUv(1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            this.hueSelector.bind();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 106), (float)(this.renderY + this.height), 0.0f).setUv(0.0f, 0.0f);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 106), (float)(this.renderY + this.height + 101), 0.0f).setUv(0.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 106 + 10), (float)(this.renderY + this.height + 101), 0.0f).setUv(1.0f, 1.0f);
            bufferBuilder.addVertex(matrix4f, (float)(this.getX() + 106 + 10), (float)(this.renderY + this.height), 0.0f).setUv(1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
            RenderSystem.disableBlend();
            float hueOffset = (float)this.hue / 360.0f * 100.0f;
            int cursorX = this.getX() + 106;
            int cursorY = (int)hueOffset + this.renderY + this.height;
            guiGraphics.fill(cursorX, cursorY, cursorX + 10, cursorY + 1, -1);
            guiGraphics.pose().popPose();
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.previewConsumer != null) {
            if (this.active && this.visible && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
                int saturation = (int)(mouseX - (double)this.getX());
                int brightness = (int)(mouseY - (double)this.renderY - (double)this.height);
                this.mouseOverGrid = true;
                this.previewConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            } else if (this.mouseOverGrid) {
                this.previewConsumer.accept(null);
            }
        }
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.showPalette) {
            this.closeable.close();
        }
        this.showPalette = !this.showPalette;
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.hueMouseDown) {
            this.setHue(mouseX, mouseY, 0, true);
        }
    }

    public void onRelease(double d, double e) {
        this.hueMouseDown = false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.selectColour(mouseX, mouseY, button) || this.setHue(mouseX, mouseY, button, false) || super.mouseClicked(mouseX, mouseY, button);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    private boolean selectColour(double mouseX, double mouseY, int button) {
        if (this.active && this.visible && button == 0 && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
            int saturation = (int)(mouseX - (double)this.getX());
            int brightness = (int)(mouseY - (double)this.renderY - (double)this.height);
            this.colourConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            this.showPalette = false;
            return true;
        }
        return false;
    }

    private boolean setHue(double mouseX, double mouseY, int button, boolean force) {
        if (this.active && this.visible && button == 0 && this.showPalette) {
            if (!(force || mouseY >= (double)(this.renderY + this.height) && mouseY <= (double)(this.renderY + this.height + 101))) {
                return false;
            }
            if (force || mouseX >= (double)(this.getX() + 106) && mouseX <= (double)(this.getX() + 106 + 10)) {
                this.hueMouseDown = true;
                double yOffset = mouseY - (double)(this.renderY + this.height);
                int newHue = Mth.clamp((int)((int)(yOffset / 102.0 * 360.0)), (int)0, (int)360);
                if (newHue != this.hue) {
                    this.hue = newHue;
                    this.updateTexture = true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isOverGrid(double mouseX, double mouseY) {
        return mouseX >= (double)this.getX() && mouseX < (double)(this.getX() + 101) && mouseY >= (double)(this.renderY + this.height) && mouseY < (double)(this.renderY + this.height + 101);
    }

    private void updateTexture(Texture texture, int hue) {
        int[] rgbaValues = new int[16384];
        for (int saturation = 0; saturation <= 100; ++saturation) {
            for (int brightness = 0; brightness <= 100; ++brightness) {
                int rgb = this.toRgb(hue, saturation, brightness) & 0xFFFFFF;
                rgbaValues[brightness * 128 + saturation] = rgb << 8 | 0xFF;
            }
        }
        texture.setPixels(rgbaValues);
        texture.update();
    }

    private int toRgb(int hue, int sat, int bright) {
        double[] rgbArr = HUSLColorConverter.hsluvToRgb(new double[]{hue, sat, bright});
        return (int)(rgbArr[0] * 255.0) << 16 | (int)(rgbArr[1] * 255.0) << 8 | (int)(rgbArr[2] * 255.0);
    }

    private int getHue(int colour) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        return (int)Math.round(HUSLColorConverter.rgbToHsluv(new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0})[0]);
    }

    private Texture getHueSelector() {
        Texture hueSelector = new Texture(1, 360);
        int[] rgbaValues = new int[360];
        for (int i = 0; i < 360; ++i) {
            int rgb = this.toRgb(i, 100, 50);
            rgbaValues[i] = rgb << 8 | 0xFF;
        }
        hueSelector.setPixels(rgbaValues);
        hueSelector.update();
        return hueSelector;
    }

    public void close() {
        this.showPalette = false;
    }
}

