/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.macro;

import com.google.common.eventbus.Subscribe;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.events.ClientTickEvent;

public class IceRoadMacro {
    private final CivMapConfig config;
    private final KeyMapping key;
    private boolean enabled = false;
    private boolean jump = false;
    private boolean waitingForFood = false;
    private ItemStack eating;

    public IceRoadMacro(AbstractCivModernMod mod, CivMapConfig config, KeyMapping key) {
        mod.eventBus.register(this);
        this.config = config;
        this.key = key;
    }

    @Subscribe
    private void tick(@NotNull ClientTickEvent event) {
        block15: {
            Minecraft mc;
            block19: {
                block16: {
                    block17: {
                        ItemStack mainhand;
                        block18: {
                            mc = Minecraft.getInstance();
                            if (mc.player == null) {
                                return;
                            }
                            while (this.key.consumeClick()) {
                                if (this.enabled) {
                                    mc.options.keySprint.setDown(false);
                                    mc.options.keyUp.setDown(false);
                                    if (this.jump) {
                                        this.jump = false;
                                        if (!mc.player.isPassenger()) {
                                            mc.options.keyJump.setDown(false);
                                        }
                                    }
                                    mc.options.keyUse.setDown(false);
                                    this.waitingForFood = false;
                                    this.eating = null;
                                    this.enabled = false;
                                    continue;
                                }
                                if (this.config.iceRoadYawCardinalEnabled()) {
                                    float roty = Math.round(mc.player.getYRot() / 45.0f) * 45;
                                    mc.player.setYRot(roty);
                                }
                                if (this.config.iceRoadPitchCardinalEnabled()) {
                                    float rotx = Math.round(mc.player.getXRot() / 45.0f) * 45;
                                    mc.player.setXRot(rotx);
                                }
                                this.enabled = true;
                            }
                            if (!this.enabled) break block15;
                            if (this.jump) break block16;
                            if (!this.config.isIceRoadAutoEat()) break block17;
                            if (this.eating == null) break block18;
                            if (mc.player.isUsingItem() && this.eating.equals(mc.player.getUseItem())) break block17;
                            this.eating = null;
                            mc.options.keyUse.setDown(false);
                        }
                        if (this.tryEat(mainhand = mc.player.getMainHandItem())) {
                            this.eating = mainhand;
                            mc.options.keyUse.setDown(true);
                            return;
                        }
                    }
                    if (this.config.isIceRoadStop() && mc.player.getFoodData().getFoodLevel() <= 6) {
                        this.waitingForFood = true;
                        mc.options.keyUp.setDown(false);
                        return;
                    }
                    if (this.waitingForFood) {
                        this.waitingForFood = false;
                    }
                    if (!mc.player.isPassenger()) {
                        mc.options.keyJump.setDown(true);
                    }
                    this.jump = true;
                    break block19;
                }
                if (!mc.player.isPassenger()) {
                    mc.options.keyJump.setDown(false);
                }
                this.jump = false;
            }
            mc.options.keySprint.setDown(true);
            mc.options.keyUp.setDown(true);
        }
    }

    private boolean tryEat(ItemStack item) {
        Minecraft mc = Minecraft.getInstance();
        FoodProperties food = (FoodProperties)item.getItem().components().get(DataComponents.FOOD);
        return food != null && food.nutrition() > 0 && mc.player.getFoodData().getFoodLevel() + food.nutrition() <= 20;
    }
}

