/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.mixins;

import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import sh.okx.civmodern.common.features.ExtendedItemStack;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements ExtendedItemStack {
    @Unique
    private Boolean civmodern$isCompacted = null;

    @Shadow
    public abstract DataComponentMap getComponents();

    @Override
    @Unique
    public boolean isMarkedAsCompacted() {
        if (this.civmodern$isCompacted == null) {
            this.civmodern$isCompacted = this.civmodern$isCompacted();
        }
        return this.civmodern$isCompacted;
    }

    @Unique
    private boolean civmodern$isCompacted() {
        ItemLore lore = (ItemLore)this.getComponents().get(DataComponents.LORE);
        if (lore == null) {
            return false;
        }
        for (Component line : lore.lines()) {
            if (line == null) continue;
            StringBuilder content = new StringBuilder();
            for (Component child : line.toFlatList()) {
                if (!Style.EMPTY.equals((Object)child.getStyle())) {
                    return false;
                }
                content.append(child.getString());
            }
            if (!"Compacted Item".contentEquals(content)) continue;
            return true;
        }
        return false;
    }
}

