/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.radar;

import com.google.common.eventbus.Subscribe;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.EventBus;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;

public class Radar {
    private static boolean hideY;
    private final EventBus eventBus;
    private final ColourProvider colourProvider;
    private final CivMapConfig config;
    private Set<RemotePlayer> playersInRange = new HashSet<RemotePlayer>();
    private int translateX;
    private int translateY;
    private int bgColour;
    private int fgColour;

    public Radar(CivMapConfig config, EventBus eventBus, ColourProvider colourProvider) {
        this.config = config;
        this.eventBus = eventBus;
        this.colourProvider = colourProvider;
        eventBus.register(this);
    }

    @Subscribe
    private void onClientTick(@NotNull ClientTickEvent event) {
        Minecraft client = Minecraft.getInstance();
        if (client.level == null) {
            this.playersInRange = Collections.emptySet();
        }
    }

    private boolean hideY() {
        return hideY;
    }

    @Subscribe
    private void onWorldTickPing(@NotNull ClientTickEvent event) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        HashSet<RemotePlayer> newPlayersInRange = new HashSet<RemotePlayer>();
        for (Entity entity : world.entitiesForRendering()) {
            if (!(entity instanceof RemotePlayer)) continue;
            RemotePlayer player = (RemotePlayer)entity;
            newPlayersInRange.add(player);
            if (this.playersInRange.contains(player)) continue;
            if (this.config.isPingEnabled()) {
                BlockPos pos = player.blockPosition();
                String lastWaypointCommand = "/newWaypoint x:" + pos.getX() + ",y:" + (this.hideY() ? Minecraft.getInstance().player.getBlockY() : pos.getY()) + ",z:" + pos.getZ() + ",name:" + player.getScoreboardName();
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"civmodern.radar.enter", (Object[])new Object[]{player.getName(), Component.literal((String)(this.hideY() ? pos.getX() + " " + pos.getZ() : pos.getX() + " " + pos.getY() + " " + pos.getZ())).withStyle(ChatFormatting.AQUA)}).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastWaypointCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"civmodern.radar.hover")))), false);
            }
            if (!this.config.isPingSoundEnabled()) continue;
            Radar.playPlayerSound("pling", player.getUUID());
        }
        if (this.config.isPingEnabled()) {
            for (RemotePlayer player : this.playersInRange) {
                if (newPlayersInRange.contains(player)) continue;
                BlockPos pos = player.blockPosition();
                String lastWaypointCommand = "/newWaypoint x:" + pos.getX() + ",y:" + (this.hideY() ? Minecraft.getInstance().player.getBlockY() : pos.getY()) + ",z:" + pos.getZ() + ",name:" + player.getScoreboardName();
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"civmodern.radar.leave", (Object[])new Object[]{player.getName(), Component.literal((String)(this.hideY() ? pos.getX() + " " + pos.getZ() : pos.getX() + " " + pos.getY() + " " + pos.getZ())).withStyle(s -> s.applyFormat(ChatFormatting.AQUA))}).setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastWaypointCommand)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"civmodern.radar.hover")))), false);
            }
        }
        this.playersInRange = newPlayersInRange;
    }

    @Subscribe
    private void onRender(@NotNull PostRenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.hideGui || mc.getDebugOverlay().showDebugScreen()) {
            return;
        }
        if (this.config.isRadarEnabled()) {
            this.render(event.guiGraphics(), event.deltaTick());
        }
    }

    private int radius() {
        return this.config.getRadarSize();
    }

    public void render(GuiGraphics guiGraphics, float delta) {
        this.bgColour = this.colourProvider.getBackgroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getBackgroundTransparency()) * 255.0f) << 24;
        this.fgColour = this.colourProvider.getForegroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getTransparency()) * 255.0f) << 24;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        guiGraphics.pose().pushPose();
        int offsetX = this.config.getX() + this.config.getRadarSize();
        int offsetY = this.config.getY() + this.config.getRadarSize();
        int height = client.getWindow().getGuiScaledHeight();
        int width = client.getWindow().getGuiScaledWidth();
        switch (this.config.getAlignment()) {
            case TOP_LEFT: {
                this.translateX = offsetX;
                this.translateY = offsetY;
                break;
            }
            case TOP_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = offsetY;
                break;
            }
            case BOTTOM_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = height - offsetY;
                break;
            }
            case BOTTOM_LEFT: {
                this.translateX = offsetX;
                this.translateY = height - offsetY;
            }
        }
        guiGraphics.pose().translate((float)this.translateX, (float)this.translateY, 100.0f);
        this.renderCircleBackground(guiGraphics.pose());
        for (int i = 1; i <= this.config.getRadarCircles(); ++i) {
            this.renderCircleBorder(guiGraphics.pose(), (float)this.radius() * ((float)i / (float)this.config.getRadarCircles()));
        }
        if (this.config.isNorthUp()) {
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
            this.renderAngle(guiGraphics.pose(), delta);
        } else {
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(-player.getViewYRot(delta) % 360.0f));
        }
        this.renderLines(guiGraphics.pose());
        if (this.config.isShowItems()) {
            this.renderItems(guiGraphics, delta);
        }
        this.renderBoatsMinecarts(guiGraphics, delta);
        this.renderPlayers(guiGraphics, delta);
        guiGraphics.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private void renderBoatsMinecarts(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.getInstance();
        for (Entity entity : minecraft.level.entitiesForRendering()) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                this.renderEntity(guiGraphics, (Player)minecraft.player, (Entity)boat, delta, boat.getPickResult(), 1.0f);
                continue;
            }
            if (!(entity instanceof Minecart)) continue;
            Minecart minecart = (Minecart)entity;
            this.renderEntity(guiGraphics, (Player)minecraft.player, (Entity)minecart, delta, new ItemStack((ItemLike)Items.MINECART, 1), 1.1f);
        }
    }

    private void renderItems(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.getInstance();
        for (Entity entity : minecraft.level.entitiesForRendering()) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            this.renderEntity(guiGraphics, (Player)minecraft.player, (Entity)item, delta, item.getItem(), 0.0f);
        }
    }

    private void renderEntity(GuiGraphics guiGraphics, Player player, Entity entity, float delta, ItemStack item, float blit) {
        boolean notUseBlockLight;
        double z;
        double dz;
        double scale = (double)this.config.getRadarSize() / this.config.getRange();
        double px = player.xOld + (player.getX() - player.xOld) * (double)delta;
        double pz = player.zOld + (player.getZ() - player.zOld) * (double)delta;
        double x = entity.xOld + (entity.getX() - entity.xOld) * (double)delta;
        double dx = px - x;
        if (dx * dx + (dz = pz - (z = entity.zOld + (entity.getZ() - entity.zOld) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) {
            return;
        }
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(dx * scale, dz * scale, 150.0);
        if (this.config.isNorthUp()) {
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        } else {
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(player.getViewYRot(delta)));
        }
        BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(item, player.level(), (LivingEntity)player, 0);
        guiGraphics.pose().scale(this.config.getIconSize(), this.config.getIconSize(), 1.0f);
        guiGraphics.pose().mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        guiGraphics.pose().scale(16.0f, 16.0f, 16.0f);
        boolean bl = notUseBlockLight = !bakedModel.usesBlockLight();
        if (notUseBlockLight) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(item, ItemDisplayContext.GUI, false, guiGraphics.pose(), (MultiBufferSource)guiGraphics.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        guiGraphics.flush();
        if (notUseBlockLight) {
            Lighting.setupFor3DItems();
        }
        guiGraphics.pose().popPose();
    }

    private void renderPlayers(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.getInstance();
        for (RemotePlayer player : this.playersInRange) {
            double z;
            double dz;
            if (!player.isAlive()) continue;
            double v = (double)this.config.getRadarSize() / this.config.getRange();
            double px = minecraft.player.xOld + (minecraft.player.getX() - minecraft.player.xOld) * (double)delta;
            double pz = minecraft.player.zOld + (minecraft.player.getZ() - minecraft.player.zOld) * (double)delta;
            double x = player.xOld + (player.getX() - player.xOld) * (double)delta;
            double dx = px - x;
            if (dx * dx + (dz = pz - (z = player.zOld + (player.getZ() - player.zOld) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(dx * v, dz * v, 0.0);
            guiGraphics.pose().scale(0.9f, 0.9f, 0.0f);
            PlayerInfo entry = minecraft.player.connection.getPlayerInfo(player.getUUID());
            guiGraphics.pose().scale(this.config.getIconSize(), this.config.getIconSize(), 0.0f);
            if (this.config.isNorthUp()) {
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
            } else {
                guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(minecraft.player.getViewYRot(delta)));
            }
            ResourceLocation location = entry != null ? entry.getSkin().texture() : ResourceLocation.withDefaultNamespace((String)"textures/entity/steve.png");
            guiGraphics.blit(location, -4, -4, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.pose().scale(0.6f, 0.6f, 0.0f);
            MutableComponent component = Component.literal((String)(player.getScoreboardName() + " (" + (this.hideY() ? (int)Math.round(Math.sqrt(dx * dx + dz * dz)) : (int)player.getY()) + ")"));
            minecraft.font.drawInBatch((Component)component, (float)(-minecraft.font.width((FormattedText)component)) / 2.0f, 7.0f, 0xFFFFFF, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 255);
            guiGraphics.pose().popPose();
        }
    }

    private void renderCircleBackground(PoseStack stack) {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        float radius = (float)this.radius() + 0.5f;
        for (int i = 0; i <= 360; ++i) {
            float x = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            buffer.addVertex(stack.last().pose(), x, y, 0.0f).setColor(this.bgColour);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    private void renderCircleBorder(PoseStack stack, float radius) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder buffer = tessellator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        float thickness = radius == (float)this.radius() ? 1.0f : 0.5f;
        Matrix4f pose = stack.last().pose();
        for (int i = 0; i <= 360; ++i) {
            float x0 = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y0 = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            float x1 = (float)Math.sin((double)i * Math.PI / 180.0) * (radius + thickness);
            float y1 = (float)Math.cos((double)i * Math.PI / 180.0) * (radius + thickness);
            buffer.addVertex(pose, x0, y0, 0.0f).setColor(this.fgColour);
            buffer.addVertex(pose, x1, y1, 0.0f).setColor(this.fgColour);
        }
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderAngle(PoseStack matrixStack, float delta) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        float radius = (float)this.radius() + 0.5f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float thickness = 1.0f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.pushPose();
        Matrix4f last = matrixStack.last().pose();
        last.mul((Matrix4fc)Axis.ZP.rotationDegrees(Minecraft.getInstance().player.getViewYRot(delta)).get(new Matrix4f()));
        buffer.addVertex(last, left, -radius, 0.0f).setColor(this.fgColour);
        buffer.addVertex(last, left, 0.0f, 0.0f).setColor(this.fgColour);
        buffer.addVertex(last, right, 0.0f, 0.0f).setColor(this.fgColour);
        buffer.addVertex(last, right, -radius, 0.0f).setColor(this.fgColour);
        matrixStack.popPose();
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderLines(PoseStack matrixStack) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        float radius = (float)this.radius() + 0.5f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        float thickness = 0.5f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.pushPose();
        Matrix4f last = matrixStack.last().pose();
        int numberOfLines = 4;
        float rotationRadians = (float)Math.PI / (float)numberOfLines;
        for (int i = 0; i < numberOfLines; ++i) {
            buffer.addVertex(last, left, -radius, 0.0f).setColor(this.fgColour);
            buffer.addVertex(last, left, radius, 0.0f).setColor(this.fgColour);
            buffer.addVertex(last, right, radius, 0.0f).setColor(this.fgColour);
            buffer.addVertex(last, right, -radius, 0.0f).setColor(this.fgColour);
            Matrix4f mul = new Matrix4f();
            last.mul((Matrix4fc)Axis.ZP.rotation(rotationRadians).get(mul));
        }
        matrixStack.popPose();
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    public static void playPlayerSound(String soundName, UUID playerKey) {
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.withDefaultNamespace((String)("block.note_block." + soundName)));
        if (soundEvent == null) {
            return;
        }
        float pitch = 0.5f + 1.5f * new Random(playerKey.hashCode()).nextFloat();
        float volume = 1.0f;
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)pitch, (float)volume));
    }

    static {
        URL resource = Radar.class.getResource("/civmc");
        hideY = resource != null;
    }
}

