/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.radar;

import com.google.common.eventbus.Subscribe;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1087;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.EventBus;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;

public class Radar {
    private static boolean hideY;
    private final EventBus eventBus;
    private final ColourProvider colourProvider;
    private final CivMapConfig config;
    private Set<class_745> playersInRange = new HashSet<class_745>();
    private int translateX;
    private int translateY;
    private int bgColour;
    private int fgColour;

    public Radar(CivMapConfig config, EventBus eventBus, ColourProvider colourProvider) {
        this.config = config;
        this.eventBus = eventBus;
        this.colourProvider = colourProvider;
        eventBus.register(this);
    }

    @Subscribe
    private void onClientTick(@NotNull ClientTickEvent event) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            this.playersInRange = Collections.emptySet();
        }
    }

    private boolean hideY() {
        return hideY;
    }

    @Subscribe
    private void onWorldTickPing(@NotNull ClientTickEvent event) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        HashSet<class_745> newPlayersInRange = new HashSet<class_745>();
        for (class_1297 entity : world.method_18112()) {
            if (!(entity instanceof class_745)) continue;
            class_745 player = (class_745)entity;
            newPlayersInRange.add(player);
            if (this.playersInRange.contains(player)) continue;
            if (this.config.isPingEnabled()) {
                class_2338 pos = player.method_24515();
                String lastWaypointCommand = "/newWaypoint x:" + pos.method_10263() + ",y:" + (this.hideY() ? class_310.method_1551().field_1724.method_31478() : pos.method_10264()) + ",z:" + pos.method_10260() + ",name:" + player.method_5820();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"civmodern.radar.enter", (Object[])new Object[]{player.method_5477(), class_2561.method_43470((String)(this.hideY() ? pos.method_10263() + " " + pos.method_10260() : pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_27692(class_124.field_1075)}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, lastWaypointCommand)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"civmodern.radar.hover")))), false);
            }
            if (!this.config.isPingSoundEnabled()) continue;
            Radar.playPlayerSound("pling", player.method_5667());
        }
        if (this.config.isPingEnabled()) {
            for (class_745 player : this.playersInRange) {
                if (newPlayersInRange.contains(player)) continue;
                class_2338 pos = player.method_24515();
                String lastWaypointCommand = "/newWaypoint x:" + pos.method_10263() + ",y:" + (this.hideY() ? class_310.method_1551().field_1724.method_31478() : pos.method_10264()) + ",z:" + pos.method_10260() + ",name:" + player.method_5820();
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"civmodern.radar.leave", (Object[])new Object[]{player.method_5477(), class_2561.method_43470((String)(this.hideY() ? pos.method_10263() + " " + pos.method_10260() : pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_27694(s -> s.method_27706(class_124.field_1075))}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, lastWaypointCommand)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"civmodern.radar.hover")))), false);
            }
        }
        this.playersInRange = newPlayersInRange;
    }

    @Subscribe
    private void onRender(@NotNull PostRenderGameOverlayEvent event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.method_53526().method_53536()) {
            return;
        }
        if (this.config.isRadarEnabled()) {
            this.render(event.guiGraphics(), event.deltaTick());
        }
    }

    private int radius() {
        return this.config.getRadarSize();
    }

    public void render(class_332 guiGraphics, float delta) {
        this.bgColour = this.colourProvider.getBackgroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getBackgroundTransparency()) * 255.0f) << 24;
        this.fgColour = this.colourProvider.getForegroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getTransparency()) * 255.0f) << 24;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        guiGraphics.method_51448().method_22903();
        int offsetX = this.config.getX() + this.config.getRadarSize();
        int offsetY = this.config.getY() + this.config.getRadarSize();
        int height = client.method_22683().method_4502();
        int width = client.method_22683().method_4486();
        switch (this.config.getAlignment()) {
            case TOP_LEFT: {
                this.translateX = offsetX;
                this.translateY = offsetY;
                break;
            }
            case TOP_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = offsetY;
                break;
            }
            case BOTTOM_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = height - offsetY;
                break;
            }
            case BOTTOM_LEFT: {
                this.translateX = offsetX;
                this.translateY = height - offsetY;
            }
        }
        guiGraphics.method_51448().method_46416((float)this.translateX, (float)this.translateY, 100.0f);
        this.renderCircleBackground(guiGraphics.method_51448());
        for (int i = 1; i <= this.config.getRadarCircles(); ++i) {
            this.renderCircleBorder(guiGraphics.method_51448(), (float)this.radius() * ((float)i / (float)this.config.getRadarCircles()));
        }
        if (this.config.isNorthUp()) {
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            this.renderAngle(guiGraphics.method_51448(), delta);
        } else {
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(-player.method_5705(delta) % 360.0f));
        }
        this.renderLines(guiGraphics.method_51448());
        if (this.config.isShowItems()) {
            this.renderItems(guiGraphics, delta);
        }
        this.renderBoatsMinecarts(guiGraphics, delta);
        this.renderPlayers(guiGraphics, delta);
        guiGraphics.method_51448().method_22909();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private void renderBoatsMinecarts(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        for (class_1297 entity : minecraft.field_1687.method_18112()) {
            if (entity instanceof class_1690) {
                class_1690 boat = (class_1690)entity;
                this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)boat, delta, boat.method_31480(), 1.0f);
                continue;
            }
            if (!(entity instanceof class_1695)) continue;
            class_1695 minecart = (class_1695)entity;
            this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)minecart, delta, new class_1799((class_1935)class_1802.field_8045, 1), 1.1f);
        }
    }

    private void renderItems(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        for (class_1297 entity : minecraft.field_1687.method_18112()) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 item = (class_1542)entity;
            this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)item, delta, item.method_6983(), 0.0f);
        }
    }

    private void renderEntity(class_332 guiGraphics, class_1657 player, class_1297 entity, float delta, class_1799 item, float blit) {
        boolean notUseBlockLight;
        double z;
        double dz;
        double scale = (double)this.config.getRadarSize() / this.config.getRange();
        double px = player.field_6038 + (player.method_23317() - player.field_6038) * (double)delta;
        double pz = player.field_5989 + (player.method_23321() - player.field_5989) * (double)delta;
        double x = entity.field_6038 + (entity.method_23317() - entity.field_6038) * (double)delta;
        double dx = px - x;
        if (dx * dx + (dz = pz - (z = entity.field_5989 + (entity.method_23321() - entity.field_5989) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) {
            return;
        }
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904(dx * scale, dz * scale, 150.0);
        if (this.config.isNorthUp()) {
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        } else {
            guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(player.method_5705(delta)));
        }
        class_1087 bakedModel = class_310.method_1551().method_1480().method_4019(item, player.method_37908(), (class_1309)player, 0);
        guiGraphics.method_51448().method_22905(this.config.getIconSize(), this.config.getIconSize(), 1.0f);
        guiGraphics.method_51448().method_34425(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        guiGraphics.method_51448().method_22905(16.0f, 16.0f, 16.0f);
        boolean bl = notUseBlockLight = !bakedModel.method_24304();
        if (notUseBlockLight) {
            class_308.method_24210();
        }
        class_310.method_1551().method_1480().method_23179(item, class_811.field_4317, false, guiGraphics.method_51448(), (class_4597)guiGraphics.method_51450(), 0xF000F0, class_4608.field_21444, bakedModel);
        guiGraphics.method_51452();
        if (notUseBlockLight) {
            class_308.method_24211();
        }
        guiGraphics.method_51448().method_22909();
    }

    private void renderPlayers(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        for (class_745 player : this.playersInRange) {
            double z;
            double dz;
            if (!player.method_5805()) continue;
            double v = (double)this.config.getRadarSize() / this.config.getRange();
            double px = minecraft.field_1724.field_6038 + (minecraft.field_1724.method_23317() - minecraft.field_1724.field_6038) * (double)delta;
            double pz = minecraft.field_1724.field_5989 + (minecraft.field_1724.method_23321() - minecraft.field_1724.field_5989) * (double)delta;
            double x = player.field_6038 + (player.method_23317() - player.field_6038) * (double)delta;
            double dx = px - x;
            if (dx * dx + (dz = pz - (z = player.field_5989 + (player.method_23321() - player.field_5989) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22904(dx * v, dz * v, 0.0);
            guiGraphics.method_51448().method_22905(0.9f, 0.9f, 0.0f);
            class_640 entry = minecraft.field_1724.field_3944.method_2871(player.method_5667());
            guiGraphics.method_51448().method_22905(this.config.getIconSize(), this.config.getIconSize(), 0.0f);
            if (this.config.isNorthUp()) {
                guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(180.0f));
            } else {
                guiGraphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(minecraft.field_1724.method_5705(delta)));
            }
            class_2960 location = entry != null ? entry.method_52810().comp_1626() : new class_2960("textures/entity/steve.png");
            guiGraphics.method_25293(location, -4, -4, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.method_51448().method_22905(0.6f, 0.6f, 0.0f);
            class_5250 component = class_2561.method_43470((String)(player.method_5820() + " (" + (this.hideY() ? (int)Math.round(Math.sqrt(dx * dx + dz * dz)) : (int)player.method_23318()) + ")"));
            minecraft.field_1772.method_30882((class_2561)component, (float)(-minecraft.field_1772.method_27525((class_5348)component)) / 2.0f, 7.0f, 0xFFFFFF, false, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)guiGraphics.method_51450(), class_327.class_6415.field_33993, 0, 0);
            guiGraphics.method_51448().method_22909();
        }
    }

    private void renderCircleBackground(class_4587 stack) {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        float radius = (float)this.radius() + 0.5f;
        for (int i = 0; i <= 360; ++i) {
            float x = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            buffer.method_22918(stack.method_23760().method_23761(), x, y, 0.0f).method_39415(this.bgColour).method_1344();
        }
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    private void renderCircleBorder(class_4587 stack, float radius) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        float thickness = radius == (float)this.radius() ? 1.0f : 0.5f;
        Matrix4f pose = stack.method_23760().method_23761();
        for (int i = 0; i <= 360; ++i) {
            float x0 = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y0 = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            float x1 = (float)Math.sin((double)i * Math.PI / 180.0) * (radius + thickness);
            float y1 = (float)Math.cos((double)i * Math.PI / 180.0) * (radius + thickness);
            buffer.method_22918(pose, x0, y0, 0.0f).method_39415(this.fgColour).method_1344();
            buffer.method_22918(pose, x1, y1, 0.0f).method_39415(this.fgColour).method_1344();
        }
        tessellator.method_1350();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderAngle(class_4587 matrixStack, float delta) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        float radius = (float)this.radius() + 0.5f;
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float thickness = 1.0f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.method_22903();
        Matrix4f last = matrixStack.method_23760().method_23761();
        last.mul((Matrix4fc)class_7833.field_40718.rotationDegrees(class_310.method_1551().field_1724.method_5705(delta)).get(new Matrix4f()));
        buffer.method_22918(last, left, -radius, 0.0f).method_39415(this.fgColour).method_1344();
        buffer.method_22918(last, left, 0.0f, 0.0f).method_39415(this.fgColour).method_1344();
        buffer.method_22918(last, right, 0.0f, 0.0f).method_39415(this.fgColour).method_1344();
        buffer.method_22918(last, right, -radius, 0.0f).method_39415(this.fgColour).method_1344();
        matrixStack.method_22909();
        tesselator.method_1350();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderLines(class_4587 matrixStack) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        float radius = (float)this.radius() + 0.5f;
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float thickness = 0.5f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.method_22903();
        Matrix4f last = matrixStack.method_23760().method_23761();
        int numberOfLines = 4;
        float rotationRadians = (float)Math.PI / (float)numberOfLines;
        for (int i = 0; i < numberOfLines; ++i) {
            buffer.method_22918(last, left, -radius, 0.0f).method_39415(this.fgColour).method_1344();
            buffer.method_22918(last, left, radius, 0.0f).method_39415(this.fgColour).method_1344();
            buffer.method_22918(last, right, radius, 0.0f).method_39415(this.fgColour).method_1344();
            buffer.method_22918(last, right, -radius, 0.0f).method_39415(this.fgColour).method_1344();
            Matrix4f mul = new Matrix4f();
            last.mul((Matrix4fc)class_7833.field_40718.rotation(rotationRadians).get(mul));
        }
        matrixStack.method_22909();
        tesselator.method_1350();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    public static void playPlayerSound(String soundName, UUID playerKey) {
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(new class_2960("block.note_block." + soundName));
        if (soundEvent == null) {
            return;
        }
        float pitch = 0.5f + 1.5f * new Random(playerKey.hashCode()).nextFloat();
        float volume = 1.0f;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)pitch, (float)volume));
    }

    static {
        URL resource = Radar.class.getResource("/civmc");
        hideY = resource != null;
    }
}

