/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.screen;

import java.text.DecimalFormat;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;

public class CompactedConfigScreen
extends Screen {
    private static final DecimalFormat FORMAT = new DecimalFormat("##%");
    private static final ItemStack ITEM;
    private int itemX;
    private int itemY;
    private final AbstractCivModernMod mod;
    private final CivMapConfig config;
    private final Screen parent;
    private HsbColourPicker picker;

    public CompactedConfigScreen(AbstractCivModernMod mod, CivMapConfig config, Screen parent) {
        super((Component)Component.translatable((String)"civmodern.screen.compacted.title"));
        this.mod = mod;
        this.config = config;
        this.parent = parent;
    }

    protected void init() {
        this.itemX = this.width / 2 - 8;
        this.itemY = this.height / 6 - 24;
        int leftWidth = this.width / 2 - 58;
        EditBox widget = new EditBox(this.font, leftWidth, this.height / 6, 60, 20, (Component)Component.empty());
        widget.setValue("#" + String.format("%06X", this.config.getColour()));
        widget.setMaxLength(7);
        Pattern pattern = Pattern.compile("^(#[0-9A-F]{0,6})?$", 2);
        widget.setFilter(string -> pattern.matcher((CharSequence)string).matches());
        widget.setResponder(val -> {
            if (val.length() == 7) {
                int rgb = Integer.parseInt(val.substring(1), 16);
                this.config.setColour(rgb);
            }
        });
        this.addRenderableWidget((GuiEventListener)widget);
        ColourProvider colourProvider = this.mod.getColourProvider();
        HsbColourPicker hsb = new HsbColourPicker(leftWidth + 60 + 8, this.height / 6, 20, 20, this.config.getColour(), colour -> {
            widget.setValue("#" + String.format("%06X", colour));
            this.config.setColour((int)colour);
        }, colourProvider::setTemporaryCompactedColour, () -> {});
        this.addRenderableWidget((GuiEventListener)new ImageButton(leftWidth + 60 + 8 + 20 + 8, this.height / 6, 20, 20, new ResourceLocation("civmodern", "gui/rollback.png"), imbg -> {
            int colour = 0xFFFF58;
            widget.setValue("#FFFF58");
            this.config.setColour(colour);
            hsb.close();
        }));
        this.picker = hsb;
        this.addRenderableWidget((GuiEventListener)this.picker);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.config.save();
            this.minecraft.setScreen(this.parent);
        }).pos(this.width / 2 - 49, this.height / 6 + 169).size(98, 20).build());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawCentredText(guiGraphics, this.title, 0, 15, 0xFFFFFF);
        this.drawItem(guiGraphics);
        if (this.isCursorOverItem(mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, ITEM, mouseX, mouseY);
        }
        super.render(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && this.isCursorOverItem((int)mouseX, (int)mouseY) && button == 0 && player.isCreative()) {
            player.addItem(ITEM.copy());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double d, double e) {
        super.mouseMoved(d, e);
        if (this.picker != null) {
            this.picker.mouseMoved(d, e);
        }
    }

    public void onClose() {
        super.onClose();
        this.mod.getColourProvider().setTemporaryCompactedColour(null);
        this.config.save();
    }

    private boolean isCursorOverItem(int mouseX, int mouseY) {
        return mouseX >= this.itemX - 1 && mouseX < this.itemX + 17 && mouseY > this.itemY - 1 && mouseY < this.itemY + 17;
    }

    private void drawItem(GuiGraphics guiGraphics) {
        guiGraphics.renderItem(ITEM, this.itemX, this.itemY);
        guiGraphics.renderItemDecorations(this.font, ITEM, this.itemX, this.itemY);
    }

    private void drawCentredText(GuiGraphics guiGraphics, Component text, int xOffsetCentre, int yOffsetTop, int colour) {
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int centre = width / 2 - this.font.width((FormattedText)text) / 2;
        guiGraphics.drawString(this.font, text, centre + xOffsetCentre, yOffsetTop, colour);
    }

    static {
        CompoundTag item = new CompoundTag();
        item.putString("id", "stone");
        item.putInt("Count", 64);
        CompoundTag tag = new CompoundTag();
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.valueOf((String)"\"Compacted Item\""));
        CompoundTag display = new CompoundTag();
        display.put("Lore", (Tag)lore);
        tag.put("display", (Tag)display);
        item.put("tag", (Tag)tag);
        ITEM = (ItemStack)ItemStack.parse((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (Tag)item).get();
    }
}

