/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.screen;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.gui.DoubleValue;
import sh.okx.civmodern.common.gui.screen.ScreenCloseable;
import sh.okx.civmodern.common.gui.widget.DoubleOptionUpdateableSliderWidget;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;

public class RadarConfigScreen
extends Screen
implements ScreenCloseable {
    public static final ResourceLocation ROLLBACK_ICON = new ResourceLocation("civmodern", "gui/rollback.png");
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    private final AbstractCivModernMod mod;
    private final CivMapConfig config;
    private final Screen parent;
    private int foregroundColourY;
    private int backgroundColourY;
    private HsbColourPicker bgPicker;
    private HsbColourPicker fgPicker;

    public RadarConfigScreen(AbstractCivModernMod mod, CivMapConfig config, Screen parent) {
        super((Component)Component.translatable((String)"civmodern.screen.radar.title"));
        this.mod = mod;
        this.config = config;
        this.parent = parent;
    }

    protected void init() {
        super.init();
        int left = this.width / 2 - 155;
        int centre = left + 80;
        int right = left + 160;
        int offset = this.height / 6 - 18;
        ColourProvider colourProvider = this.mod.getColourProvider();
        this.bgPicker = this.addColourPicker(left, offset + 178, 0xE8E3E3, this.config::getRadarBgColour, this.config::setRadarBgColour, colourProvider::setTemporaryRadarBackgroundColour);
        this.fgPicker = this.addColourPicker(right, offset + 178, 852482, this.config::getRadarColour, this.config::setRadarColour, colourProvider::setTemporaryRadarForegroundColour);
        this.addRenderableWidget(Button.builder((Component)this.getRadarToggleMessage(), button -> {
            this.config.setRadarEnabled(!this.config.isRadarEnabled());
            button.setMessage(this.getRadarToggleMessage());
        }).pos(centre, offset).size(150, 20).build());
        this.addRenderableWidget(Button.builder((Component)this.getPingToggleMessage(), button -> {
            this.config.setPingEnabled(!this.config.isPingEnabled());
            button.setMessage(this.getPingToggleMessage());
        }).pos(left, offset += 24).size(150, 20).build());
        this.addRenderableWidget(Button.builder((Component)this.getPingSoundMessage(), button -> {
            this.config.setPingSoundEnabled(!this.config.isPingSoundEnabled());
            button.setMessage(this.getPingSoundMessage());
        }).pos(right, offset).size(150, 20).build());
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"civmodern.screen.radar.alignment", (Object[])new Object[]{this.config.getAlignment().toString()}), button -> {
            this.config.setAlignment(this.config.getAlignment().next());
            button.setMessage((Component)Component.translatable((String)"civmodern.screen.radar.alignment", (Object[])new Object[]{this.config.getAlignment().toString()}));
        }).pos(left, offset += 24).size(150, 20).build());
        this.addRenderableWidget(Button.builder((Component)this.getItemToggleMessage(), button -> {
            this.config.setShowItems(!this.config.isShowItems());
            button.setMessage(this.getItemToggleMessage());
        }).pos(right, offset).size(150, 20).build());
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(right, offset += 24, 150, 20, 0.0, 1.0, 0.01, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("##%");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getTransparency();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setTransparency((float)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.transparency", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(left, offset, 150, 20, 0.0, 1.0, 0.01, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("##%");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getBackgroundTransparency();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setBackgroundTransparency((float)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.background_transparency", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(left, offset += 24, 150, 20, 0.5, 2.0, 0.1, new DoubleValue(){
            private final DecimalFormat format = new DecimalFormat("#.#");

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getIconSize();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setIconSize((float)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.iconsize", (Object[])new Object[]{this.format.format(value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(right, offset, 150, 20, 20.0, 150.0, 1.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRange();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRange((int)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.range", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(left, offset += 24, 150, 20, 25.0, 250.0, 1.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRadarSize();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRadarSize((int)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.size", (Object[])new Object[]{Integer.toString((int)value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(right, offset, 150, 20, 1.0, 8.0, 1.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getRadarCircles();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setRadarCircles((int)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.circles", (Object[])new Object[]{Integer.toString((int)value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(left, offset += 24, 150, 20, 0.0, 300.0, 1.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getX();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setX((int)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.x", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.addRenderableWidget(new DoubleOptionUpdateableSliderWidget(right, offset, 150, 20, 0.0, 300.0, 1.0, new DoubleValue(){

            @Override
            public double get() {
                return RadarConfigScreen.this.config.getY();
            }

            @Override
            public void set(double value) {
                RadarConfigScreen.this.config.setY((int)value);
            }

            @Override
            public Component getText(double value) {
                return Component.translatable((String)"civmodern.screen.radar.y", (Object[])new Object[]{String.valueOf((int)value)});
            }
        }));
        this.foregroundColourY = this.backgroundColourY = (offset += 24);
        offset += 12;
        this.addRenderableWidget(Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.config.save();
            Minecraft.getInstance().setScreen(this.parent);
        }).pos(centre, offset += 36).size(150, 20).build());
    }

    private HsbColourPicker addColourPicker(int x, int y, int defaultColour, Supplier<Integer> colourGet, Consumer<Integer> colourSet, Consumer<Integer> preview) {
        int left = x + 75 - 58;
        EditBox widget = new EditBox(this.font, left, y, 60, 20, (Component)Component.empty());
        widget.setValue("#" + String.format("%06X", colourGet.get()));
        widget.setMaxLength(7);
        Pattern pattern = Pattern.compile("^(#[0-9A-F]{0,6})?$", 2);
        widget.setFilter(string -> pattern.matcher((CharSequence)string).matches());
        widget.setResponder(val -> {
            if (val.length() == 7) {
                int rgb = Integer.parseInt(val.substring(1), 16);
                colourSet.accept(rgb);
            }
        });
        this.addRenderableWidget(widget);
        HsbColourPicker hsb = new HsbColourPicker(left + 60 + 8, y, 20, 20, colourGet.get(), colour -> {
            widget.setValue("#" + String.format("%06X", colour));
            colourSet.accept((Integer)colour);
        }, preview, this);
        this.addRenderableWidget(new ImageButton(left + 60 + 8 + 20 + 8, y, 20, 20, ROLLBACK_ICON, imbg -> {
            widget.setValue("#" + String.format("%06X", defaultColour));
            colourSet.accept(defaultColour);
            hsb.close();
        }));
        this.addRenderableWidget(hsb);
        return hsb;
    }

    private Component getPingToggleMessage() {
        if (this.config.isPingEnabled()) {
            return Component.translatable((String)"civmodern.screen.radar.pings.enable");
        }
        return Component.translatable((String)"civmodern.screen.radar.pings.disable");
    }

    private Component getItemToggleMessage() {
        if (this.config.isShowItems()) {
            return Component.translatable((String)"civmodern.screen.radar.items.enable");
        }
        return Component.translatable((String)"civmodern.screen.radar.items.disable");
    }

    private Component getPingSoundMessage() {
        if (this.config.isPingSoundEnabled()) {
            return Component.translatable((String)"civmodern.screen.radar.sound.enable");
        }
        return Component.translatable((String)"civmodern.screen.radar.sound.disable");
    }

    public void onClose() {
        this.config.save();
        this.mod.getColourProvider().setTemporaryRadarBackgroundColour(null);
        this.mod.getColourProvider().setTemporaryRadarForegroundColour(null);
        super.onClose();
    }

    public void mouseMoved(double d, double e) {
        super.mouseMoved(d, e);
        if (this.fgPicker != null) {
            this.fgPicker.mouseMoved(d, e);
        }
        if (this.bgPicker != null) {
            this.bgPicker.mouseMoved(d, e);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        MutableComponent lineColour = Component.literal((String)"Line colour");
        MutableComponent backgroundColour = Component.literal((String)"Background colour");
        this.font.drawInBatch((Component)lineColour, (float)this.width / 2.0f + 75.0f - (float)this.font.width((FormattedText)lineColour) / 2.0f, (float)this.foregroundColourY, 0xFFFFFF, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.font.drawInBatch((Component)backgroundColour, (float)this.width / 2.0f - 75.0f - (float)this.font.width((FormattedText)backgroundColour) / 2.0f, (float)this.backgroundColourY, 0xFFFFFF, true, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, delta);
        }
    }

    private Component getRadarToggleMessage() {
        if (this.config.isRadarEnabled()) {
            return Component.literal((String)"Radar: Enabled");
        }
        return Component.literal((String)"Radar: Disabled");
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        this.renderables.add(widget);
        return (T)super.addRenderableWidget(widget);
    }

    @Override
    public void close() {
        this.fgPicker.close();
        this.bgPicker.close();
    }
}

