/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.macro;

import com.google.common.eventbus.Subscribe;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.ScrollEvent;

public class HoldKeyMacro {
    private final KeyMapping holdBinding;
    private final KeyMapping defaultBinding;
    private boolean down = false;

    public HoldKeyMacro(AbstractCivModernMod mod, KeyMapping holdBinding, KeyMapping defaultBinding) {
        mod.eventBus.register(this);
        this.holdBinding = holdBinding;
        this.defaultBinding = defaultBinding;
    }

    @Subscribe
    private void tick(@NotNull ClientTickEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        if (this.down && (mc.screen != null || !mc.mouseHandler.isMouseGrabbed())) {
            this.set(false);
            return;
        }
        for (KeyMapping hotbar : mc.options.keyHotbarSlots) {
            if (!hotbar.isDown()) continue;
            this.set(false);
            return;
        }
        while (this.holdBinding.consumeClick()) {
            if (this.down) {
                this.set(false);
                continue;
            }
            if (mc.player.isUsingItem()) continue;
            this.set(true);
        }
    }

    @Subscribe
    private void onScroll(@NotNull ScrollEvent event) {
        this.set(false);
    }

    private void set(boolean down) {
        if (this.down == down) {
            return;
        }
        this.down = down;
        this.defaultBinding.setDown(down);
    }
}

