/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common;

import java.util.Objects;
import sh.okx.civmodern.common.CivMapConfig;

public class ColourProvider {
    private final CivMapConfig config;
    private Integer radarFg;
    private Integer radarBg;
    private Integer compacted;
    private Integer chevron;
    private Integer border;

    public ColourProvider(CivMapConfig config) {
        this.config = config;
    }

    public int getCompactedColour() {
        return Objects.requireNonNullElseGet(this.compacted, this.config::getColour);
    }

    public int getForegroundColour() {
        return Objects.requireNonNullElseGet(this.radarFg, this.config::getRadarColour);
    }

    public int getBackgroundColour() {
        return Objects.requireNonNullElseGet(this.radarBg, this.config::getRadarBgColour);
    }

    public int getChevronColour() {
        return Objects.requireNonNullElseGet(this.chevron, this.config::getChevronColour);
    }

    public int getBorderColour() {
        return Objects.requireNonNullElseGet(this.border, this.config::getBorderColour);
    }

    public void setTemporaryRadarForegroundColour(Integer colour) {
        this.radarFg = colour;
    }

    public void setTemporaryRadarBackgroundColour(Integer colour) {
        this.radarBg = colour;
    }

    public void setTemporaryCompactedColour(Integer colour) {
        this.compacted = colour;
    }

    public void setTemporaryChevronColour(Integer colour) {
        this.chevron = colour;
    }

    public void setTemporaryBorderColour(Integer colour) {
        this.border = colour;
    }
}

