/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.converters;

import com.google.common.net.HostAndPort;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_6368;
import net.minecraft.class_6370;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_9240;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.map.IdLookup;
import sh.okx.civmodern.common.map.MapFolder;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.converters.Converter;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class JourneymapConverter
implements Converter {
    private final MapFolder mapFile;
    private final String name;
    private final String dimension;
    private final class_5455 registryAccess;

    public JourneymapConverter(MapFolder mapFile, String name, String dimension, class_5455 registryAccess) {
        this.mapFile = mapFile;
        this.name = name;
        this.dimension = dimension;
        this.registryAccess = registryAccess;
    }

    @Override
    public boolean hasAlreadyConverted() {
        return this.mapFile.getHistory().mods.containsKey("journeymap");
    }

    private Path getJourmeymapDimensionDir() {
        Path base = class_310.method_1551().field_1697.toPath().resolve("journeymap").resolve("data");
        if (class_310.method_1551().method_1542()) {
            return base.resolve("sp").resolve(this.name).resolve(this.dimension);
        }
        class_642 currServer = class_310.method_1551().method_1558();
        assert (currServer != null);
        String mpDirName = String.format("%s_id_%d_ip_%s~%s", currServer.field_3752, AbstractCivModernMod.getInstance().getWorldListener().getSeed(), currServer.field_3761.replace(".", "~"), this.getIpFromAddress(currServer.field_3761));
        Path mutliWorldPath = base.resolve("mp").resolve(mpDirName).resolve(this.dimension);
        if (mutliWorldPath.toFile().exists()) {
            return mutliWorldPath;
        }
        return base.resolve("mp").resolve(currServer.field_3752).resolve(this.dimension);
    }

    @Override
    public boolean filesAvailable() {
        return this.getJourmeymapDimensionDir().toFile().exists();
    }

    private String getIpFromAddress(String address) {
        HostAndPort hostAndPort = HostAndPort.fromString((String)address);
        class_639 serverAddress = new class_639(hostAndPort.getHost(), hostAndPort.getPortOrDefault(25565));
        Optional resolved = class_6370.field_33745.method_36907(serverAddress);
        if (resolved.isEmpty()) {
            return null;
        }
        return ((class_6368)resolved.get()).method_36900().replace(".", "~") + "~" + serverAddress.method_2954();
    }

    @Override
    public void convert() {
        File[] files = this.getJourmeymapDimensionDir().resolve("cache").toFile().listFiles();
        if (files == null) {
            return;
        }
        AbstractCivModernMod.LOGGER.info("Converting {} Journeymap regions to CivModern regions, this may take a few minutes...", (Object)files.length);
        int regionIndex = 0;
        boolean terminated = false;
        AtomicInteger saved = new AtomicInteger();
        ConcurrentHashMap<RegionKey, RegionLoader> regionMap = new ConcurrentHashMap<RegionKey, RegionLoader>();
        Set converted = Collections.newSetFromMap(new ConcurrentHashMap());
        AtomicBoolean modified = new AtomicBoolean(false);
        File journeymap = this.mapFile.getFolder().toPath().resolve("journeymap").toFile();
        try (FileInputStream fis2 = new FileInputStream(journeymap);){
            converted.addAll(Arrays.asList(new String(fis2.readAllBytes()).split("\n")));
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        IdLookup blockLookup = new IdLookup(this.mapFile.blockIds(), "minecraft:air");
        IdLookup biomeLookup = new IdLookup(this.mapFile.biomeIds(), "minecraft:void");
        class_9240 regionInfo = new class_9240("JourneyMap World", class_1937.field_25179, "thing");
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        while (regionIndex < files.length && !terminated) {
            int parallelRegions = Math.min(128, files.length - regionIndex);
            CountDownLatch latch = new CountDownLatch(parallelRegions);
            int regionStart = regionIndex;
            while (regionIndex < regionStart + parallelRegions) {
                File subRegionFile = files[regionIndex];
                if (subRegionFile.isFile()) {
                    RegionKey regionKey = this.getRegionKey(subRegionFile.getName());
                    if (Thread.interrupted()) {
                        terminated = true;
                        AbstractCivModernMod.LOGGER.info("Terminated Journeymap conversion at region {}/{}", (Object)regionIndex, (Object)files.length);
                        break;
                    }
                    service.submit(() -> {
                        try (class_2861 file = new class_2861(regionInfo, subRegionFile.toPath(), subRegionFile.toPath().getParent(), false);){
                            boolean regionModified = false;
                            for (int i = 0; i < 1024; ++i) {
                                int x = i / 32;
                                int z = i % 32;
                                DataInputStream in = file.method_21873(new class_1923(x, z));
                                if (in == null) continue;
                                class_2487 chunk = class_2507.method_10627((DataInput)in);
                                this.loadData(regionKey, new RegionKey(x, z), chunk, regionMap, blockLookup, biomeLookup);
                                regionModified = true;
                            }
                            if (regionModified) {
                                modified.set(true);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                ++regionIndex;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.mapFile.saveBulk(regionMap, service);
            for (Map.Entry entry : regionMap.entrySet()) {
                converted.add("r." + ((RegionKey)entry.getKey()).x() + "." + ((RegionKey)entry.getKey()).z() + ".mca");
                int savedCount = saved.incrementAndGet();
                if (savedCount != files.length && savedCount % 128 != 0) continue;
                AbstractCivModernMod.LOGGER.info("Saved " + savedCount + " regions...");
            }
            AbstractCivModernMod.LOGGER.info("Processed " + regionIndex + "/" + files.length + " regions...");
            regionMap.clear();
        }
        this.mapFile.saveBlockIds(blockLookup.getNames());
        this.mapFile.saveBiomeIds(biomeLookup.getNames());
        if (modified.get()) {
            MapFolder.ModData modData = new MapFolder.ModData();
            modData.regions = new ArrayList(converted);
            this.mapFile.getHistory().mods.put("journeymap", modData);
            this.mapFile.saveHistory();
        }
        AbstractCivModernMod.LOGGER.info("Conversion complete for " + this.name + "/" + this.dimension);
    }

    private void loadData(RegionKey regionKey, RegionKey chunkCords, class_2487 chunkData, Map<RegionKey, RegionLoader> regionMap, IdLookup blockLookup, IdLookup biomeLookup) {
        int[] chunk = new int[256];
        short[] ylevels = new short[256];
        int[] westY = new int[16];
        int[] northY = new int[16];
        Arrays.fill(westY, Integer.MIN_VALUE);
        Arrays.fill(northY, Integer.MIN_VALUE);
        for (String xzCords : chunkData.method_10541()) {
            int blockId;
            Integer y;
            class_2487 cordData = (class_2487)chunkData.method_10562(xzCords).get();
            if (xzCords.equals("LastChange") || xzCords.equals("pos") || !cordData.method_10545("biome_name")) continue;
            int[] blockXZ = this.parseXZFromKey(xzCords);
            if (blockXZ.length != 2) {
                AbstractCivModernMod.LOGGER.warn("In Region {},{} unknown cord in format: {}", (Object)regionKey.x(), (Object)regionKey.z(), (Object)xzCords);
                continue;
            }
            int rawX = blockXZ[0];
            int rawZ = blockXZ[1];
            int x = rawX & 0xF;
            int z = rawZ & 0xF;
            int dataValue = 0;
            class_2487 blockstates = (class_2487)cordData.method_10562("blockstates").get();
            String blockName = (String)((class_2487)blockstates.method_10562("" + (y = (Integer)cordData.method_10550("top_y").get())).get()).method_10558("Name").get();
            if (blockName == null) {
                blockName = "minecraft:air";
            }
            if ((blockId = blockLookup.getOrCreateId(blockName) + 1) > 65535) {
                AbstractCivModernMod.LOGGER.warn("convert block " + blockId + " at pos (" + x + ", " + z + ") in (" + regionKey.x() + ", " + regionKey.z() + ")");
                blockId = 0;
            }
            dataValue |= blockId << 16;
            String biomeName = (String)cordData.method_10558("biome_name").get();
            int biomeId = biomeLookup.getOrCreateId(biomeName);
            if (biomeId > 255) {
                AbstractCivModernMod.LOGGER.warn("biome " + biomeId + " at pos (" + x + ", " + z + ") in (" + regionKey.x() + ", " + regionKey.z() + ")");
                biomeId = 0;
            }
            dataValue |= biomeId;
            String westYCord = rawX - 1 + "," + rawZ;
            if (chunkData.method_10545(westYCord)) {
                class_2487 westYTag = (class_2487)chunkData.method_10562(westYCord).get();
                if (westYTag.method_10545("top_y")) {
                    Integer westYValue = (Integer)westYTag.method_10550("top_y").get();
                    if (westYValue > y) {
                        dataValue |= 0xC00;
                    } else if (westYValue == y) {
                        dataValue |= 0x400;
                    }
                }
            } else {
                dataValue |= 0x800;
            }
            String northYCord = rawX + "," + (rawZ - 1);
            if (chunkData.method_10545(northYCord)) {
                class_2487 northYTag = (class_2487)chunkData.method_10562(northYCord).get();
                if (northYTag.method_10545("top_y")) {
                    Integer northYValue = (Integer)northYTag.method_10550("top_y").get();
                    if (northYValue > y) {
                        dataValue |= 0x300;
                    } else if (northYValue == y) {
                        dataValue |= 0x100;
                    }
                }
            } else {
                dataValue |= 0x200;
            }
            int index = x * 16 + z;
            chunk[index] = dataValue;
            ylevels[index] = y.shortValue();
        }
        RegionLoader regionData = regionMap.computeIfAbsent(regionKey, k -> new RegionLoader((RegionKey)k, this.mapFile));
        int[] saved = regionData.getOrLoadMapData();
        short[] savedY = regionData.getOrLoadYLevels();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int globalBlockX = chunkCords.x() * 16 + x;
                int globalBlockZ = chunkCords.z() * 16 + z;
                int index = globalBlockZ + globalBlockX * 512;
                saved[index] = chunk[x * 16 + z];
                savedY[index] = ylevels[x * 16 + z];
            }
        }
    }

    private int[] parseXZFromKey(String cord) {
        String[] cordsStr = cord.split("\\,");
        if (cordsStr.length != 2) {
            return new int[0];
        }
        try {
            int x = Integer.parseInt(cordsStr[0]);
            int z = Integer.parseInt(cordsStr[1]);
            return new int[]{x, z};
        }
        catch (NumberFormatException e) {
            return new int[0];
        }
    }

    @Override
    public RegionKey getRegionKey(String fileName) {
        String name = fileName.substring(2);
        String[] parts = name.split("\\.");
        if (parts.length != 3) {
            return null;
        }
        return new RegionKey(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }
}

