/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.data;

import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5455;
import net.minecraft.class_7924;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.map.ColoursConfig;
import sh.okx.civmodern.common.map.IdLookup;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class RegionMapUpdater {
    public static int SIZE = 512;
    private final RegionLoader loader;
    private final IdLookup blockLookup;
    private final IdLookup biomeLookup;

    public RegionMapUpdater(RegionLoader loader, IdLookup blockLookup, IdLookup biomeLookup) {
        this.loader = loader;
        this.blockLookup = blockLookup;
        this.biomeLookup = biomeLookup;
    }

    private int getHeight(class_5455 registryAccess, class_2791 chunk, int x, int z) {
        int depth;
        class_2248 block;
        class_2338.class_2339 pos = new class_2338.class_2339(chunk.method_12004().method_33939(x), chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1, chunk.method_12004().method_33941(z));
        do {
            pos.method_33098(pos.method_10264() - 1);
            class_2680 state = chunk.method_8320((class_2338)pos);
            if (state.method_26227().method_39360((class_3611)class_3612.field_15910) || state.method_26227().method_39360((class_3611)class_3612.field_15909)) {
                class_2338.class_2339 bottomPos = new class_2338.class_2339(pos.method_10263(), chunk.method_12005(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260()), pos.method_10260());
                depth = pos.method_10264() - bottomPos.method_10264();
                block = chunk.method_8320((class_2338)bottomPos).method_26204();
                continue;
            }
            block = state.method_26204();
            depth = 0;
        } while (ColoursConfig.BLOCK_COLOURS.getOrDefault(registryAccess.method_30530(class_7924.field_41254).method_10221((Object)block).toString(), block.method_26403().field_16011) <= 0 && pos.method_10264() > chunk.method_31607());
        return pos.method_10264() - depth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateChunk(class_5455 registryAccess, class_2791 chunk) {
        class_2378 registry = registryAccess.method_30530(class_7924.field_41236);
        boolean updated = false;
        int rx = chunk.method_12004().method_17887() * 16;
        int rz = chunk.method_12004().method_17888() * 16;
        this.loader.getLock().writeLock().lock();
        try {
            this.loader.loadAllData();
            int[] data = this.loader.getOrLoadMapData();
            short[] ylevels = this.loader.getOrLoadYLevels();
            short[] waterylevels = this.loader.getOrLoadWaterYLevels();
            long[] chunkTimestamps = this.loader.getOrLoadChunkTimestamps();
            short[] northY = new short[16];
            for (int x = 0; x < 16; ++x) {
                int pos = rz - 1 + (rx + x) * 512;
                if (pos < 0 || pos >= ylevels.length) {
                    northY[x] = Short.MIN_VALUE;
                    continue;
                }
                int waterY = waterylevels[pos];
                if (waterY != 0) {
                    northY[x] = (short)(waterY < 0 ? waterY : waterY - 1);
                    continue;
                }
                int y = ylevels[pos];
                if (y > 0) {
                    y = (short)(y - 1);
                } else if (y == 0) {
                    y = Short.MIN_VALUE;
                }
                northY[x] = y;
            }
            short[] westY = new short[16];
            for (int z = 0; z < 16; ++z) {
                int pos = rz + z + (rx - 1) * 512;
                if (pos < 0 || pos >= ylevels.length) {
                    westY[z] = Short.MIN_VALUE;
                    continue;
                }
                int waterY = waterylevels[pos];
                if (waterY != 0) {
                    westY[z] = (short)(waterY < 0 ? waterY : waterY - 1);
                    continue;
                }
                int y = ylevels[pos];
                if (y > 0) {
                    y = (short)(y - 1);
                } else if (y == 0) {
                    y = Short.MIN_VALUE;
                }
                westY[z] = y;
            }
            int chunkIndex = rz / 16 + rx / 16 * 512 / 16;
            chunkTimestamps[chunkIndex] = System.currentTimeMillis();
            for (int x = rx; x < rx + 16; ++x) {
                for (int z = rz; z < rz + 16; ++z) {
                    int depth;
                    class_2248 block;
                    class_2338.class_2339 pos = new class_2338.class_2339(x + chunk.method_12004().method_17885() * 512, chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1, z + chunk.method_12004().method_17886() * 512);
                    int dataValue = 0;
                    int current = data[z + x * 512];
                    short yCurrent = ylevels[z + x * 512];
                    do {
                        pos.method_33098(pos.method_10264() - 1);
                        class_2680 state = chunk.method_8320((class_2338)pos);
                        if (state.method_26227().method_39360((class_3611)class_3612.field_15910) || state.method_26227().method_39360((class_3611)class_3612.field_15909)) {
                            class_2338.class_2339 bottomPos = new class_2338.class_2339(pos.method_10263(), chunk.method_12005(class_2902.class_2903.field_13195, pos.method_10263(), pos.method_10260()), pos.method_10260());
                            depth = pos.method_10264() - bottomPos.method_10264();
                            block = chunk.method_8320((class_2338)bottomPos).method_26204();
                            continue;
                        }
                        block = state.method_26204();
                        depth = 0;
                    } while (ColoursConfig.BLOCK_COLOURS.getOrDefault(registryAccess.method_30530(class_7924.field_41254).method_10221((Object)block).toString(), block.method_26403().field_16011) <= 0 && pos.method_10264() > chunk.method_31607());
                    int blockId = this.blockLookup.getOrCreateId(registryAccess.method_30530(class_7924.field_41254).method_10221((Object)block).toString()) + 1;
                    if (blockId > 65534) {
                        AbstractCivModernMod.LOGGER.warn("block " + blockId + " at pos " + String.valueOf(pos));
                        blockId = 0;
                    }
                    dataValue |= blockId << 16;
                    dataValue |= Math.min(depth, 15) << 12;
                    if (westY[z - rz] != Short.MIN_VALUE) {
                        if (westY[z - rz] > pos.method_10264() - depth) {
                            dataValue |= 0xC00;
                        } else if (westY[z - rz] == pos.method_10264() - depth) {
                            dataValue |= 0x400;
                        }
                    } else {
                        dataValue = (current >> 10 & 3) == 0 ? (dataValue |= 0x800) : (dataValue |= current & 0xC00);
                    }
                    westY[z - rz] = (short)(pos.method_10264() - depth);
                    if (northY[x - rx] != Short.MIN_VALUE) {
                        if (northY[x - rx] > pos.method_10264() - depth) {
                            dataValue |= 0x300;
                        } else if (northY[x - rx] == pos.method_10264() - depth) {
                            dataValue |= 0x100;
                        }
                    } else {
                        dataValue = (current >> 8 & 3) == 0 ? (dataValue |= 0x200) : (dataValue |= current & 0x300);
                    }
                    northY[x - rx] = (short)(pos.method_10264() - depth);
                    int biomeId = this.biomeLookup.getOrCreateId(registry.method_10221((Object)((class_1959)chunk.method_16359(pos.method_10263() >> 2, pos.method_10264() >> 2, pos.method_10260() >> 2).comp_349())).toString());
                    if (biomeId > 255) {
                        AbstractCivModernMod.LOGGER.warn("biome " + biomeId + " at pos " + String.valueOf(pos));
                        biomeId = 0;
                    }
                    data[z + x * 512] = dataValue |= biomeId;
                    short ylevel = (short)pos.method_10264();
                    if (ylevel >= 0) {
                        ylevel = (short)(ylevel + 1);
                    }
                    ylevels[z + x * 512] = ylevel;
                    if (depth != 0) {
                        short waterylevel = (short)(pos.method_10264() - depth);
                        if (waterylevel >= 0) {
                            waterylevel = (short)(waterylevel + 1);
                        }
                        waterylevels[z + x * 512] = waterylevel;
                    }
                    if (current == dataValue && ylevel == yCurrent) continue;
                    updated = true;
                }
            }
        }
        finally {
            this.loader.getLock().writeLock().unlock();
        }
        return updated;
    }
}

