/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.data;

import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class RegionReference {
    private volatile RegionLoader hardReference;
    private volatile SoftReference<RegionLoader> softReference;
    private final AtomicInteger refCount;
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public RegionReference(RegionLoader loader, int initialRefCount) {
        this.hardReference = loader;
        this.refCount = new AtomicInteger(initialRefCount);
    }

    public RegionLoader getLoader() {
        if (this.hardReference == null) {
            return this.softReference.get();
        }
        return this.hardReference;
    }

    public void addReference(RegionLoader loader) {
        this.refCount.incrementAndGet();
        if (this.hardReference == null) {
            this.hardReference = Objects.requireNonNull(this.softReference.get());
            if (loader != this.hardReference) {
                throw new IllegalStateException();
            }
        }
    }

    public void removeReference() {
        int i = this.refCount.decrementAndGet();
        if (i < 0) {
            throw new IllegalStateException("ref count is negative");
        }
        if (i == 0) {
            this.softReference = new SoftReference<RegionLoader>(this.hardReference);
            this.hardReference = null;
        }
    }

    public void markDirty() {
        Objects.requireNonNull(this.hardReference);
        if (!this.isReferenced()) {
            throw new IllegalStateException("cannot mark dirty region with no references");
        }
        if (!this.dirty.getAndSet(true)) {
            this.addReference(null);
        }
    }

    public boolean clearDirty() {
        boolean dirty = this.dirty.getAndSet(false);
        if (dirty) {
            this.removeReference();
        }
        return dirty;
    }

    public boolean isReferenced() {
        return this.refCount.get() > 0;
    }
}

