/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.screen;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import sh.okx.civmodern.common.gui.widget.ColourTextEditBox;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;
import sh.okx.civmodern.common.map.screen.Modal;
import sh.okx.civmodern.common.map.waypoints.Waypoint;
import sh.okx.civmodern.common.map.waypoints.Waypoints;

public class EditWaypointModal
extends Modal<FlowLayout> {
    private final Waypoints waypoints;
    private TextBoxComponent xBox;
    private TextBoxComponent yBox;
    private TextBoxComponent zBox;
    private ColourTextEditBox colourBox;
    private HsbColourPicker colourPicker;
    private int colour;
    private int previewColour;
    private TextBoxComponent nameBox;
    private class_4185 doneButton;
    private Waypoint waypoint;
    private boolean targeting;

    public EditWaypointModal(Waypoints waypoints) {
        super(OwoUIAdapter.createWithoutScreen((int)(class_310.method_1551().method_22683().method_4486() / 2 - 104 - 12), (int)48, (int)220, (int)116, Containers::verticalFlow));
        this.previewColour = this.colour = 0xFF0000;
        this.targeting = false;
        ((FlowLayout)this.layout.rootComponent).allowOverflow(true);
        this.waypoints = waypoints;
    }

    public void setWaypoint(Waypoint waypoint) {
        this.waypoint = waypoint;
        ((FlowLayout)this.layout.rootComponent).clearChildren();
        if (this.waypoint == null) {
            return;
        }
        Pattern inputFilter = Pattern.compile("^-?[0-9]*$");
        Predicate<String> numFilter = s -> inputFilter.matcher((CharSequence)s).matches();
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.done()).method_46431();
        class_4185 cancelButton = class_4185.method_46430((class_2561)class_5244.field_24335, button -> {
            this.setVisible(false);
            this.waypoint = null;
        }).method_46431();
        ImageButton deleteButton = new ImageButton(0, 0, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/delete.png"), imbg -> {
            if (this.waypoint != null) {
                this.waypoints.removeWaypoint(this.waypoint);
            }
            this.waypoint = null;
            this.setVisible(false);
        });
        ImageButton copyButton = new ImageButton(0, 0, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/copy.png"), imbg -> {
            StringBuilder builder = new StringBuilder("[");
            if (!this.waypoint.name().isBlank()) {
                builder.append("name:%s,".formatted(this.waypoint.name()));
            }
            builder.append("x:%s,y:%s,z:%s]".formatted(this.waypoint.x(), this.waypoint.y(), this.waypoint.z()));
            class_310.method_1551().field_1774.method_1455(builder.toString());
            class_310.method_1551().method_1507(null);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"civmodern.map.copy", (Object[])new Object[]{class_2561.method_43470((String)builder.toString())}).method_54663(3645347), false);
            class_310.method_1551().field_1774.method_1455(builder.toString());
            this.waypoint = null;
        });
        this.colourPicker = new HsbColourPicker(0, 0, 20, 20, waypoint.colour(), colour -> {
            this.colourBox.setColourFromInt((int)colour);
            this.colour = colour;
            this.previewColour = colour;
        }, preview -> {
            this.previewColour = Objects.requireNonNullElse(preview, this.colour);
        }, () -> {});
        this.colour = this.previewColour = waypoint.colour();
        this.colourPicker.setRVisible(false);
        ImageButton coordsButton = new ImageButton(0, 0, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/target.png"), imbg -> {
            this.visible = false;
            this.targeting = true;
        });
        this.xBox = Components.textBox((Sizing)Sizing.fixed((int)44), (String)Integer.toString(waypoint.x()));
        this.xBox.method_1890(numFilter);
        this.xBox.onChanged().subscribe(value -> this.updateDone());
        this.yBox = Components.textBox((Sizing)Sizing.fixed((int)26), (String)Integer.toString(waypoint.y()));
        this.yBox.method_1890(numFilter);
        this.yBox.onChanged().subscribe(value -> this.updateDone());
        this.zBox = Components.textBox((Sizing)Sizing.fixed((int)44), (String)Integer.toString(waypoint.z()));
        this.zBox.method_1890(numFilter);
        this.zBox.onChanged().subscribe(value -> this.updateDone());
        this.colourBox = new ColourTextEditBox(Sizing.fixed((int)55), () -> this.colour, c -> {
            this.colour = c;
            this.previewColour = c;
        });
        ((FlowLayout)this.layout.rootComponent).clearChildren();
        this.nameBox = Components.textBox((Sizing)Sizing.expand(), (String)waypoint.name());
        ((FlowLayout)this.layout.rootComponent).child(Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)24)).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Name")).margins(Insets.right((int)8))).child((Component)this.nameBox).verticalAlignment(VerticalAlignment.CENTER).margins(Insets.horizontal((int)4).withTop(4))).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)40)).child((Component)Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)2, (int)3).child((Component)Components.label((class_2561)class_2561.method_43470((String)"X")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 0).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Y")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 1).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Z")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 2).child(this.xBox.margins(Insets.right((int)3)), 1, 0).child(this.yBox.margins(Insets.right((int)3)), 1, 1).child(this.zBox.margins(Insets.right((int)3)), 1, 2).positioning(Positioning.relative((int)0, (int)0))).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)40)).child(coordsButton.margins(Insets.right((int)4))).child(copyButton.margins(Insets.right((int)4))).child((Component)deleteButton).margins(Insets.bottom((int)6)).alignment(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM).positioning(Positioning.relative((int)100, (int)100)))).margins(Insets.horizontal((int)4).withTop(4))).child(Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child(this.doneButton.horizontalSizing(Sizing.fill((int)28)).margins(Insets.right((int)8).withTop(1)).positioning(Positioning.relative((int)0, (int)0))).child(cancelButton.horizontalSizing(Sizing.fill((int)28)).margins(Insets.right((int)8).withTop(1))).child((Component)this.colourBox).child(this.colourPicker.margins(Insets.top((int)1).withLeft(2))).horizontalAlignment(HorizontalAlignment.RIGHT).margins(Insets.horizontal((int)4).withTop(4))).surface(Surface.DARK_PANEL).padding(Insets.of((int)6));
        this.layout.inflateAndMount();
    }

    public String getName() {
        return this.nameBox.method_1882();
    }

    public Waypoint getWaypoint() {
        return this.waypoint;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.visible) {
            this.colourPicker.setRVisible(true);
            this.colourPicker.method_48579(guiGraphics, mouseX, mouseY, delta);
            this.colourPicker.setRVisible(false);
        }
    }

    @Override
    public boolean method_25405(double d, double e) {
        if (!this.visible) {
            return false;
        }
        if (super.method_25405(d, e)) {
            return true;
        }
        return this.colourPicker.method_25405(d, e);
    }

    @Override
    public boolean method_25402(double d, double e, int i) {
        if (!this.visible) {
            return false;
        }
        return this.colourPicker.method_25402(d, e, i) || super.method_25402(d, e, i);
    }

    public void method_16014(double d, double e) {
        if (!this.visible) {
            return;
        }
        this.colourPicker.method_16014(d, e);
    }

    @Override
    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (!this.visible) {
            return false;
        }
        if (this.colourPicker.method_25403(d, e, i, f, g)) {
            return true;
        }
        return super.method_25403(d, e, i, f, g);
    }

    @Override
    public boolean method_25406(double d, double e, int i) {
        if (!this.visible) {
            return false;
        }
        if (this.colourPicker.method_25406(d, e, i)) {
            return true;
        }
        return super.method_25406(d, e, i);
    }

    public void updateDone() {
        try {
            Integer.parseInt(this.xBox.method_1882());
            Integer.parseInt(this.yBox.method_1882());
            Integer.parseInt(this.zBox.method_1882());
            this.doneButton.field_22763 = true;
        }
        catch (NumberFormatException ex) {
            this.doneButton.field_22763 = false;
        }
    }

    public void done() {
        try {
            int x = Integer.parseInt(this.xBox.method_1882());
            int y = Integer.parseInt(this.yBox.method_1882());
            int z = Integer.parseInt(this.zBox.method_1882());
            this.waypoints.removeWaypoint(this.waypoint);
            this.waypoints.addWaypoint(new Waypoint(this.nameBox.method_1882(), x, y, z, this.waypoint.icon(), this.colour));
            this.setVisible(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isTargeting() {
        return this.targeting;
    }

    public boolean hasChanged() {
        try {
            return this.getX() != this.waypoint.x() || this.getZ() != this.waypoint.z() || this.getY() != this.waypoint.y() || this.previewColour != this.waypoint.colour();
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public void setTargetResult(int x, int y, int z) {
        this.xBox.method_1852(Integer.toString(x));
        this.yBox.method_1852(Integer.toString(y));
        this.zBox.method_1852(Integer.toString(z));
        this.targeting = false;
        this.visible = true;
    }

    public int getX() {
        return Integer.parseInt(this.xBox.method_1882());
    }

    public int getY() {
        return Integer.parseInt(this.yBox.method_1882());
    }

    public int getZ() {
        return Integer.parseInt(this.zBox.method_1882());
    }

    public int getPreviewColour() {
        return this.previewColour;
    }

    public int getColour() {
        return this.colour;
    }
}

