/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.screen;

import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.core.AnimatableProperty;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.VerticalAlignment;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.Observable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.joml.Matrix3x2fStack;
import org.w3c.dom.Element;

public class ScalableLabelComponent
extends BaseComponent {
    protected final class_327 textRenderer;
    protected class_2561 text;
    protected List<class_5481> wrappedText;
    protected VerticalAlignment verticalTextAlignment;
    protected HorizontalAlignment horizontalTextAlignment;
    protected final AnimatableProperty<Color> color;
    protected final Observable<Integer> lineHeight;
    protected final Observable<Integer> lineSpacing;
    protected boolean shadow;
    protected int maxWidth;
    protected float scale;
    protected boolean hover;
    protected Consumer<ScalableLabelComponent> onPress;

    protected ScalableLabelComponent(class_2561 text, Consumer<ScalableLabelComponent> onPress) {
        this.textRenderer = class_310.method_1551().field_1772;
        this.verticalTextAlignment = VerticalAlignment.TOP;
        this.horizontalTextAlignment = HorizontalAlignment.LEFT;
        this.color = AnimatableProperty.of((Animatable)Color.WHITE);
        Objects.requireNonNull(this.textRenderer);
        this.lineHeight = Observable.of((Object)9);
        this.lineSpacing = Observable.of((Object)2);
        this.hover = true;
        this.text = text;
        this.wrappedText = new ArrayList<class_5481>();
        this.shadow = false;
        this.maxWidth = Integer.MAX_VALUE;
        this.onPress = onPress;
        Observable.observeAll(() -> this.notifyParentIfMounted(), (Observable[])new Observable[]{this.lineHeight, this.lineSpacing});
    }

    public ScalableLabelComponent textHeight(int height) {
        float f = height;
        Objects.requireNonNull(this.textRenderer);
        this.scale = f / 9.0f;
        this.lineHeight.set((Object)height);
        return this;
    }

    public ScalableLabelComponent text(class_2561 text) {
        this.text = text;
        this.notifyParentIfMounted();
        return this;
    }

    public class_2561 text() {
        return this.text;
    }

    public ScalableLabelComponent maxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.notifyParentIfMounted();
        return this;
    }

    public ScalableLabelComponent hoverEffect(boolean hover) {
        this.hover = hover;
        return this;
    }

    public int maxWidth() {
        return this.maxWidth;
    }

    public ScalableLabelComponent shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public boolean shadow() {
        return this.shadow;
    }

    public ScalableLabelComponent color(Color color) {
        this.color.set((Object)color);
        return this;
    }

    public AnimatableProperty<Color> color() {
        return this.color;
    }

    public ScalableLabelComponent verticalTextAlignment(VerticalAlignment verticalAlignment) {
        this.verticalTextAlignment = verticalAlignment;
        return this;
    }

    public VerticalAlignment verticalTextAlignment() {
        return this.verticalTextAlignment;
    }

    public ScalableLabelComponent horizontalTextAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalTextAlignment = horizontalAlignment;
        return this;
    }

    public HorizontalAlignment horizontalTextAlignment() {
        return this.horizontalTextAlignment;
    }

    public ScalableLabelComponent lineHeight(int lineHeight) {
        this.lineHeight.set((Object)lineHeight);
        return this;
    }

    public int lineHeight() {
        return (Integer)this.lineHeight.get();
    }

    public ScalableLabelComponent lineSpacing(int lineSpacing) {
        this.lineSpacing.set((Object)lineSpacing);
        return this;
    }

    public int lineSpacing() {
        return (Integer)this.lineSpacing.get();
    }

    protected int determineHorizontalContentSize(Sizing sizing) {
        int widestText = 0;
        for (class_5481 line : this.wrappedText) {
            int width = this.textRenderer.method_30880(line);
            if (width <= widestText) continue;
            widestText = width;
        }
        if (widestText > this.maxWidth) {
            this.wrapLines();
            return this.determineHorizontalContentSize(sizing);
        }
        return widestText;
    }

    protected int determineVerticalContentSize(Sizing sizing) {
        this.wrapLines();
        return this.textHeight();
    }

    public void inflate(Size space) {
        this.wrapLines();
        super.inflate(space);
    }

    private void wrapLines() {
        this.wrappedText = this.textRenderer.method_1728((class_5348)this.text, ((Sizing)this.horizontalSizing.get()).isContent() ? this.maxWidth : this.width);
    }

    protected int textHeight() {
        return this.wrappedText.size() * (this.lineHeight() + this.lineSpacing()) - this.lineSpacing();
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.color.update(delta);
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate(0.0f, (float)(1 / class_310.method_1551().method_22683().method_4495()));
        int x = this.x;
        int y = this.y;
        if (((Sizing)this.horizontalSizing.get()).isContent()) {
            x += ((Sizing)this.horizontalSizing.get()).value;
        }
        if (((Sizing)this.verticalSizing.get()).isContent()) {
            y += ((Sizing)this.verticalSizing.get()).value;
        }
        switch (this.verticalTextAlignment) {
            case CENTER: {
                y += (this.height - this.textHeight()) / 2;
                break;
            }
            case BOTTOM: {
                y += this.height - this.textHeight();
            }
        }
        int lambdaX = x;
        int lambdaY = y;
        float lambdaScale = this.scale;
        for (int i = 0; i < this.wrappedText.size(); ++i) {
            class_5481 renderText = this.wrappedText.get(i);
            int renderX = lambdaX;
            switch (this.horizontalTextAlignment) {
                case CENTER: {
                    renderX += (this.width - this.textRenderer.method_30880(renderText)) / 2;
                    break;
                }
                case RIGHT: {
                    renderX += this.width - this.textRenderer.method_30880(renderText);
                }
            }
            int renderY = lambdaY + i * (this.lineHeight() + this.lineSpacing());
            context.push();
            context.scale(lambdaScale, lambdaScale);
            float sx = (float)renderX / lambdaScale;
            float sy = (float)renderY / lambdaScale;
            float left = sx - (float)((Insets)this.margins.get()).left();
            float top = sy;
            float right = sx + (float)((int)((float)this.space.width() / lambdaScale));
            float bottom = sy + (float)this.height + (float)((Insets)this.margins.get()).bottom();
            float cx = (float)mouseX / lambdaScale;
            float cy = (float)mouseY / lambdaScale;
            if (this.hover && cx >= left && cx <= right && cy >= top - 2.0f && cy <= bottom + 2.0f) {
                context.method_25294((int)left, (int)top - 1, (int)right, (int)bottom + 1, -6250597);
            }
            context.method_51430(this.textRenderer, renderText, (int)sx, (int)sy, ((Color)this.color.get()).argb(), this.shadow);
            context.pop();
        }
        matrices.popMatrix();
    }

    public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
        context.method_51441(this.textRenderer, this.styleAt(mouseX - this.x, mouseY - this.y), mouseX, mouseY);
    }

    public boolean shouldDrawTooltip(double mouseX, double mouseY) {
        class_2583 hoveredStyle = this.styleAt((int)(mouseX - (double)this.x), (int)(mouseY - (double)this.y));
        return super.shouldDrawTooltip(mouseX, mouseY) || hoveredStyle != null && hoveredStyle.method_10969() != null && this.isInBoundingBox(mouseX, mouseY);
    }

    public boolean onMouseClick(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        float x = this.x;
        float y = this.y;
        if (((Sizing)this.horizontalSizing.get()).isContent()) {
            x += (float)((Sizing)this.horizontalSizing.get()).value;
        }
        if (((Sizing)this.verticalSizing.get()).isContent()) {
            y += (float)((Sizing)this.verticalSizing.get()).value;
        }
        float sx = x / this.scale;
        float sy = y / this.scale;
        float left = sx - (float)((Insets)this.margins.get()).left();
        float top = sy - 1.0f;
        float right = sx + (float)((int)((float)this.space.width() / this.scale));
        float bottom = sy + (float)this.height + 2.0f;
        double cx = mouseX / (double)this.scale;
        double cy = mouseY / (double)this.scale;
        if (this.hover && cx >= (double)left && cx <= (double)right && cy >= (double)(top - 2.0f) && cy <= (double)(bottom + 2.0f)) {
            this.onPress.accept(this);
            return true;
        }
        return false;
    }

    protected class_2583 styleAt(int mouseX, int mouseY) {
        return this.textRenderer.method_27527().method_30876(this.wrappedText.get(Math.min(mouseY / (this.lineHeight() + this.lineSpacing()), this.wrappedText.size() - 1)), mouseX);
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"text", UIParsing::parseText, this::text);
        UIParsing.apply(children, (String)"max-width", UIParsing::parseUnsignedInt, this::maxWidth);
        UIParsing.apply(children, (String)"color", Color::parse, this::color);
        UIParsing.apply(children, (String)"shadow", UIParsing::parseBool, this::shadow);
        UIParsing.apply(children, (String)"line-height", UIParsing::parseUnsignedInt, this::lineHeight);
        UIParsing.apply(children, (String)"line-spacing", UIParsing::parseUnsignedInt, this::lineSpacing);
        UIParsing.apply(children, (String)"vertical-text-alignment", VerticalAlignment::parse, this::verticalTextAlignment);
        UIParsing.apply(children, (String)"horizontal-text-alignment", HorizontalAlignment::parse, this::horizontalTextAlignment);
    }
}

