/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_11244;
import net.minecraft.class_11256;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_8646;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;
import sh.okx.civmodern.common.gui.Alignment;
import sh.okx.civmodern.common.map.MapCache;
import sh.okx.civmodern.common.map.RegionAtlasTexture;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoint;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoints;
import sh.okx.civmodern.common.map.waypoints.Waypoint;
import sh.okx.civmodern.common.map.waypoints.Waypoints;
import sh.okx.civmodern.common.rendering.BlitRenderState;
import sh.okx.civmodern.common.rendering.ChevronRenderState;
import sh.okx.civmodern.common.rendering.CivModernPipelines;

public class Minimap {
    private final Waypoints waypoints;
    private final PlayerWaypoints playerWaypoints;
    private final MapCache cache;
    private final CivMapConfig config;
    private final ColourProvider provider;
    private static final RegionAtlasTexture blank = new RegionAtlasTexture();

    public Minimap(Waypoints waypoints, PlayerWaypoints playerWaypoints, MapCache cache, CivMapConfig config, ColourProvider provider) {
        this.waypoints = waypoints;
        this.playerWaypoints = playerWaypoints;
        this.cache = cache;
        this.config = config;
        this.provider = provider;
    }

    public void onRender(PostRenderGameOverlayEvent event) {
        int translateX;
        if (!this.config.isMinimapEnabled()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_269 scoreboard = mc.field_1687.method_8428();
        class_266 objective = scoreboard.method_1189(class_8646.field_45156);
        if (mc.field_1690.field_1842 || mc.method_53526().method_53536() || mc.field_1690.field_1907.method_1434() && (!mc.method_1542() || mc.field_1724.field_3944.method_45732().size() > 1 || objective != null)) {
            event.guiGraphics().field_59826.method_70922((class_11256)new BlitRenderState(event.guiGraphics(), (source, stack) -> {}));
            return;
        }
        float zoom = this.config.getMinimapZoom();
        float size = this.config.getMinimapSize();
        class_332 graphics = event.guiGraphics();
        Matrix3x2fStack matrices = graphics.method_51448();
        matrices.pushMatrix();
        int offsetX = this.config.getMinimapX();
        int offsetY = this.config.getMinimapY();
        int height = class_310.method_1551().method_22683().method_4502();
        int width = class_310.method_1551().method_22683().method_4486();
        int translateY = switch (this.config.getMinimapAlignment()) {
            case Alignment.TOP_LEFT -> {
                translateX = offsetX;
                yield offsetY;
            }
            case Alignment.TOP_RIGHT -> {
                translateX = width - offsetX - this.config.getMinimapSize();
                yield offsetY;
            }
            case Alignment.BOTTOM_RIGHT -> {
                translateX = width - offsetX - this.config.getMinimapSize();
                yield height - offsetY - this.config.getMinimapSize();
            }
            default -> {
                translateX = offsetX;
                yield height - offsetY - this.config.getMinimapSize();
            }
        };
        matrices.translate((float)translateX, (float)translateY);
        class_746 player = class_310.method_1551().field_1724;
        float px = (float)class_3532.method_16436((double)event.deltaTick(), (double)player.field_6014, (double)player.method_23317());
        float pz = (float)class_3532.method_16436((double)event.deltaTick(), (double)player.field_5969, (double)player.method_23321());
        float x = px - size * zoom / 2.0f;
        float y = pz - size * zoom / 2.0f;
        float drawnX = 0.0f;
        float drawnY = 0.0f;
        ArrayList<BlitRenderState.Renderer> renderers = new ArrayList<BlitRenderState.Renderer>();
        for (float screenX = 0.0f; screenX < size * zoom + 4096.0f; screenX += 4096.0f) {
            float tmp = 0.0f;
            for (float screenY = 0.0f; screenY < size * zoom + 4096.0f; screenY += 4096.0f) {
                float realX = x + screenX;
                float realY = y + screenY;
                float renderX = realX - this.floatMod(realX, 4096.0f);
                float renderY = realY - this.floatMod(realY, 4096.0f);
                RegionKey key = new RegionKey(Math.floorDiv((int)renderX, 4096), Math.floorDiv((int)renderY, 4096));
                RegionAtlasTexture texture = this.cache.getTexture(key);
                float xOff = renderX - x + 4096.0f;
                float yOff = renderY - y + 4096.0f;
                texture = texture == null ? blank : texture;
                renderers.add(texture.drawLinear(graphics, drawnX, drawnY, zoom, screenX == 0.0f ? 4096.0f - xOff : 0.0f, screenY == 0.0f ? 4096.0f - yOff : 0.0f, 4096.0f, 4096.0f, Math.max(0.0f, size * zoom - drawnX), Math.max(0.0f, size * zoom - drawnY), translateX, translateY));
                drawnY += screenY == 0.0f ? yOff : 4096.0f;
                tmp += xOff;
            }
            drawnY = 0.0f;
            drawnX += screenX == 0.0f ? tmp / 2.0f : 4096.0f;
        }
        graphics.field_59826.method_70922((class_11256)new BlitRenderState(graphics, (source, stack) -> renderers.forEach(r -> r.render(source, stack))));
        if (this.config.isPlayerWaypointsEnabled()) {
            for (PlayerWaypoint waypoint : this.playerWaypoints.getWaypoints()) {
                double wx = (double)waypoint.x() + 0.5;
                double wz = (double)waypoint.z() + 0.5;
                double tx = (wx - (double)x) / (double)zoom;
                double ty = (wz - (double)y) / (double)zoom;
                if (tx < 0.0 || ty < 0.0 || tx > (double)size || ty > (double)size) continue;
                matrices.pushMatrix();
                matrices.translate((float)tx, (float)ty);
                boolean old = waypoint.timestamp().until(Instant.now(), ChronoUnit.MINUTES) >= 10L;
                int colour = (old ? 119 : 255) << 24 | 0xFFFFFF;
                waypoint.render(graphics, colour);
                matrices.popMatrix();
            }
        }
        List<Waypoint> waypointList = this.waypoints.getWaypoints();
        HashMap<String, List> waypointByIcon = new HashMap<String, List>();
        for (Waypoint waypoint : waypointList) {
            waypointByIcon.computeIfAbsent(waypoint.icon(), k -> new ArrayList()).add(waypoint);
        }
        matrices.pushMatrix();
        for (List waypointGroup : waypointByIcon.values()) {
            for (Waypoint waypoint : waypointGroup) {
                double wx = (double)waypoint.x() + 0.5;
                double wz = (double)waypoint.z() + 0.5;
                double tx = (wx - (double)x) / (double)zoom;
                double ty = (wz - (double)y) / (double)zoom;
                if (tx < 0.0 || ty < 0.0 || tx > (double)size || ty > (double)size) continue;
                matrices.pushMatrix();
                matrices.translate((float)tx, (float)ty);
                waypoint.render2D(graphics);
                matrices.popMatrix();
            }
        }
        matrices.popMatrix();
        matrices.pushMatrix();
        matrices.translate(size / 2.0f, size / 2.0f);
        matrices.rotate((float)Math.toRadians(player.method_5705(event.deltaTick()) % 360.0f));
        matrices.scale(4.0f, 4.0f);
        int chevronColour = this.provider.getChevronColour() | 0xFF000000;
        matrices.translate(0.0f, 0.75f);
        graphics.field_59826.method_70919((class_11244)new ChevronRenderState(CivModernPipelines.GUI_TRIANGLE_STRIP_BLEND, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), chevronColour));
        matrices.popMatrix();
        matrices.popMatrix();
    }

    private float floatMod(float x, float y) {
        return x - (float)Math.floor(x / y) * y;
    }

    public void cycleZoom() {
        float zoom = this.config.getMinimapZoom();
        if ((zoom /= 2.0f) < 0.5f) {
            zoom = 16.0f;
        }
        this.config.setMinimapZoom(zoom);
    }

    static {
        RenderSystem.queueFencedTask(blank::init);
    }
}

