/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.screen;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;
import sh.okx.civmodern.common.map.screen.Modal;
import sh.okx.civmodern.common.map.waypoints.Waypoint;
import sh.okx.civmodern.common.map.waypoints.Waypoints;

public class NewWaypointModal
extends Modal<FlowLayout> {
    private final Waypoints waypoints;
    private TextBoxComponent xBox;
    private TextBoxComponent yBox;
    private TextBoxComponent zBox;
    private TextBoxComponent nameBox;
    private class_4185 doneButton;
    private HsbColourPicker colourPicker;
    private int colour;
    private int previewColour;
    private boolean targeting;

    public NewWaypointModal(Waypoints waypoints) {
        super(OwoUIAdapter.createWithoutScreen((int)(class_310.method_1551().method_22683().method_4486() / 2 - 104), (int)48, (int)196, (int)116, Containers::verticalFlow));
        this.previewColour = this.colour = 0xFF0000;
        this.targeting = false;
        ((FlowLayout)this.layout.rootComponent).allowOverflow(true);
        this.waypoints = waypoints;
    }

    public void open(String name, int x, int y, int z) {
        Pattern inputFilter = Pattern.compile("^-?[0-9]*$");
        Predicate<String> numFilter = s -> inputFilter.matcher((CharSequence)s).matches();
        this.doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.done()).method_46431();
        ImageButton coordsButton = new ImageButton(0, 0, 20, 20, class_2960.method_60655((String)"civmodern", (String)"gui/target.png"), imbg -> {
            this.visible = false;
            this.targeting = true;
        });
        this.xBox = Components.textBox((Sizing)Sizing.fixed((int)44), (String)Integer.toString(x));
        this.xBox.method_1890(numFilter);
        this.xBox.onChanged().subscribe(value -> this.updateDone());
        this.yBox = Components.textBox((Sizing)Sizing.fixed((int)26), (String)Integer.toString(y));
        this.yBox.method_1890(numFilter);
        this.yBox.onChanged().subscribe(value -> this.updateDone());
        this.zBox = Components.textBox((Sizing)Sizing.fixed((int)44), (String)Integer.toString(z));
        this.zBox.method_1890(numFilter);
        this.zBox.onChanged().subscribe(value -> this.updateDone());
        this.colourPicker = new HsbColourPicker(0, 0, 20, 20, this.colour, colour -> {
            this.colour = colour;
            this.previewColour = colour;
        }, preview -> {
            this.previewColour = Objects.requireNonNullElse(preview, this.colour);
        }, () -> {});
        this.colourPicker.setRVisible(false);
        this.nameBox = Components.textBox((Sizing)Sizing.expand(), (String)name);
        ((FlowLayout)this.layout.rootComponent).clearChildren();
        ((FlowLayout)this.layout.rootComponent).child(Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)24)).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Name")).margins(Insets.right((int)8))).child((Component)this.nameBox).verticalAlignment(VerticalAlignment.CENTER).margins(Insets.horizontal((int)4).withTop(4))).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.content()).child((Component)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)40)).child((Component)Containers.grid((Sizing)Sizing.content(), (Sizing)Sizing.content(), (int)2, (int)3).child((Component)Components.label((class_2561)class_2561.method_43470((String)"X")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 0).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Y")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 1).child((Component)Components.label((class_2561)class_2561.method_43470((String)"Z")).margins(Insets.of((int)0, (int)4, (int)1, (int)0)), 0, 2).child(this.xBox.margins(Insets.right((int)3)), 1, 0).child(this.yBox.margins(Insets.right((int)3)), 1, 1).child(this.zBox.margins(Insets.right((int)3)), 1, 2).positioning(Positioning.relative((int)0, (int)0))).child(Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)40)).child(coordsButton.margins(Insets.right((int)4))).child((Component)this.colourPicker).margins(Insets.bottom((int)6)).alignment(HorizontalAlignment.RIGHT, VerticalAlignment.BOTTOM).positioning(Positioning.relative((int)100, (int)100)))).margins(Insets.horizontal((int)4).withTop(4))).child(this.doneButton.margins(Insets.horizontal((int)4).withTop(4))).surface(Surface.DARK_PANEL).padding(Insets.of((int)6));
        this.layout.inflateAndMount();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        if (this.visible) {
            this.colourPicker.setRVisible(true);
            this.colourPicker.method_48579(guiGraphics, mouseX, mouseY, delta);
            this.colourPicker.setRVisible(false);
        }
    }

    @Override
    public boolean method_25405(double d, double e) {
        if (!this.visible) {
            return false;
        }
        if (super.method_25405(d, e)) {
            return true;
        }
        return this.colourPicker.method_25405(d, e);
    }

    @Override
    public boolean method_25402(double d, double e, int i) {
        if (!this.visible) {
            return false;
        }
        return this.colourPicker.method_25402(d, e, i) || super.method_25402(d, e, i);
    }

    public void method_16014(double d, double e) {
        if (!this.visible) {
            return;
        }
        this.colourPicker.method_16014(d, e);
    }

    @Override
    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (!this.visible) {
            return false;
        }
        if (this.colourPicker.method_25403(d, e, i, f, g)) {
            return true;
        }
        return super.method_25403(d, e, i, f, g);
    }

    public void updateDone() {
        try {
            Integer.parseInt(this.xBox.method_1882());
            Integer.parseInt(this.yBox.method_1882());
            Integer.parseInt(this.zBox.method_1882());
            this.doneButton.field_22763 = true;
        }
        catch (NumberFormatException ex) {
            this.doneButton.field_22763 = false;
        }
    }

    public void done() {
        try {
            int x = Integer.parseInt(this.xBox.method_1882());
            int y = Integer.parseInt(this.yBox.method_1882());
            int z = Integer.parseInt(this.zBox.method_1882());
            this.waypoints.addWaypoint(new Waypoint(this.nameBox.method_1882(), x, y, z, "waypoint", this.colour));
            this.setVisible(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isTargeting() {
        return this.targeting;
    }

    public void setTargetResult(int x, int y, int z) {
        this.xBox.method_1852(Integer.toString(x));
        this.yBox.method_1852(Integer.toString(y));
        this.zBox.method_1852(Integer.toString(z));
        this.targeting = false;
        this.visible = true;
    }

    public int getX() {
        return Integer.parseInt(this.xBox.method_1882());
    }

    public int getZ() {
        return Integer.parseInt(this.zBox.method_1882());
    }

    public int getY() {
        return Integer.parseInt(this.yBox.method_1882());
    }

    public int getPreviewColour() {
        return this.previewColour;
    }
}

