/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.radar;

import com.google.common.eventbus.Subscribe;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.OwoUIPipelines;
import io.wispforest.owo.ui.renderstate.CircleElementRenderState;
import io.wispforest.owo.ui.renderstate.LineElementRenderState;
import io.wispforest.owo.ui.renderstate.RingElementRenderState;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_10255;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11244;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1695;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_745;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;
import sh.okx.civmodern.common.rendering.CivModernPipelines;

public class Radar {
    private static boolean hideY = true;
    private final ColourProvider colourProvider;
    private final CivMapConfig config;
    private Set<class_745> playersInRange = new HashSet<class_745>();
    private int translateX;
    private int translateY;
    private int bgColour;
    private int fgColour;

    public Radar(CivMapConfig config, ColourProvider colourProvider) {
        this.config = config;
        this.colourProvider = colourProvider;
    }

    public static void playPlayerSound(String soundName, UUID playerKey) {
        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_63535(class_2960.method_60656((String)("block.note_block." + soundName)));
        if (soundEvent == null) {
            return;
        }
        float pitch = 0.5f + 1.5f * new Random(playerKey.hashCode()).nextFloat();
        float volume = 1.0f;
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)pitch, (float)volume));
    }

    @Subscribe
    private void onClientTick(@NotNull ClientTickEvent event) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            this.playersInRange = Collections.emptySet();
        }
    }

    private boolean hideY() {
        return hideY;
    }

    @Subscribe
    private void onWorldTickPing(@NotNull ClientTickEvent event) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        HashSet<class_745> newPlayersInRange = new HashSet<class_745>();
        for (class_1297 entity : world.method_18112()) {
            if (!(entity instanceof class_745)) continue;
            class_745 player = (class_745)entity;
            newPlayersInRange.add(player);
            if (this.playersInRange.contains(player)) continue;
            if (this.config.isPingEnabled()) {
                class_2338 pos = player.method_24515();
                String lastWaypointCommand = "/civmodern_openwaypoint [x:" + pos.method_10263() + ",y:" + (this.hideY() ? class_310.method_1551().field_1724.method_31478() : pos.method_10264()) + ",z:" + pos.method_10260() + ",name:" + player.method_5820() + "]";
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"civmodern.radar.enter", (Object[])new Object[]{player.method_5477(), class_2561.method_43470((String)(this.hideY() ? pos.method_10263() + " " + pos.method_10260() : pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_27692(class_124.field_1075)}).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609(lastWaypointCommand)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"civmodern.radar.hover")))), false);
            }
            if (!this.config.isPingSoundEnabled()) continue;
            Radar.playPlayerSound("pling", player.method_5667());
        }
        if (this.config.isPingEnabled()) {
            for (class_745 player : this.playersInRange) {
                if (newPlayersInRange.contains(player)) continue;
                class_2338 pos = player.method_24515();
                String lastWaypointCommand = "/civmodern_openwaypoint [x:" + pos.method_10263() + ",y:" + (this.hideY() ? class_310.method_1551().field_1724.method_31478() : pos.method_10264()) + ",z:" + pos.method_10260() + ",name:" + player.method_5820() + "]";
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"civmodern.radar.leave", (Object[])new Object[]{player.method_5477(), class_2561.method_43470((String)(this.hideY() ? pos.method_10263() + " " + pos.method_10260() : pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260())).method_27694(s -> s.method_27706(class_124.field_1075))}).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609(lastWaypointCommand)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"civmodern.radar.hover")))), false);
            }
        }
        this.playersInRange = newPlayersInRange;
    }

    @Subscribe
    private void onRender(@NotNull PostRenderGameOverlayEvent event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.method_53526().method_53536()) {
            return;
        }
        if (this.config.isRadarEnabled()) {
            this.render(event.guiGraphics(), event.deltaTick());
        }
    }

    private int radius() {
        return this.config.getRadarSize();
    }

    public void render(class_332 guiGraphics, float delta) {
        this.bgColour = this.colourProvider.getBackgroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getBackgroundTransparency()) * 255.0f) << 24;
        this.fgColour = this.colourProvider.getForegroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getTransparency()) * 255.0f) << 24;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        guiGraphics.method_51448().pushMatrix();
        int offsetX = this.config.getX() + this.config.getRadarSize();
        int offsetY = this.config.getY() + this.config.getRadarSize();
        int height = client.method_22683().method_4502();
        int width = client.method_22683().method_4486();
        switch (this.config.getAlignment()) {
            case TOP_LEFT: {
                this.translateX = offsetX;
                this.translateY = offsetY;
                break;
            }
            case TOP_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = offsetY;
                break;
            }
            case BOTTOM_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = height - offsetY;
                break;
            }
            case BOTTOM_LEFT: {
                this.translateX = offsetX;
                this.translateY = height - offsetY;
            }
        }
        guiGraphics.method_51448().translate((float)this.translateX, (float)this.translateY);
        this.renderCircleBackground(guiGraphics);
        for (int i = 1; i <= this.config.getRadarCircles(); ++i) {
            this.renderCircleBorder(guiGraphics, (float)this.radius() * ((float)i / (float)this.config.getRadarCircles()));
        }
        if (this.config.isNorthUp()) {
            guiGraphics.method_51448().rotate((float)Math.toRadians(180.0));
        } else {
            guiGraphics.method_51448().rotate((float)Math.toRadians(-player.method_5705(delta) % 360.0f));
        }
        this.renderLines(guiGraphics);
        if (this.config.isShowItems()) {
            this.renderItems(guiGraphics, delta);
        }
        this.renderBoatsMinecarts(guiGraphics, delta);
        this.renderPlayers(guiGraphics, delta);
        guiGraphics.method_51448().popMatrix();
    }

    private void renderBoatsMinecarts(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        for (class_1297 entity : minecraft.field_1687.method_18112()) {
            if (entity instanceof class_10255) {
                class_10255 boat = (class_10255)entity;
                this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)boat, delta, boat.method_31480(), 1.0f, 0.9f);
                continue;
            }
            if (!(entity instanceof class_1695)) continue;
            class_1695 minecart = (class_1695)entity;
            this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)minecart, delta, new class_1799((class_1935)class_1802.field_8045, 1), 1.1f, 0.9f);
        }
    }

    private void renderItems(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        int i = 0;
        for (class_1297 entity : minecraft.field_1687.method_18112()) {
            if (!(entity instanceof class_1542)) continue;
            class_1542 item = (class_1542)entity;
            this.renderEntity(guiGraphics, (class_1657)minecraft.field_1724, (class_1297)item, delta, item.method_6983(), 0.0f, 0.9f);
            if (++i <= 10000) continue;
            return;
        }
    }

    private double rescale(double dx, double dz) {
        if (!this.config.isRadarLogarithm()) {
            return 1.0;
        }
        double distance = Math.sqrt(dx * dx + dz * dz);
        if (distance < 0.1) {
            return 1.0;
        }
        double ld = Math.log1p(distance) / Math.log1p(this.config.getRange()) * this.config.getRange();
        return 1.0 / distance * ld;
    }

    private void renderEntity(class_332 guiGraphics, class_1657 player, class_1297 entity, float delta, class_1799 item, float blit, float entityScale) {
        double z;
        double dz;
        double scale = (double)this.config.getRadarSize() / this.config.getRange();
        double px = player.field_6038 + (player.method_23317() - player.field_6038) * (double)delta;
        double pz = player.field_5989 + (player.method_23321() - player.field_5989) * (double)delta;
        double x = entity.field_6038 + (entity.method_23317() - entity.field_6038) * (double)delta;
        double dx = px - x;
        if (dx * dx + (dz = pz - (z = entity.field_5989 + (entity.method_23321() - entity.field_5989) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) {
            return;
        }
        double logscale = this.rescale(dx, dz);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)(dx * scale * logscale), (float)(dz * scale * logscale));
        if (this.config.isNorthUp()) {
            guiGraphics.method_51448().rotate(180.0f);
        } else {
            guiGraphics.method_51448().rotate((float)Math.toRadians(player.method_5705(delta)));
        }
        guiGraphics.method_51448().scale(this.config.getIconSize() * entityScale, this.config.getIconSize() * entityScale);
        guiGraphics.method_51445(item, -8, -8);
        guiGraphics.method_51448().popMatrix();
    }

    private void renderPlayers(class_332 guiGraphics, float delta) {
        class_310 minecraft = class_310.method_1551();
        for (class_745 player : this.playersInRange) {
            double z;
            double dz;
            if (!player.method_5805()) continue;
            double v = (double)this.config.getRadarSize() / this.config.getRange();
            double px = minecraft.field_1724.field_6038 + (minecraft.field_1724.method_23317() - minecraft.field_1724.field_6038) * (double)delta;
            double pz = minecraft.field_1724.field_5989 + (minecraft.field_1724.method_23321() - minecraft.field_1724.field_5989) * (double)delta;
            double x = player.field_6038 + (player.method_23317() - player.field_6038) * (double)delta;
            double dx = px - x;
            if (dx * dx + (dz = pz - (z = player.field_5989 + (player.method_23321() - player.field_5989) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) continue;
            double logscale = this.rescale(dx, dz);
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)(dx * v * logscale), (float)(dz * v * logscale));
            guiGraphics.method_51448().scale(0.9f, 0.9f);
            class_640 entry = minecraft.field_1724.field_3944.method_2871(player.method_5667());
            if (this.config.isNorthUp()) {
                guiGraphics.method_51448().rotate((float)Math.toRadians(180.0));
            } else {
                guiGraphics.method_51448().rotate((float)Math.toRadians(minecraft.field_1724.method_5705(delta)));
            }
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(this.config.getIconSize(), this.config.getIconSize());
            class_2960 location = entry != null ? entry.method_52810().comp_1626() : class_2960.method_60656((String)"textures/entity/steve.png");
            class_7532.method_44445((class_332)guiGraphics, (class_2960)location, (int)-4, (int)-4, (int)8, (boolean)true, (boolean)false, (int)-1);
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate(0.0f, 4.5f * this.config.getIconSize());
            guiGraphics.method_51448().scale(0.6f * this.config.getTextSize(), 0.6f * this.config.getTextSize());
            class_5250 component = class_2561.method_43470((String)(player.method_5820() + " (" + (this.hideY() ? (int)Math.round(Math.sqrt(dx * dx + dz * dz)) : (int)player.method_23318()) + ")"));
            guiGraphics.method_27534(minecraft.field_1772, (class_2561)component, 0, 1, -1);
            guiGraphics.method_51448().popMatrix();
            guiGraphics.method_51448().popMatrix();
            guiGraphics.method_51448().popMatrix();
        }
    }

    private void renderCircleBackground(class_332 graphics) {
        graphics.field_59826.method_70919((class_11244)new CircleElementRenderState(OwoUIPipelines.GUI_TRIANGLE_FAN, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), 0, 0, 0.0, 360.0, 180, (double)((float)this.radius() + 0.5f), Color.ofArgb((int)this.bgColour)));
    }

    private void renderCircleBorder(class_332 graphics, float radius) {
        float thickness = radius == (float)this.radius() ? 1.0f : 0.5f;
        graphics.field_59826.method_70919((class_11244)new RingElementRenderState(CivModernPipelines.GUI_TRIANGLE_STRIP_BLEND, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), 0, 0, 0.0, 360.0, 180, (double)radius, (double)(radius + thickness), Color.ofArgb((int)this.fgColour), Color.ofArgb((int)this.fgColour)));
    }

    private void renderLines(class_332 graphics) {
        float thickness = 0.5f;
        float radius = (float)this.radius() + 0.5f;
        int numberOfLines = 4;
        float rotationRadians = (float)Math.PI / (float)numberOfLines;
        graphics.method_51448().pushMatrix();
        for (int i = 0; i < numberOfLines; ++i) {
            graphics.field_59826.method_70919((class_11244)new LineElementRenderState(CivModernPipelines.GUI_QUADS, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863(), (int)(-radius), 0, (int)radius, 0, (double)thickness, Color.ofArgb((int)this.fgColour)));
            graphics.method_51448().rotate(rotationRadians);
        }
        graphics.method_51448().popMatrix();
    }
}

