/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import org.lwjgl.opengl.GL11;

public class Texture {
    private final int id = TextureUtil.generateTextureId();
    private int width;
    private int height;
    private int[] pixels;

    public Texture(int width, int height) {
        RenderSystem.pixelStore((int)3317, (int)1);
        this.bind();
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
        RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        this.resize(width, height);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)32821, (int[])this.pixels);
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.pixels = new int[width * height];
    }

    public void setPixels(int[] pixels) {
        if (Objects.requireNonNull(pixels).length != this.width * this.height) {
            throw new IllegalArgumentException("Pixels length array incorrect, should be " + this.width * this.height + ", is " + pixels.length);
        }
        this.pixels = pixels;
    }

    public void update() {
        this.bind();
        RenderSystem.pixelStore((int)3312, (int)0);
        RenderSystem.pixelStore((int)3313, (int)0);
        RenderSystem.pixelStore((int)3314, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3317, (int)4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)32821, (int[])this.pixels);
    }

    public void bind() {
        RenderSystem.setShaderTexture((int)0, (int)this.id);
        RenderSystem.bindTexture((int)this.id);
    }

    public void unbind() {
        GlStateManager._bindTexture((int)0);
    }

    public void delete() {
        GlStateManager._deleteTexture((int)this.id);
    }

    public int getWidth() {
        return this.width;
    }

    public int getId() {
        return this.id;
    }
}

