/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class IdLookup {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Int2ObjectMap<String> fromId;
    private final Map<String, Integer> toId;
    private final String defaultLookup;
    private int highest = 0;

    public IdLookup(Int2ObjectMap<String> names, String defaultLookup) {
        this.fromId = new Int2ObjectOpenHashMap(names);
        this.defaultLookup = defaultLookup;
        this.toId = new ConcurrentHashMap<String, Integer>();
        for (Int2ObjectMap.Entry entry : names.int2ObjectEntrySet()) {
            this.toId.put((String)entry.getValue(), entry.getIntKey());
            if (entry.getIntKey() <= this.highest) continue;
            this.highest = entry.getIntKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrCreateId(String name) {
        int id = this.toId.getOrDefault(name, -1);
        if (id != -1) {
            return id;
        }
        try {
            this.lock.writeLock().lock();
            int n = this.toId.computeIfAbsent(name, k -> {
                ++this.highest;
                this.fromId.put(this.highest, k);
                return this.highest;
            });
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getName(int id) {
        try {
            this.lock.readLock().lock();
            String string = (String)this.fromId.getOrDefault(id, (Object)this.defaultLookup);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Int2ObjectMap<String> getNames() {
        try {
            this.lock.readLock().lock();
            Int2ObjectOpenHashMap int2ObjectOpenHashMap = new Int2ObjectOpenHashMap(this.fromId);
            return int2ObjectOpenHashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

