/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import sh.okx.civmodern.common.map.IdLookup;
import sh.okx.civmodern.common.map.MapFolder;
import sh.okx.civmodern.common.map.RegionAtlasTexture;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.data.RegionLoader;
import sh.okx.civmodern.common.map.data.RegionMapUpdater;
import sh.okx.civmodern.common.map.data.RegionReference;
import sh.okx.civmodern.common.map.data.RegionRenderer;

public class MapCache {
    private static final int ATLAS_LENGTH = 4096 / RegionMapUpdater.SIZE;
    private static final int ATLAS_BITS = Integer.numberOfTrailingZeros(4096 / RegionMapUpdater.SIZE);
    private final Set<RegionKey> gettingAtlas = new HashSet<RegionKey>();
    private final Map<RegionKey, RegionAtlasTexture> textureCache = new ConcurrentHashMap<RegionKey, RegionAtlasTexture>();
    private final Map<RegionKey, RegionReference> cache = new ConcurrentHashMap<RegionKey, RegionReference>();
    private final Map<RegionKey, RegionLoader> nearbyRegions = new ConcurrentHashMap<RegionKey, RegionLoader>();
    private final Queue<RegionKey> queue = new PriorityBlockingQueue<RegionKey>(11, (r1, r2) -> {
        int px = class_310.method_1551().field_1724.method_31477();
        int pz = class_310.method_1551().field_1724.method_31479();
        return Double.compare(class_3532.method_41189((double)(r1.x() * 512 + 256 - px), (double)(r1.z() * 512 + 256 - pz)), class_3532.method_41189((double)(r2.x() * 512 + 256 - px), (double)(r2.z() * 512 + 256 - pz)));
    });
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(Math.max(2, Runtime.getRuntime().availableProcessors()) - 1);
    private final MapFolder mapFile;
    private final Set<RegionKey> availableRegions;
    private final IdLookup blockLookup;
    private final IdLookup biomeLookup;

    public MapCache(MapFolder mapFile) {
        this.mapFile = mapFile;
        this.availableRegions = mapFile.listRegions();
        this.blockLookup = new IdLookup(mapFile.blockIds(), "minecraft:air");
        this.biomeLookup = new IdLookup(mapFile.biomeIds(), "minecraft:void");
        this.executor.scheduleAtFixedRate(this::cacheEvict, 2L, 2L, TimeUnit.MINUTES);
    }

    private void primeHeightmaps(class_2791 chunk) {
        if (chunk != null) {
            if (!chunk.method_39295(class_2902.class_2903.field_13202)) {
                class_2902.method_16684((class_2791)chunk, EnumSet.of(class_2902.class_2903.field_13202));
            }
            if (!chunk.method_39295(class_2902.class_2903.field_13195)) {
                class_2902.method_16684((class_2791)chunk, EnumSet.of(class_2902.class_2903.field_13195));
            }
        }
    }

    public RegionKey getRegionKey(int x, int z) {
        return new RegionKey(x >> 9, z >> 9);
    }

    public RegionReference addReference(RegionKey key) {
        return this.cache.compute(key, (k, v) -> {
            RegionLoader loader;
            if (v == null || (loader = v.getLoader()) == null) {
                return new RegionReference(new RegionLoader((RegionKey)k, this.mapFile), 1);
            }
            v.addReference(loader);
            return v;
        });
    }

    public void removeReference(RegionKey key) {
        this.cache.computeIfPresent(key, (k, v) -> {
            v.removeReference();
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getYLevel(int x, int z) {
        RegionKey key = this.getRegionKey(x, z);
        RegionReference ref = this.addReference(key);
        try {
            short[] ylevels = ref.getLoader().getOrLoadYLevels();
            if (ylevels == null) {
                Short s = null;
                return s;
            }
            short ylevel = ylevels[Math.floorMod(z, 512) + Math.floorMod(x, 512) * 512];
            if (ylevel > 0) {
                Short s = (short)(ylevel - 1);
                return s;
            }
            if (ylevel == 0) {
                Short s = null;
                return s;
            }
            Short s = ylevel;
            return s;
        }
        finally {
            ref.removeReference();
        }
    }

    public void updateChunk(class_2818 chunk) {
        class_1923 pos = chunk.method_12004();
        int regionX = pos.method_17885();
        int regionZ = pos.method_17886();
        RegionKey region = new RegionKey(regionX, regionZ);
        RegionKey atlas = new RegionKey(regionX >> ATLAS_BITS, regionZ >> ATLAS_BITS);
        RegionAtlasTexture tex = this.textureCache.computeIfAbsent(atlas, k -> {
            RegionAtlasTexture texture1 = new RegionAtlasTexture();
            texture1.init();
            return texture1;
        });
        class_2791 north = chunk.method_12200().method_8402(pos.field_9181, pos.field_9180 - 1, class_2806.field_12803, false);
        class_2791 west = chunk.method_12200().method_8402(pos.field_9181 - 1, pos.field_9180, class_2806.field_12803, false);
        this.primeHeightmaps((class_2791)chunk);
        this.primeHeightmaps(north);
        this.primeHeightmaps(west);
        boolean addedAtlas = this.gettingAtlas.add(atlas);
        this.executor.submit(() -> {
            RegionReference reference = this.addReference(region);
            try {
                RegionLoader loader = reference.getLoader();
                this.nearbyRegions.put(region, loader);
                RegionMapUpdater updater = new RegionMapUpdater(loader, this.blockLookup, this.biomeLookup);
                boolean updated = updater.updateChunk(chunk.method_12200().method_30349(), (class_2791)chunk, north, west);
                boolean shouldRender = loader.render();
                if (shouldRender) {
                    RegionRenderer renderer = new RegionRenderer(loader, this.blockLookup, this.biomeLookup);
                    renderer.render(tex, region.x() & ATLAS_LENGTH - 1, region.z() & ATLAS_LENGTH - 1);
                }
                if (updated) {
                    reference.markDirty();
                    if (!shouldRender) {
                        int regionLocalX = pos.method_17887();
                        int regionLocalZ = pos.method_17888();
                        RegionRenderer renderer = new RegionRenderer(loader, this.blockLookup, this.biomeLookup);
                        renderer.renderChunk(tex, region.x() & ATLAS_LENGTH - 1, region.z() & ATLAS_LENGTH - 1, regionLocalX, regionLocalZ);
                    }
                }
            }
            finally {
                reference.removeReference();
            }
            if (addedAtlas) {
                for (int x = 0; x < ATLAS_LENGTH; ++x) {
                    for (int z = 0; z < ATLAS_LENGTH; ++z) {
                        if (x == (regionX & ATLAS_LENGTH - 1) && z == (regionZ & ATLAS_LENGTH - 1)) continue;
                        this.enqueue(new RegionKey(atlas.x() << ATLAS_BITS | x, atlas.z() << ATLAS_BITS | z));
                    }
                }
            }
        });
    }

    private void cacheEvict() {
        Iterator<Map.Entry<RegionKey, RegionReference>> iterator = this.cache.entrySet().iterator();
        HashMap<RegionKey, RegionLoader> toSave = new HashMap<RegionKey, RegionLoader>();
        while (iterator.hasNext()) {
            Map.Entry<RegionKey, RegionReference> entry = iterator.next();
            int px = class_310.method_1551().field_1724.method_31477();
            int pz = class_310.method_1551().field_1724.method_31479();
            double dist = class_3532.method_41189((double)(entry.getKey().x() * 512 + 256 - px), (double)(entry.getKey().z() * 512 + 256 - pz));
            boolean far = dist > 2359296.0;
            RegionLoader loader = entry.getValue().getLoader();
            if (!entry.getValue().isReferenced()) {
                if (far) {
                    iterator.remove();
                }
                if (entry.getValue().clearDirty()) {
                    toSave.put(entry.getKey(), loader);
                }
            }
            if (loader != null && !far) continue;
            this.nearbyRegions.remove(entry.getKey());
        }
        if (toSave.isEmpty()) {
            return;
        }
        this.mapFile.saveBlockIds(this.blockLookup.getNames());
        this.mapFile.saveBiomeIds(this.biomeLookup.getNames());
        this.mapFile.saveBulk(toSave, this.executor);
    }

    public RegionAtlasTexture getTexture(RegionKey atlas) {
        RegionAtlasTexture texture = this.textureCache.get(atlas);
        if (texture == null) {
            if (this.gettingAtlas.add(atlas)) {
                for (int x = 0; x < ATLAS_LENGTH; ++x) {
                    for (int z = 0; z < ATLAS_LENGTH; ++z) {
                        RegionKey region = new RegionKey(atlas.x() << ATLAS_BITS | x, atlas.z() << ATLAS_BITS | z);
                        if (!this.availableRegions.contains(region)) continue;
                        this.textureCache.computeIfAbsent(atlas, k -> {
                            RegionAtlasTexture tex = new RegionAtlasTexture();
                            tex.init();
                            return tex;
                        });
                        this.enqueue(region);
                    }
                }
            }
            return null;
        }
        return texture;
    }

    private void enqueue(RegionKey region) {
        this.addReference(region);
        this.queue.add(region);
        this.executor.submit(() -> {
            RegionKey poll = this.queue.poll();
            if (poll == null) {
                return;
            }
            RegionReference reference = Objects.requireNonNull(this.cache.get(poll));
            try {
                RegionRenderer renderer = new RegionRenderer(reference.getLoader(), this.blockLookup, this.biomeLookup);
                renderer.render(this.textureCache.get(new RegionKey(poll.x() >> ATLAS_BITS, poll.z() >> ATLAS_BITS)), poll.x() & ATLAS_LENGTH - 1, poll.z() & ATLAS_LENGTH - 1);
            }
            finally {
                reference.removeReference();
            }
        });
    }

    public void save() {
        CountDownLatch latch = new CountDownLatch(1);
        this.executor.submit(() -> {
            try {
                HashMap<RegionKey, RegionLoader> toSave = new HashMap<RegionKey, RegionLoader>();
                for (Map.Entry<RegionKey, RegionReference> cacheEntry : this.cache.entrySet()) {
                    RegionReference loader = cacheEntry.getValue();
                    RegionLoader cached = loader.getLoader();
                    if (!loader.clearDirty()) continue;
                    toSave.put(cacheEntry.getKey(), cached);
                }
                this.mapFile.saveBlockIds(this.blockLookup.getNames());
                this.mapFile.saveBiomeIds(this.biomeLookup.getNames());
                this.mapFile.saveBulk(toSave, this.executor);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.executor.close();
    }

    public void free() {
        for (RegionAtlasTexture atlas : this.textureCache.values()) {
            atlas.delete();
        }
    }
}

