/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import com.google.gson.Gson;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.map.RegionDataType;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class MapFolder {
    private static final int VERSION = 0;
    private final File folder;
    private final Connection connection;
    private static final Gson GSON = new Gson();
    private final File historyFile;
    private final History history;

    public MapFolder(File folder) {
        this.folder = folder;
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(folder.toPath().resolve("map.sqlite").toAbsolutePath()));
            try (Statement statement = this.connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS meta (key TEXT NOT NULL PRIMARY KEY, value BLOB)");
                statement.execute("CREATE TABLE IF NOT EXISTS waypoints (name TEXT NOT NULL, x INT NOT NULL, y INT NOT NULL, z INT NOT NULL, icon TEXT NOT NULL, colour INT NOT NULL, UNIQUE (x, y, z))");
                statement.execute("CREATE TABLE IF NOT EXISTS blocks (name TEXT NOT NULL UNIQUE, id INTEGER NOT NULL UNIQUE)");
                statement.execute("CREATE TABLE IF NOT EXISTS biomes (name TEXT NOT NULL UNIQUE, id INTEGER NOT NULL UNIQUE)");
                statement.execute("CREATE TABLE IF NOT EXISTS regions (x INT NOT NULL, z INT NOT NULL, type TEXT NOT NULL, data BLOB NOT NULL, PRIMARY KEY (x, z, type))");
                statement.execute("INSERT INTO meta VALUES (\"version\", 0) ON CONFLICT DO NOTHING");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        this.historyFile = folder.toPath().resolve("history.json").toFile();
        this.history = this.readHistory(this.historyFile);
    }

    public History getHistory() {
        return this.history;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveHistory() {
        File file = this.historyFile;
        synchronized (file) {
            try (FileWriter writer = new FileWriter(this.historyFile);){
                GSON.toJson((Object)this.history, (Appendable)writer);
            }
            catch (IOException e) {
                AbstractCivModernMod.LOGGER.error((Object)e);
            }
        }
    }

    private History readHistory(File file) {
        History history;
        if (!file.exists()) {
            return MapFolder.defaultHistory();
        }
        FileReader reader = new FileReader(file);
        try {
            history = (History)GSON.fromJson((Reader)reader, History.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                AbstractCivModernMod.LOGGER.warn((Object)e);
                return MapFolder.defaultHistory();
            }
        }
        reader.close();
        return history;
    }

    private static History defaultHistory() {
        History config = new History();
        config.mods = new HashMap<String, ModData>();
        config.settings = new Settings();
        config.settings.enableImportPrompt = true;
        return config;
    }

    public File getFolder() {
        return this.folder;
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBulk(Map<RegionKey, RegionLoader> dataMap, ExecutorService parallel) {
        Connection connection = this.connection;
        synchronized (connection) {
            ConcurrentHashMap compressed = new ConcurrentHashMap();
            CountDownLatch latch = new CountDownLatch(dataMap.size());
            for (Map.Entry<RegionKey, RegionLoader> entry : dataMap.entrySet()) {
                compressed.put(entry.getKey(), new HashMap());
                parallel.submit(() -> {
                    try {
                        for (RegionDataType data : ((RegionLoader)entry.getValue()).getLoaded()) {
                            Map map = (Map)compressed.get(entry.getKey());
                            try {
                                ByteBuffer buf;
                                if (data == RegionDataType.MAP) {
                                    buf = ByteBuffer.allocate(0x100000);
                                    buf.asIntBuffer().put(((RegionLoader)entry.getValue()).getOrLoadMapData());
                                } else if (data == RegionDataType.Y_LEVELS) {
                                    buf = ByteBuffer.allocate(524288);
                                    buf.asShortBuffer().put(((RegionLoader)entry.getValue()).getOrLoadYLevels());
                                } else if (data == RegionDataType.CHUNK_TIMESTAMPS) {
                                    buf = ByteBuffer.allocate(8192);
                                    buf.asLongBuffer().put(((RegionLoader)entry.getValue()).getOrLoadChunkTimestamps());
                                } else {
                                    throw new IllegalArgumentException();
                                }
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                ZstdCompressorOutputStream zstd = new ZstdCompressorOutputStream((OutputStream)out);
                                zstd.write(buf.array());
                                zstd.close();
                                byte[] bytes = out.toByteArray();
                                map.put(data, bytes);
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO regions (x, z, type, data) VALUES (?, ?, ?, ?) ON CONFLICT DO UPDATE SET data = excluded.data");){
                for (Map.Entry<RegionKey, RegionLoader> entry : dataMap.entrySet()) {
                    for (RegionDataType data : entry.getValue().getLoaded()) {
                        statement.setInt(1, entry.getKey().x());
                        statement.setInt(2, entry.getKey().z());
                        statement.setString(3, data.getDatabaseKey());
                        byte[] bytes = (byte[])((Map)compressed.get(entry.getKey())).get((Object)data);
                        statement.setBytes(4, bytes);
                        statement.addBatch();
                    }
                }
                statement.executeBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public Set<RegionKey> listRegions() {
        Connection connection = this.connection;
        synchronized (connection) {
            HashSet<RegionKey> hashSet;
            block12: {
                Statement statement = this.connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("SELECT x, z FROM regions");
                    HashSet<RegionKey> keys = new HashSet<RegionKey>();
                    while (resultSet.next()) {
                        keys.add(new RegionKey(resultSet.getInt("x"), resultSet.getInt("z")));
                    }
                    hashSet = keys;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                statement.close();
            }
            return hashSet;
        }
    }

    public Int2ObjectMap<String> blockIds() {
        Connection connection = this.connection;
        synchronized (connection) {
            Int2ObjectOpenHashMap int2ObjectOpenHashMap;
            block12: {
                Statement statement = this.connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("SELECT name, id FROM blocks");
                    Int2ObjectOpenHashMap blockIds = new Int2ObjectOpenHashMap();
                    while (resultSet.next()) {
                        blockIds.put(resultSet.getInt("id"), (Object)resultSet.getString("name"));
                    }
                    int2ObjectOpenHashMap = blockIds;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                statement.close();
            }
            return int2ObjectOpenHashMap;
        }
    }

    public Int2ObjectMap<String> biomeIds() {
        Connection connection = this.connection;
        synchronized (connection) {
            Int2ObjectOpenHashMap int2ObjectOpenHashMap;
            block12: {
                Statement statement = this.connection.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("SELECT name, id FROM biomes");
                    Int2ObjectOpenHashMap biomeIds = new Int2ObjectOpenHashMap();
                    while (resultSet.next()) {
                        biomeIds.put(resultSet.getInt("id"), (Object)resultSet.getString("name"));
                    }
                    int2ObjectOpenHashMap = biomeIds;
                    if (statement == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                statement.close();
            }
            return int2ObjectOpenHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBlockIds(Int2ObjectMap<String> blockIds) {
        Connection connection = this.connection;
        synchronized (connection) {
            try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO blocks (name, id) VALUES (?, ?) ON CONFLICT DO NOTHING");){
                for (Int2ObjectMap.Entry entry : blockIds.int2ObjectEntrySet()) {
                    statement.setString(1, (String)entry.getValue());
                    statement.setInt(2, entry.getIntKey());
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBiomeIds(Int2ObjectMap<String> biomeIds) {
        Connection connection = this.connection;
        synchronized (connection) {
            try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO biomes (name, id) VALUES (?, ?) ON CONFLICT DO NOTHING");){
                for (Int2ObjectMap.Entry entry : biomeIds.int2ObjectEntrySet()) {
                    statement.setString(1, (String)entry.getValue());
                    statement.setInt(2, entry.getIntKey());
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getRegionData(RegionKey key, RegionDataType type) {
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT data FROM regions WHERE x = ? AND z = ? AND type = ?");){
            byte[] data;
            statement.setInt(1, key.x());
            statement.setInt(2, key.z());
            statement.setString(3, type.getDatabaseKey());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] compressed = resultSet.getBytes("data");
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            try (ZstdCompressorInputStream zstd = new ZstdCompressorInputStream((InputStream)in);){
                data = zstd.readAllBytes();
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static class History {
        public Map<String, ModData> mods;
        public Settings settings;
    }

    public static class Settings {
        public boolean enableImportPrompt;
    }

    public static class ModData {
        public List<String> regions;
    }
}

