/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map;

import com.mojang.blaze3d.systems.RenderSystem;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;
import sh.okx.civmodern.common.gui.Alignment;
import sh.okx.civmodern.common.map.MapCache;
import sh.okx.civmodern.common.map.RegionAtlasTexture;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoint;
import sh.okx.civmodern.common.map.waypoints.PlayerWaypoints;
import sh.okx.civmodern.common.map.waypoints.Waypoint;
import sh.okx.civmodern.common.map.waypoints.Waypoints;

public class Minimap {
    private final Waypoints waypoints;
    private final PlayerWaypoints playerWaypoints;
    private final MapCache cache;
    private final CivMapConfig config;
    private final ColourProvider provider;
    private float zoom = 4.0f;
    private static final RegionAtlasTexture blank = new RegionAtlasTexture();

    public Minimap(Waypoints waypoints, PlayerWaypoints playerWaypoints, MapCache cache, CivMapConfig config, ColourProvider provider) {
        this.waypoints = waypoints;
        this.playerWaypoints = playerWaypoints;
        this.cache = cache;
        this.config = config;
        this.provider = provider;
    }

    public void onRender(PostRenderGameOverlayEvent event) {
        int translateX;
        if (!this.config.isMinimapEnabled()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.method_53526().method_53536()) {
            return;
        }
        float size = this.config.getMinimapSize();
        class_4587 matrices = event.guiGraphics().method_51448();
        matrices.method_22903();
        int offsetX = this.config.getMinimapX();
        int offsetY = this.config.getMinimapY();
        int height = class_310.method_1551().method_22683().method_4502();
        int width = class_310.method_1551().method_22683().method_4486();
        matrices.method_46416((float)translateX, (float)(switch (this.config.getMinimapAlignment()) {
            case Alignment.TOP_LEFT -> {
                translateX = offsetX;
                yield offsetY;
            }
            case Alignment.TOP_RIGHT -> {
                translateX = width - offsetX - this.config.getMinimapSize();
                yield offsetY;
            }
            case Alignment.BOTTOM_RIGHT -> {
                translateX = width - offsetX - this.config.getMinimapSize();
                yield height - offsetY - this.config.getMinimapSize();
            }
            default -> {
                translateX = offsetX;
                yield height - offsetY - this.config.getMinimapSize();
            }
        }), 0.0f);
        class_746 player = class_310.method_1551().field_1724;
        float px = (float)class_3532.method_16436((double)event.deltaTick(), (double)player.field_6014, (double)player.method_23317());
        float pz = (float)class_3532.method_16436((double)event.deltaTick(), (double)player.field_5969, (double)player.method_23321());
        float x = px - size * this.zoom / 2.0f;
        float y = pz - size * this.zoom / 2.0f;
        float drawnX = 0.0f;
        float drawnY = 0.0f;
        for (float screenX = 0.0f; screenX < size * this.zoom + 4096.0f; screenX += 4096.0f) {
            float tmp = 0.0f;
            for (float screenY = 0.0f; screenY < size * this.zoom + 4096.0f; screenY += 4096.0f) {
                float realX = x + screenX;
                float realY = y + screenY;
                float renderX = realX - this.floatMod(realX, 4096.0f);
                float renderY = realY - this.floatMod(realY, 4096.0f);
                RegionKey key = new RegionKey(Math.floorDiv((int)renderX, 4096), Math.floorDiv((int)renderY, 4096));
                RegionAtlasTexture texture = this.cache.getTexture(key);
                float xOff = renderX - x + 4096.0f;
                float yOff = renderY - y + 4096.0f;
                texture = texture == null ? blank : texture;
                texture.drawLinear(matrices, drawnX, drawnY, this.zoom, screenX == 0.0f ? 4096.0f - xOff : 0.0f, screenY == 0.0f ? 4096.0f - yOff : 0.0f, 4096.0f, 4096.0f, Math.max(0.0f, size * this.zoom - drawnX), Math.max(0.0f, size * this.zoom - drawnY));
                drawnY += screenY == 0.0f ? yOff : 4096.0f;
                tmp += xOff;
            }
            drawnY = 0.0f;
            drawnX += screenX == 0.0f ? tmp / 2.0f : 4096.0f;
        }
        if (this.config.isPlayerWaypointsEnabled()) {
            for (PlayerWaypoint waypoint : this.playerWaypoints.getWaypoints()) {
                double wx = (double)waypoint.x() + 0.5;
                double wz = (double)waypoint.z() + 0.5;
                double tx = (wx - (double)x) / (double)this.zoom;
                double ty = (wz - (double)y) / (double)this.zoom;
                if (tx < 0.0 || ty < 0.0 || tx > (double)size || ty > (double)size) continue;
                matrices.method_22903();
                matrices.method_22904(tx, ty, 200.0);
                boolean old = waypoint.timestamp().until(Instant.now(), ChronoUnit.MINUTES) >= 10L;
                int colour = (old ? 119 : 255) << 24 | 0xFFFFFF;
                waypoint.render(event.guiGraphics(), colour);
                matrices.method_22909();
            }
        }
        List<Waypoint> waypointList = this.waypoints.getWaypoints();
        HashMap<String, List> waypointByIcon = new HashMap<String, List>();
        for (Waypoint waypoint : waypointList) {
            waypointByIcon.computeIfAbsent(waypoint.icon(), k -> new ArrayList()).add(waypoint);
        }
        matrices.method_22903();
        class_289 tesselator = class_289.method_1348();
        for (List waypointGroup : waypointByIcon.values()) {
            class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            boolean waypointRendered = false;
            for (Waypoint waypoint : waypointGroup) {
                double wx = (double)waypoint.x() + 0.5;
                double wz = (double)waypoint.z() + 0.5;
                double tx = (wx - (double)x) / (double)this.zoom;
                double ty = (wz - (double)y) / (double)this.zoom;
                if (tx < 0.0 || ty < 0.0 || tx > (double)size || ty > (double)size) continue;
                matrices.method_22903();
                matrices.method_22904(tx, ty, 0.0);
                waypoint.render((class_4588)buffer, matrices.method_23760().method_23761(), 7, -16777216);
                matrices.method_22909();
                waypointRendered = true;
            }
            if (!waypointRendered) continue;
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        matrices.method_22909();
        matrices.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        GL11.glEnable((int)2881);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1576);
        matrices.method_46416(size / 2.0f, size / 2.0f, 0.0f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(player.method_5705(event.deltaTick()) % 360.0f));
        matrices.method_22905(4.0f, 4.0f, 1.0f);
        int chevronColour = this.provider.getChevronColour() | 0xFF000000;
        Matrix4f pose = matrices.method_23760().method_23761();
        bufferBuilder.method_22918(pose, -1.0f, -0.75f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, -1.0f, -0.25f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, 0.0f, 0.25f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, 0.0f, 0.75f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, 0.0f, 0.25f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, 1.0f, -0.25f, 0.0f).method_39415(chevronColour);
        bufferBuilder.method_22918(pose, 1.0f, -0.75f, 0.0f).method_39415(chevronColour);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
        matrices.method_22909();
        matrices.method_22909();
    }

    private float floatMod(float x, float y) {
        return x - (float)Math.floor(x / y) * y;
    }

    public void cycleZoom() {
        this.zoom /= 2.0f;
        if (this.zoom < 0.5f) {
            this.zoom = 16.0f;
        }
    }

    static {
        RenderSystem.recordRenderCall(blank::init);
    }
}

