/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.converters;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.map.ColoursConfig;
import sh.okx.civmodern.common.map.IdLookup;
import sh.okx.civmodern.common.map.MapFolder;
import sh.okx.civmodern.common.map.RegionKey;
import sh.okx.civmodern.common.map.converters.Converter;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class VoxelMapConverter
implements Converter {
    private final MapFolder mapFile;
    private final String name;
    private final String dimension;
    private final class_5455 registryAccess;
    private final int v2DataLength = 0x120000;
    private final int v4DataLength = 0x160000;

    public VoxelMapConverter(MapFolder mapFile, String name, String dimension, class_5455 registryAccess) {
        this.mapFile = mapFile;
        this.name = name;
        this.dimension = dimension;
        this.registryAccess = registryAccess;
    }

    @Override
    public boolean hasAlreadyConverted() {
        return this.mapFile.getHistory().mods.containsKey("voxelmap");
    }

    @Override
    public boolean filesAvailable() {
        return class_310.method_1551().field_1697.toPath().resolve("voxelmap").resolve("cache").resolve(this.name).resolve(this.dimension).toFile().exists();
    }

    @Override
    public void convert() {
        File overworld = class_310.method_1551().field_1697.toPath().resolve("voxelmap").resolve("cache").resolve(this.name).resolve(this.dimension).toFile();
        File[] listed = overworld.listFiles();
        if (listed == null) {
            return;
        }
        File[] files = this.reorderFiles(listed);
        AbstractCivModernMod.LOGGER.info("Converting " + files.length + " VoxelMap regions to CivModern regions, this may take a few minutes...");
        int regionIndex = 0;
        boolean terminated = false;
        AtomicInteger saved = new AtomicInteger();
        ConcurrentHashMap<RegionKey, RegionLoader> regionMap = new ConcurrentHashMap<RegionKey, RegionLoader>();
        Set converted = Collections.newSetFromMap(new ConcurrentHashMap());
        AtomicBoolean modified = new AtomicBoolean(false);
        File voxelmap = this.mapFile.getFolder().toPath().resolve("voxelmap").toFile();
        try (FileInputStream fis2 = new FileInputStream(voxelmap);){
            converted.addAll(Arrays.asList(new String(fis2.readAllBytes()).split("\n")));
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        IdLookup blockLookup = new IdLookup(this.mapFile.blockIds(), "minecraft:air");
        IdLookup biomeLookup = new IdLookup(this.mapFile.biomeIds(), "minecraft:void");
        ExecutorService service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        while (regionIndex < files.length && !terminated) {
            int parallelRegions = Math.min(128, files.length - regionIndex);
            CountDownLatch latch = new CountDownLatch(parallelRegions);
            int regionStart = regionIndex;
            while (regionIndex < regionStart + parallelRegions) {
                File subRegionFile = files[regionIndex];
                if (subRegionFile.isFile()) {
                    if (Thread.interrupted()) {
                        terminated = true;
                        AbstractCivModernMod.LOGGER.info("Terminated VoxelMap conversion at region " + regionIndex + "/" + files.length);
                        break;
                    }
                    service.submit(() -> {
                        ZipFile zFile = null;
                        try {
                            InputStream is;
                            zFile = new ZipFile(subRegionFile);
                            int version = 1;
                            ZipEntry ze = zFile.getEntry("control");
                            if (ze != null && (is = zFile.getInputStream(ze)) != null) {
                                Properties properties = new Properties();
                                properties.load(is);
                                String versionString = properties.getProperty("version", "1");
                                try {
                                    version = Integer.parseInt(versionString);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                is.close();
                            }
                            if (version != 4 && version != 2) {
                                return;
                            }
                            ze = zFile.getEntry("key");
                            is = zFile.getInputStream(ze);
                            Scanner sc = new Scanner(is);
                            Int2ObjectOpenHashMap blockMap = new Int2ObjectOpenHashMap();
                            while (sc.hasNextLine()) {
                                this.parseLine(sc.nextLine(), (Int2ObjectMap<String>)blockMap);
                            }
                            sc.close();
                            is.close();
                            String subRegion = subRegionFile.getName().split("\\.")[0];
                            if (converted.contains(subRegion)) {
                                return;
                            }
                            String[] name = subRegion.split(",");
                            if (version == 2) {
                                ze = zFile.getEntry("data");
                                is = zFile.getInputStream(ze);
                                byte[] data = is.readAllBytes();
                                is.close();
                                if (data.length != 0x120000) {
                                    return;
                                }
                                Int2ObjectOpenHashMap biomeMap = new Int2ObjectOpenHashMap();
                                this.loadData(2, Integer.parseInt(name[0]), Integer.parseInt(name[1]), data, (Int2ObjectMap<String>)blockMap, (Int2ObjectMap<String>)biomeMap, regionMap, blockLookup, biomeLookup);
                                modified.set(true);
                            } else if (version == 4) {
                                ze = zFile.getEntry("data");
                                is = zFile.getInputStream(ze);
                                byte[] data = is.readAllBytes();
                                is.close();
                                if (data.length != 0x160000) {
                                    return;
                                }
                                ze = zFile.getEntry("biomes");
                                is = zFile.getInputStream(ze);
                                sc = new Scanner(is);
                                Int2ObjectOpenHashMap biomeMap = new Int2ObjectOpenHashMap();
                                while (sc.hasNextLine()) {
                                    this.parseLine(sc.nextLine(), (Int2ObjectMap<String>)biomeMap);
                                }
                                sc.close();
                                is.close();
                                this.loadData(4, Integer.parseInt(name[0]), Integer.parseInt(name[1]), data, (Int2ObjectMap<String>)blockMap, (Int2ObjectMap<String>)biomeMap, regionMap, blockLookup, biomeLookup);
                                modified.set(true);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        finally {
                            if (zFile != null) {
                                try {
                                    zFile.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            latch.countDown();
                        }
                    });
                }
                ++regionIndex;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.mapFile.saveBulk(regionMap, service);
            for (Map.Entry entry : regionMap.entrySet()) {
                converted.add(((RegionKey)entry.getKey()).x() + "," + ((RegionKey)entry.getKey()).z() + ".zip");
                int savedCount = saved.incrementAndGet();
                if (savedCount != files.length && savedCount % 128 != 0) continue;
                AbstractCivModernMod.LOGGER.info("Saved " + savedCount + " regions...");
            }
            AbstractCivModernMod.LOGGER.info("Processed " + regionIndex + "/" + files.length + " regions...");
            regionMap.clear();
        }
        this.mapFile.saveBlockIds(blockLookup.getNames());
        this.mapFile.saveBiomeIds(biomeLookup.getNames());
        if (modified.get()) {
            MapFolder.ModData modData = new MapFolder.ModData();
            modData.regions = new ArrayList(converted);
            this.mapFile.getHistory().mods.put("voxelmap", modData);
            this.mapFile.saveHistory();
        }
        AbstractCivModernMod.LOGGER.info("Conversion complete for " + this.name + "/" + this.dimension);
    }

    @Override
    public RegionKey getRegionKey(String fileName) {
        String name = fileName.split("\\.")[0];
        String[] parts = name.split(",");
        if (parts.length != 2) {
            return null;
        }
        return new RegionKey(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
    }

    private void loadData(int version, int subRegionX, int subRegionZ, byte[] data, Int2ObjectMap<String> blockIdToName, Int2ObjectMap<String> biomeIdToName, Map<RegionKey, RegionLoader> regionMap, IdLookup blockLookup, IdLookup biomeLookup) {
        VersionedDataHelper helper;
        if (version == 4) {
            helper = new v4DataHelper(blockIdToName, biomeIdToName, regionMap, blockLookup, biomeLookup);
        } else if (version == 2) {
            helper = new v2DataHelper(blockIdToName, biomeIdToName, regionMap, blockLookup, biomeLookup);
        } else {
            throw new IllegalArgumentException("Unknown VoxelMap data version " + version);
        }
        int[] region = new int[65536];
        short[] ylevels = new short[65536];
        int[] westY = new int[256];
        Arrays.fill(westY, Integer.MIN_VALUE);
        int northY = Integer.MIN_VALUE;
        for (int x = 0; x < 256; ++x) {
            for (int z = 0; z < 256; ++z) {
                int actualY;
                int blockId;
                String blockName;
                int y = helper.getHeight(data, x, z);
                int realBlockId = helper.getBlockstate(data, x, z);
                int fy = helper.getFoliageHeight(data, x, z);
                if (fy > y) {
                    y = fy - 1;
                    int foliageBlockstate = helper.getFoliageBlockstate(data, x, z);
                    if (!ColoursConfig.BLOCKS_GRASS.contains(blockIdToName.get(foliageBlockstate))) {
                        realBlockId = foliageBlockstate;
                    }
                }
                int dataValue = 0;
                int floorBlockstate = helper.getOceanFloorBlockstate(data, x, z);
                int height = helper.getOceanFloorheight(data, x, z);
                if (!"minecraft:air".equals(blockIdToName.get(floorBlockstate))) {
                    realBlockId = floorBlockstate;
                    int tmp = y;
                    y = height;
                    height = tmp;
                }
                if ((blockName = (String)blockIdToName.get(realBlockId)) == null) {
                    blockName = "minecraft:air";
                }
                if ((blockId = blockLookup.getOrCreateId(blockName) + 1) > 65535) {
                    AbstractCivModernMod.LOGGER.warn("convert block " + blockId + " at pos (" + x + ", " + z + ") in (" + subRegionX + ", " + subRegionZ + ")");
                    blockId = 0;
                }
                dataValue |= blockId << 16;
                if (!"minecraft:air".equals(blockIdToName.get(floorBlockstate))) {
                    int depth = height - y;
                    dataValue |= class_3532.method_15340((int)depth, (int)0, (int)15) << 12;
                    actualY = height;
                } else {
                    actualY = y;
                }
                String biomeName = helper.getBiomeID(data, x, z);
                int biomeId = biomeLookup.getOrCreateId(biomeName);
                if (biomeId > 255) {
                    AbstractCivModernMod.LOGGER.warn("biome " + biomeId + " at pos (" + x + ", " + z + ") in (" + subRegionX + ", " + subRegionZ + ")");
                    biomeId = 0;
                }
                dataValue |= biomeId;
                if (westY[z] != Integer.MIN_VALUE) {
                    if (westY[z] > y) {
                        dataValue |= 0xC00;
                    } else if (westY[z] == y) {
                        dataValue |= 0x400;
                    }
                } else {
                    dataValue |= 0x800;
                }
                westY[z] = y;
                if (northY != Integer.MIN_VALUE) {
                    if (northY > y) {
                        dataValue |= 0x300;
                    } else if (northY == y) {
                        dataValue |= 0x100;
                    }
                } else {
                    dataValue |= 0x200;
                }
                northY = y;
                region[z + x * 256] = dataValue;
                ylevels[z + x * 256] = (short)actualY;
            }
            northY = Integer.MIN_VALUE;
        }
        int regionX = Math.floorDiv(subRegionX, 2);
        int regionZ = Math.floorDiv(subRegionZ, 2);
        int offsetX = Math.floorMod(subRegionX, 2);
        int offsetZ = Math.floorMod(subRegionZ, 2);
        RegionKey key = new RegionKey(regionX, regionZ);
        RegionLoader regionData = regionMap.computeIfAbsent(key, k -> new RegionLoader((RegionKey)k, this.mapFile));
        int[] saved = regionData.getOrLoadMapData();
        short[] savedY = regionData.getOrLoadYLevels();
        for (int x = offsetX * 256; x < offsetX * 256 + 256; ++x) {
            for (int z = offsetZ * 256; z < offsetZ * 256 + 256; ++z) {
                saved[z + x * 512] = region[z - offsetZ * 256 + (x - offsetX * 256) * 256];
                savedY[z + x * 512] = ylevels[z - offsetZ * 256 + (x - offsetX * 256) * 256];
            }
        }
    }

    private byte getData(byte[] data, int x, int z, int bit) {
        int index = x + z * 256 + 65536 * bit;
        return data[index];
    }

    private File[] reorderFiles(File[] files) {
        File[] newFiles = new File[files.length];
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            newFiles[count++] = files[i];
            RegionKey iRegion = this.getRegionKey(files[i].getName());
            if (iRegion == null) continue;
            for (int j = i + 1; j < files.length; ++j) {
                RegionKey jRegion;
                if (files[j] == null || (jRegion = this.getRegionKey(files[j].getName())) == null || (iRegion.x() & 0xFFFFFFFE) != (jRegion.x() & 0xFFFFFFFE) || (iRegion.z() & 0xFFFFFFFE) != (jRegion.z() & 0xFFFFFFFE)) continue;
                newFiles[count++] = files[j];
                files[j] = null;
            }
        }
        return newFiles;
    }

    private void parseLine(String line, Int2ObjectMap<String> map) {
        String[] lineParts = line.split(" ");
        int id = Integer.parseInt(lineParts[0]);
        String blockName = this.parseStateString(lineParts[1]);
        map.put(id, (Object)blockName);
    }

    private String parseStateString(String stateString) {
        int bracketIndex = stateString.indexOf("[");
        String resourceString = stateString.substring(0, bracketIndex == -1 ? stateString.length() : bracketIndex);
        int curlyBracketOpenIndex = resourceString.indexOf("{");
        int curlyBracketCloseIndex = resourceString.indexOf("}");
        resourceString = resourceString.substring(curlyBracketOpenIndex == -1 ? 0 : curlyBracketOpenIndex + 1, curlyBracketCloseIndex == -1 ? resourceString.length() : curlyBracketCloseIndex);
        return resourceString;
    }

    class v4DataHelper
    extends VersionedDataHelper {
        v4DataHelper(Int2ObjectMap<String> blockIdToName, Int2ObjectMap<String> biomeIdToName, Map<RegionKey, RegionLoader> regionMap, IdLookup blockLookup, IdLookup biomeLookup) {
            super(VoxelMapConverter.this, blockIdToName, biomeIdToName, regionMap, blockLookup, biomeLookup);
        }

        @Override
        public int getHeight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 0) << 8 | VoxelMapConverter.this.getData(data, x, z, 1) & 0xFF;
        }

        @Override
        public int getFoliageHeight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 15) << 8 | VoxelMapConverter.this.getData(data, x, z, 16) & 0xFF;
        }

        @Override
        public int getFoliageBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 17) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 18) & 0xFF;
        }

        @Override
        public int getTransparentHeight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 10) << 8 | VoxelMapConverter.this.getData(data, x, z, 11) & 0xFF;
        }

        @Override
        public int getTransparentBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 12) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 13) & 0xFF;
        }

        @Override
        public int getBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 2) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 3) & 0xFF;
        }

        @Override
        public int getOceanFloorBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 7) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 8) & 0xFF;
        }

        @Override
        public int getOceanFloorheight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 5) << 8 | VoxelMapConverter.this.getData(data, x, z, 6) & 0xFF;
        }

        @Override
        public String getBiomeID(byte[] data, int x, int z) {
            int rawId = (VoxelMapConverter.this.getData(data, x, z, 20) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 21) & 0xFF;
            String biomeName = (String)this.biomeIdToName.get(rawId);
            if (biomeName == null) {
                return "minecraft:void";
            }
            return biomeName;
        }
    }

    class v2DataHelper
    extends VersionedDataHelper {
        v2DataHelper(Int2ObjectMap<String> blockIdToName, Int2ObjectMap<String> biomeIdToName, Map<RegionKey, RegionLoader> regionMap, IdLookup blockLookup, IdLookup biomeLookup) {
            super(VoxelMapConverter.this, blockIdToName, biomeIdToName, regionMap, blockLookup, biomeLookup);
        }

        @Override
        public int getHeight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 0) & 0xFF;
        }

        @Override
        public int getFoliageHeight(byte[] data, int x, int z) {
            return this.getTransparentHeight(data, x, z);
        }

        @Override
        public int getFoliageBlockstate(byte[] data, int x, int z) {
            return this.getTransparentBlockstate(data, x, z);
        }

        @Override
        public int getTransparentHeight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 8) & 0xFF;
        }

        @Override
        public int getTransparentBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 9) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 10) & 0xFF;
        }

        @Override
        public int getBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 1) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 2) & 0xFF;
        }

        @Override
        public int getOceanFloorBlockstate(byte[] data, int x, int z) {
            return (VoxelMapConverter.this.getData(data, x, z, 5) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 6) & 0xFF;
        }

        @Override
        public int getOceanFloorheight(byte[] data, int x, int z) {
            return VoxelMapConverter.this.getData(data, x, z, 4) & 0xFF;
        }

        @Override
        public String getBiomeID(byte[] data, int x, int z) {
            int rawId = (VoxelMapConverter.this.getData(data, x, z, 16) & 0xFF) << 8 | VoxelMapConverter.this.getData(data, x, z, 17) & 0xFF;
            String biomeName = this.mapLegacyBiomeIds(rawId);
            if (biomeName == null) {
                return "minecraft:void";
            }
            return biomeName;
        }

        private String mapLegacyBiomeIds(int id) {
            return switch (id) {
                case 0 -> "minecraft:badlands";
                case 1 -> "minecraft:bamboo_jungle";
                case 2 -> "minecraft:basalt_deltas";
                case 3 -> "minecraft:beach";
                case 4 -> "minecraft:birch_forest";
                case 5 -> "minecraft:cherry_grove";
                case 6 -> "minecraft:cold_ocean";
                case 7 -> "minecraft:crimson_forest";
                case 8 -> "minecraft:dark_forest";
                case 9 -> "minecraft:deep_cold_ocean";
                case 10 -> "minecraft:deep_dark";
                case 11 -> "minecraft:deep_frozen_ocean";
                case 12 -> "minecraft:deep_lukewarm_ocean";
                case 13 -> "minecraft:deep_ocean";
                case 14 -> "minecraft:desert";
                case 15 -> "minecraft:dripstone_caves";
                case 16 -> "minecraft:end_barrens";
                case 17 -> "minecraft:end_highlands";
                case 18 -> "minecraft:end_midlands";
                case 19 -> "minecraft:eroded_badlands";
                case 20 -> "minecraft:flower_forest";
                case 21 -> "minecraft:forest";
                case 22 -> "minecraft:frozen_ocean";
                case 23 -> "minecraft:frozen_peaks";
                case 24 -> "minecraft:frozen_river";
                case 25 -> "minecraft:grove";
                case 26 -> "minecraft:ice_spikes";
                case 27 -> "minecraft:jagged_peaks";
                case 28 -> "minecraft:jungle";
                case 29 -> "minecraft:lukewarm_ocean";
                case 30 -> "minecraft:lush_caves";
                case 31 -> "minecraft:mangrove_swamp";
                case 32 -> "minecraft:meadow";
                case 33 -> "minecraft:mushroom_fields";
                case 34 -> "minecraft:nether_wastes";
                case 35 -> "minecraft:ocean";
                case 36 -> "minecraft:old_growth_birch_forest";
                case 37 -> "minecraft:old_growth_pine_taiga";
                case 38 -> "minecraft:old_growth_spruce_taiga";
                case 39 -> "minecraft:plains";
                case 40 -> "minecraft:river";
                case 41 -> "minecraft:savanna";
                case 42 -> "minecraft:savanna_plateau";
                case 43 -> "minecraft:small_end_islands";
                case 44 -> "minecraft:snowy_beach";
                case 45 -> "minecraft:snowy_plains";
                case 46 -> "minecraft:snowy_slopes";
                case 47 -> "minecraft:snowy_taiga";
                case 48 -> "minecraft:soul_sand_valley";
                case 49 -> "minecraft:sparse_jungle";
                case 50 -> "minecraft:stony_peaks";
                case 51 -> "minecraft:stony_shore";
                case 52 -> "minecraft:sunflower_plains";
                case 53 -> "minecraft:swamp";
                case 54 -> "minecraft:taiga";
                case 55 -> "minecraft:the_end";
                case 56 -> "minecraft:the_void";
                case 57 -> "minecraft:warm_ocean";
                case 58 -> "minecraft:warped_forest";
                case 59 -> "minecraft:windswept_forest";
                case 60 -> "minecraft:windswept_gravelly_hills";
                case 61 -> "minecraft:windswept_hills";
                case 62 -> "minecraft:windswept_savanna";
                case 63 -> "minecraft:wooded_badlands";
                default -> null;
            };
        }
    }

    abstract class VersionedDataHelper {
        protected final Int2ObjectMap<String> blockIdToName;
        protected final Int2ObjectMap<String> biomeIdToName;
        protected final Map<RegionKey, RegionLoader> regionMap;
        protected final IdLookup blockLookup;
        protected final IdLookup biomeLookup;

        VersionedDataHelper(VoxelMapConverter this$0, Int2ObjectMap<String> blockIdToName, Int2ObjectMap<String> biomeIdToName, Map<RegionKey, RegionLoader> regionMap, IdLookup blockLookup, IdLookup biomeLookup) {
            this.blockIdToName = blockIdToName;
            this.biomeIdToName = biomeIdToName;
            this.regionMap = regionMap;
            this.blockLookup = blockLookup;
            this.biomeLookup = biomeLookup;
        }

        abstract int getHeight(byte[] var1, int var2, int var3);

        abstract int getFoliageHeight(byte[] var1, int var2, int var3);

        abstract int getFoliageBlockstate(byte[] var1, int var2, int var3);

        abstract int getTransparentHeight(byte[] var1, int var2, int var3);

        abstract int getTransparentBlockstate(byte[] var1, int var2, int var3);

        abstract int getBlockstate(byte[] var1, int var2, int var3);

        abstract int getOceanFloorBlockstate(byte[] var1, int var2, int var3);

        abstract int getOceanFloorheight(byte[] var1, int var2, int var3);

        abstract String getBiomeID(byte[] var1, int var2, int var3);
    }
}

