/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.map.data;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import sh.okx.civmodern.common.map.ColoursConfig;
import sh.okx.civmodern.common.map.IdLookup;
import sh.okx.civmodern.common.map.RegionAtlasTexture;
import sh.okx.civmodern.common.map.data.RegionLoader;

public class RegionRenderer {
    private final RegionLoader loader;
    private final IdLookup blockLookup;
    private final IdLookup biomeLookup;

    public RegionRenderer(RegionLoader loader, IdLookup blockLookup, IdLookup biomeLookup) {
        this.loader = loader;
        this.blockLookup = blockLookup;
        this.biomeLookup = biomeLookup;
    }

    public void renderChunk(RegionAtlasTexture texture, int rx, int rz, int chunkX, int chunkZ) {
        this.render(texture, rx, rz, chunkX * 16, chunkX * 16 + 16, chunkZ * 16, chunkZ * 16 + 16);
    }

    public void render(RegionAtlasTexture texture, int rx, int rz) {
        this.render(texture, rx, rz, 0, 512, 0, 512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void render(RegionAtlasTexture texture, int rx, int rz, int minX, int maxX, int minZ, int maxZ) {
        try {
            this.loader.getRenderLock().lock();
            int[] data = this.loader.getOrLoadMapData();
            short[] colours = new short[(maxX - minX) * (maxZ - minZ)];
            Int2IntOpenHashMap blockCache = new Int2IntOpenHashMap();
            Int2IntOpenHashMap biomeCache = new Int2IntOpenHashMap();
            class_5455 registryAccess = class_310.method_1551().field_1724.method_37908().method_30349();
            class_2378 registry = registryAccess.method_30530(class_7924.field_41236);
            for (int x = minX; x < maxX; ++x) {
                for (int z = minZ; z < maxZ; ++z) {
                    int bt;
                    int color;
                    int packedData = data[z + x * 512];
                    int blockId = packedData >>> 16 & 0xFFFF;
                    int waterDepth = packedData >>> 12 & 0xF;
                    int biomeId = packedData & 0xFF;
                    int blockBiomeId = blockId << 8 | biomeId;
                    int cachedColor = blockCache.getOrDefault(blockBiomeId, -1);
                    if (cachedColor == -1) {
                        if (blockId == 0) {
                            color = 0;
                        } else {
                            Optional holder = registryAccess.method_30530(class_7924.field_41254).method_10223(class_2960.method_60654((String)this.blockLookup.getName(blockId - 1)));
                            if (holder.isEmpty()) {
                                color = 0;
                            } else {
                                class_6880.class_6883 blockHolder = (class_6880.class_6883)holder.get();
                                String key = blockHolder.method_40237().method_29177().toString();
                                color = ColoursConfig.BLOCK_COLOURS.getOrDefault(key, ((class_2248)blockHolder.comp_349()).method_26403().field_16011);
                                if (ColoursConfig.BLOCKS_GRASS.contains(key)) {
                                    class_1959 biome = (class_1959)registry.method_63535(class_2960.method_60654((String)this.biomeLookup.getName(biomeId)));
                                    color = RegionRenderer.mix(biome.method_8711(0.0, 0.0), color);
                                } else if (ColoursConfig.BLOCKS_FOLIAGE.contains(key)) {
                                    class_1959 biome = (class_1959)registry.method_63535(class_2960.method_60654((String)this.biomeLookup.getName(biomeId)));
                                    color = RegionRenderer.mix(biome.method_8698(), color);
                                }
                                blockCache.put(blockBiomeId, color);
                            }
                        }
                    } else {
                        color = blockCache.get(blockBiomeId);
                    }
                    if (waterDepth > 0) {
                        int fluidColor;
                        if (biomeCache.containsKey(biomeId)) {
                            fluidColor = biomeCache.get(biomeId);
                        } else {
                            class_1959 biome = (class_1959)registry.method_63535(class_2960.method_60654((String)this.biomeLookup.getName(biomeId)));
                            fluidColor = RegionRenderer.fancyFluids(biome, 0.05f);
                            biomeCache.put(biomeId, fluidColor);
                        }
                        color = RegionRenderer.blend(fluidColor, color | 0xFF000000) & 0xFFFFFF;
                    }
                    int alpha = (bt = Integer.bitCount(packedData >>> 8 & 0xF)) == 0 || bt == 1 ? 0 : (bt == 2 ? (waterDepth > 0 ? 17 : 34) : (waterDepth > 0 ? 34 : 68));
                    color = RegionRenderer.blend(color, (double)alpha / 255.0);
                    int red = color >> 16 & 0xFF;
                    int green = color >> 8 & 0xFF;
                    int blue = color & 0xFF;
                    int rgb565 = 0;
                    rgb565 = (short)(rgb565 | red / 8 << 11);
                    rgb565 = (short)(rgb565 | green / 4 << 5);
                    colours[x - minX + (z - minZ) * (maxZ - minZ)] = rgb565 = (int)((short)(rgb565 | blue / 8));
                }
            }
            if (RenderSystem.isOnRenderThread()) {
                texture.update(colours, rx, rz, minX, maxX, minZ, maxZ);
            } else {
                RenderSystem.recordRenderCall(() -> texture.update(colours, rx, rz, minX, maxX, minZ, maxZ));
            }
        }
        finally {
            this.loader.getRenderLock().unlock();
        }
    }

    public static int blend(int color1, double a0) {
        double r = (double)RegionRenderer.red(color1) * (1.0 - a0);
        double g = (double)RegionRenderer.green(color1) * (1.0 - a0);
        double b = (double)RegionRenderer.blue(color1) * (1.0 - a0);
        return RegionRenderer.rgb((int)r, (int)g, (int)b);
    }

    public static int fancyFluids(class_1959 biome, float depth) {
        int color = biome.method_8687();
        color = RegionRenderer.lerpARGB(color, -16777216, class_3532.method_15363((float)RegionRenderer.cubicOut(depth / 1.5f), (float)0.0f, (float)0.45f));
        color = RegionRenderer.setAlpha((int)(RegionRenderer.quinticOut(class_3532.method_15363((float)(depth * 5.0f), (float)0.0f, (float)1.0f)) * 255.0f), color);
        return color;
    }

    public static int setAlpha(int alpha, int argb) {
        return alpha << 24 | argb & 0xFFFFFF;
    }

    public static int lerpARGB(int color0, int color1, float delta) {
        if (color0 == color1) {
            return color0;
        }
        if (delta >= 1.0f) {
            return color1;
        }
        if (delta <= 0.0f) {
            return color0;
        }
        return RegionRenderer.argb((int)class_3532.method_16439((float)delta, (float)RegionRenderer.alpha(color0), (float)RegionRenderer.alpha(color1)), (int)class_3532.method_16439((float)delta, (float)RegionRenderer.red(color0), (float)RegionRenderer.red(color1)), (int)class_3532.method_16439((float)delta, (float)RegionRenderer.green(color0), (float)RegionRenderer.green(color1)), (int)class_3532.method_16439((float)delta, (float)RegionRenderer.blue(color0), (float)RegionRenderer.blue(color1)));
    }

    public static int blend(int color0, int color1) {
        double a0 = (double)RegionRenderer.alpha(color0) / 255.0;
        double a1 = (double)RegionRenderer.alpha(color1) / 255.0;
        double a = a0 + a1 * (1.0 - a0);
        double r = ((double)RegionRenderer.red(color0) * a0 + (double)RegionRenderer.red(color1) * a1 * (1.0 - a0)) / a;
        double g = ((double)RegionRenderer.green(color0) * a0 + (double)RegionRenderer.green(color1) * a1 * (1.0 - a0)) / a;
        double b = ((double)RegionRenderer.blue(color0) * a0 + (double)RegionRenderer.blue(color1) * a1 * (1.0 - a0)) / a;
        return RegionRenderer.argb((int)a * 255, (int)r, (int)g, (int)b);
    }

    public static float quinticOut(float t) {
        return 1.0f + (t -= 1.0f) * t * t * t * t;
    }

    public static float cubicOut(float t) {
        return 1.0f + (t -= 1.0f) * t * t;
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int alpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }

    public static int rgb(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static int mix(int color0, int color1) {
        float r = (float)RegionRenderer.red(color0) / 255.0f * (float)RegionRenderer.red(color1) / 255.0f;
        float g = (float)RegionRenderer.green(color0) / 255.0f * (float)RegionRenderer.green(color1) / 255.0f;
        float b = (float)RegionRenderer.blue(color0) / 255.0f * (float)RegionRenderer.blue(color1) / 255.0f;
        return RegionRenderer.rgb((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }
}

