/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui;

import java.text.DecimalFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import sh.okx.civmodern.common.gui.DoubleValue;

public class ColorValue
implements DoubleValue {
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("##%");
    private final String name;
    private final int bits;
    private final Supplier<Integer> supplier;
    private final Consumer<Integer> consumer;

    public ColorValue(String name, int bits, Supplier<Integer> supplier, Consumer<Integer> consumer) {
        this.name = name;
        this.bits = bits;
        this.supplier = supplier;
        this.consumer = consumer;
    }

    @Override
    public double get() {
        return (double)(this.supplier.get() >> this.bits & 0xFF) / 255.0;
    }

    @Override
    public void set(double value) {
        int set = (1 << this.bits + 8) - (1 << this.bits);
        this.consumer.accept(this.supplier.get() & ~set | (int)(value * 255.0) << this.bits);
    }

    @Override
    public Component getText(double value) {
        return Component.m_237110_((String)this.name, (Object[])new Object[]{PERCENT_FORMAT.format(value)});
    }
}

