/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.screen;

import java.text.DecimalFormat;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import sh.okx.civmodern.common.AbstractCivModernMod;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.gui.widget.HsbColourPicker;
import sh.okx.civmodern.common.gui.widget.ImageButton;

public class CompactedConfigScreen
extends Screen {
    private static final DecimalFormat FORMAT = new DecimalFormat("##%");
    private static final ItemStack ITEM;
    private int itemX;
    private int itemY;
    private final AbstractCivModernMod mod;
    private final CivMapConfig config;
    private final Screen parent;
    private HsbColourPicker picker;

    public CompactedConfigScreen(AbstractCivModernMod mod, CivMapConfig config, Screen parent) {
        super((Component)Component.m_237115_((String)"civmodern.screen.compacted.title"));
        this.mod = mod;
        this.config = config;
        this.parent = parent;
    }

    protected void m_7856_() {
        this.itemX = this.f_96543_ / 2 - 8;
        this.itemY = this.f_96544_ / 6 - 24;
        int leftWidth = this.f_96543_ / 2 - 58;
        EditBox widget = new EditBox(this.f_96547_, leftWidth, this.f_96544_ / 6, 60, 20, (Component)Component.m_237119_());
        widget.m_94144_("#" + String.format("%06X", this.config.getColour()));
        widget.m_94199_(7);
        Pattern pattern = Pattern.compile("^(#[0-9A-F]{0,6})?$", 2);
        widget.m_94153_(string -> pattern.matcher((CharSequence)string).matches());
        widget.m_94151_(val -> {
            if (val.length() == 7) {
                int rgb = Integer.parseInt(val.substring(1), 16);
                this.config.setColour(rgb);
            }
        });
        this.m_142416_((GuiEventListener)widget);
        ColourProvider colourProvider = this.mod.getColourProvider();
        HsbColourPicker hsb = new HsbColourPicker(leftWidth + 60 + 8, this.f_96544_ / 6, 20, 20, this.config.getColour(), colour -> {
            widget.m_94144_("#" + String.format("%06X", colour));
            this.config.setColour((int)colour);
        }, colourProvider::setTemporaryCompactedColour, () -> {});
        this.m_142416_((GuiEventListener)new ImageButton(leftWidth + 60 + 8 + 20 + 8, this.f_96544_ / 6, 20, 20, new ResourceLocation("civmodern", "gui/rollback.png"), imbg -> {
            int colour = 0xFFFF58;
            widget.m_94144_("#FFFF58");
            this.config.setColour(colour);
            hsb.close();
        }));
        this.picker = hsb;
        this.m_142416_((GuiEventListener)this.picker);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            this.config.save();
            this.f_96541_.m_91152_(this.parent);
        }).m_252794_(this.f_96543_ / 2 - 49, this.f_96544_ / 6 + 169).m_253046_(98, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawCentredText(guiGraphics, this.f_96539_, 0, 15, 0xFFFFFF);
        this.drawItem(guiGraphics);
        if (this.isCursorOverItem(mouseX, mouseY)) {
            guiGraphics.m_280153_(this.f_96547_, ITEM, mouseX, mouseY);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && this.isCursorOverItem((int)mouseX, (int)mouseY) && button == 0 && player.m_7500_()) {
            player.m_36356_(ITEM.m_41777_());
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double d, double e) {
        super.m_94757_(d, e);
        if (this.picker != null) {
            this.picker.m_94757_(d, e);
        }
    }

    public void m_7379_() {
        super.m_7379_();
        this.mod.getColourProvider().setTemporaryCompactedColour(null);
        this.config.save();
    }

    private boolean isCursorOverItem(int mouseX, int mouseY) {
        return mouseX >= this.itemX - 1 && mouseX < this.itemX + 17 && mouseY > this.itemY - 1 && mouseY < this.itemY + 17;
    }

    private void drawItem(GuiGraphics guiGraphics) {
        guiGraphics.m_280480_(ITEM, this.itemX, this.itemY);
        guiGraphics.m_280370_(this.f_96547_, ITEM, this.itemX, this.itemY);
    }

    private void drawCentredText(GuiGraphics guiGraphics, Component text, int xOffsetCentre, int yOffsetTop, int colour) {
        int width = Minecraft.m_91087_().m_91268_().m_85445_();
        int centre = width / 2 - this.f_96547_.m_92852_((FormattedText)text) / 2;
        guiGraphics.m_280430_(this.f_96547_, text, centre + xOffsetCentre, yOffsetTop, colour);
    }

    static {
        CompoundTag item = new CompoundTag();
        item.m_128359_("id", "stone");
        item.m_128405_("Count", 64);
        CompoundTag tag = new CompoundTag();
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)"\"Compacted Item\""));
        CompoundTag display = new CompoundTag();
        display.m_128365_("Lore", (Tag)lore);
        tag.m_128365_("display", (Tag)display);
        item.m_128365_("tag", (Tag)tag);
        ITEM = ItemStack.m_41712_((CompoundTag)item);
    }
}

