/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import sh.okx.civmodern.common.gui.Texture;
import sh.okx.civmodern.common.gui.screen.ScreenCloseable;
import sh.okx.civmodern.common.gui.widget.HUSLColorConverter;

public class HsbColourPicker
extends AbstractWidget {
    private static final ResourceLocation COLOUR_PICKER_ICON = new ResourceLocation("civmodern", "gui/colour.png");
    private final Texture hueSelector;
    private final Texture saturationBrightnessTexture;
    private final Consumer<Integer> colourConsumer;
    private final Consumer<Integer> previewConsumer;
    private int hue = 0;
    private boolean mouseOverGrid = false;
    private boolean showPalette = false;
    private boolean updateTexture = true;
    private boolean hueMouseDown = false;
    private final ScreenCloseable closeable;
    private int renderY;

    public HsbColourPicker(int x, int y, int width, int height, int colour, Consumer<Integer> colourConsumer, Consumer<Integer> previewConsumer, ScreenCloseable closeable) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"HSB Colour Picker"));
        this.hue = this.getHue(colour);
        this.closeable = closeable;
        this.hueSelector = this.getHueSelector();
        this.saturationBrightnessTexture = new Texture(128, 128);
        this.colourConsumer = colourConsumer;
        this.previewConsumer = previewConsumer;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderY = this.m_252754_() + 101 > Minecraft.m_91087_().m_91268_().m_85446_() ? this.m_252907_() - 101 - this.f_93619_ : this.m_252907_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COLOUR_PICKER_ICON);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280398_(COLOUR_PICKER_ICON, this.m_252754_(), this.m_252907_(), 10, 0.0f, this.m_198029_() ? 20.0f : 0.0f, this.f_93618_, this.f_93619_, 20, 40);
        if (this.showPalette) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (this.updateTexture) {
                this.updateTexture(this.saturationBrightnessTexture, this.hue);
                this.updateTexture = false;
            }
            this.saturationBrightnessTexture.bind();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
            RenderSystem.setShader(GameRenderer::m_172817_);
            Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f, (float)this.m_252754_(), (float)(this.renderY + this.f_93619_), 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)this.m_252754_(), (float)(this.renderY + this.f_93619_ + 128), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 128), (float)(this.renderY + this.f_93619_ + 128), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 128), (float)(this.renderY + this.f_93619_), 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            this.hueSelector.bind();
            RenderSystem.setShader(GameRenderer::m_172817_);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 106), (float)(this.renderY + this.f_93619_), 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 106), (float)(this.renderY + this.f_93619_ + 101), 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 106 + 10), (float)(this.renderY + this.f_93619_ + 101), 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f, (float)(this.m_252754_() + 106 + 10), (float)(this.renderY + this.f_93619_), 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.disableBlend();
            float hueOffset = (float)this.hue / 360.0f * 100.0f;
            int cursorX = this.m_252754_() + 106;
            int cursorY = (int)hueOffset + this.renderY + this.f_93619_;
            guiGraphics.m_280509_(cursorX, cursorY, cursorX + 10, cursorY + 1, -1);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        if (this.previewConsumer != null) {
            if (this.f_93623_ && this.f_93624_ && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
                int saturation = (int)(mouseX - (double)this.m_252754_());
                int brightness = (int)(mouseY - (double)this.renderY - (double)this.f_93619_);
                this.mouseOverGrid = true;
                this.previewConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            } else if (this.mouseOverGrid) {
                this.previewConsumer.accept(null);
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        if (!this.showPalette) {
            this.closeable.close();
        }
        this.showPalette = !this.showPalette;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (this.hueMouseDown) {
            this.setHue(mouseX, mouseY, 0, true);
        }
    }

    public void m_7691_(double d, double e) {
        this.hueMouseDown = false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.selectColour(mouseX, mouseY, button) || this.setHue(mouseX, mouseY, button, false) || super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    private boolean selectColour(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_ && button == 0 && this.showPalette && this.isOverGrid(mouseX, mouseY)) {
            int saturation = (int)(mouseX - (double)this.m_252754_());
            int brightness = (int)(mouseY - (double)this.renderY - (double)this.f_93619_);
            this.colourConsumer.accept(this.toRgb(this.hue, saturation, brightness));
            this.showPalette = false;
            return true;
        }
        return false;
    }

    private boolean setHue(double mouseX, double mouseY, int button, boolean force) {
        if (this.f_93623_ && this.f_93624_ && button == 0 && this.showPalette) {
            if (!(force || mouseY >= (double)(this.renderY + this.f_93619_) && mouseY <= (double)(this.renderY + this.f_93619_ + 101))) {
                return false;
            }
            if (force || mouseX >= (double)(this.m_252754_() + 106) && mouseX <= (double)(this.m_252754_() + 106 + 10)) {
                this.hueMouseDown = true;
                double yOffset = mouseY - (double)(this.renderY + this.f_93619_);
                int newHue = Mth.m_14045_((int)((int)(yOffset / 102.0 * 360.0)), (int)0, (int)360);
                if (newHue != this.hue) {
                    this.hue = newHue;
                    this.updateTexture = true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isOverGrid(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + 101) && mouseY >= (double)(this.renderY + this.f_93619_) && mouseY < (double)(this.renderY + this.f_93619_ + 101);
    }

    private void updateTexture(Texture texture, int hue) {
        int[] rgbaValues = new int[16384];
        for (int saturation = 0; saturation <= 100; ++saturation) {
            for (int brightness = 0; brightness <= 100; ++brightness) {
                int rgb = this.toRgb(hue, saturation, brightness) & 0xFFFFFF;
                rgbaValues[brightness * 128 + saturation] = rgb << 8 | 0xFF;
            }
        }
        texture.setPixels(rgbaValues);
        texture.update();
    }

    private int toRgb(int hue, int sat, int bright) {
        double[] rgbArr = HUSLColorConverter.hsluvToRgb(new double[]{hue, sat, bright});
        return (int)(rgbArr[0] * 255.0) << 16 | (int)(rgbArr[1] * 255.0) << 8 | (int)(rgbArr[2] * 255.0);
    }

    private int getHue(int colour) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        return (int)Math.round(HUSLColorConverter.rgbToHsluv(new double[]{(double)r / 255.0, (double)g / 255.0, (double)b / 255.0})[0]);
    }

    private Texture getHueSelector() {
        Texture hueSelector = new Texture(1, 360);
        int[] rgbaValues = new int[360];
        for (int i = 0; i < 360; ++i) {
            int rgb = this.toRgb(i, 100, 50);
            rgbaValues[i] = rgb << 8 | 0xFF;
        }
        hueSelector.setPixels(rgbaValues);
        hueSelector.update();
        return hueSelector;
    }

    public void close() {
        this.showPalette = false;
    }
}

