/*
 * Decompiled with CFR 0.152.
 */
package sh.okx.civmodern.common.radar;

import com.google.common.eventbus.Subscribe;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL11;
import sh.okx.civmodern.common.CivMapConfig;
import sh.okx.civmodern.common.ColourProvider;
import sh.okx.civmodern.common.events.ClientTickEvent;
import sh.okx.civmodern.common.events.EventBus;
import sh.okx.civmodern.common.events.PostRenderGameOverlayEvent;

public class Radar {
    private static boolean hideY;
    private final EventBus eventBus;
    private final ColourProvider colourProvider;
    private final CivMapConfig config;
    private Set<RemotePlayer> playersInRange = new HashSet<RemotePlayer>();
    private int translateX;
    private int translateY;
    private int bgColour;
    private int fgColour;

    public Radar(CivMapConfig config, EventBus eventBus, ColourProvider colourProvider) {
        this.config = config;
        this.eventBus = eventBus;
        this.colourProvider = colourProvider;
        eventBus.register(this);
    }

    @Subscribe
    private void onClientTick(@NotNull ClientTickEvent event) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null) {
            this.playersInRange = Collections.emptySet();
        }
    }

    private boolean hideY() {
        return hideY;
    }

    @Subscribe
    private void onWorldTickPing(@NotNull ClientTickEvent event) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        HashSet<RemotePlayer> newPlayersInRange = new HashSet<RemotePlayer>();
        for (Entity entity : world.m_104735_()) {
            if (!(entity instanceof RemotePlayer)) continue;
            RemotePlayer player = (RemotePlayer)entity;
            newPlayersInRange.add(player);
            if (this.playersInRange.contains(player)) continue;
            if (this.config.isPingEnabled()) {
                BlockPos pos = player.m_20183_();
                String lastWaypointCommand = "/newWaypoint x:" + pos.m_123341_() + ",y:" + (this.hideY() ? Minecraft.m_91087_().f_91074_.m_146904_() : pos.m_123342_()) + ",z:" + pos.m_123343_() + ",name:" + player.m_6302_();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"civmodern.radar.enter", (Object[])new Object[]{player.m_7755_(), Component.m_237113_((String)(this.hideY() ? pos.m_123341_() + " " + pos.m_123343_() : pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_130940_(ChatFormatting.AQUA)}).m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastWaypointCommand)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"civmodern.radar.hover")))), false);
            }
            if (!this.config.isPingSoundEnabled()) continue;
            Radar.playPlayerSound("pling", player.m_20148_());
        }
        if (this.config.isPingEnabled()) {
            for (RemotePlayer player : this.playersInRange) {
                if (newPlayersInRange.contains(player)) continue;
                BlockPos pos = player.m_20183_();
                String lastWaypointCommand = "/newWaypoint x:" + pos.m_123341_() + ",y:" + (this.hideY() ? Minecraft.m_91087_().f_91074_.m_146904_() : pos.m_123342_()) + ",z:" + pos.m_123343_() + ",name:" + player.m_6302_();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"civmodern.radar.leave", (Object[])new Object[]{player.m_7755_(), Component.m_237113_((String)(this.hideY() ? pos.m_123341_() + " " + pos.m_123343_() : pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_130938_(s -> s.m_131157_(ChatFormatting.AQUA))}).m_6270_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, lastWaypointCommand)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"civmodern.radar.hover")))), false);
            }
        }
        this.playersInRange = newPlayersInRange;
    }

    @Subscribe
    private void onRender(@NotNull PostRenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.m_293199_().m_294516_()) {
            return;
        }
        if (this.config.isRadarEnabled()) {
            this.render(event.guiGraphics(), event.deltaTick());
        }
    }

    private int radius() {
        return this.config.getRadarSize();
    }

    public void render(GuiGraphics guiGraphics, float delta) {
        this.bgColour = this.colourProvider.getBackgroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getBackgroundTransparency()) * 255.0f) << 24;
        this.fgColour = this.colourProvider.getForegroundColour() & 0xFFFFFF | (int)((1.0f - this.config.getTransparency()) * 255.0f) << 24;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        Minecraft client = Minecraft.m_91087_();
        LocalPlayer player = client.f_91074_;
        guiGraphics.m_280168_().m_85836_();
        int offsetX = this.config.getX() + this.config.getRadarSize();
        int offsetY = this.config.getY() + this.config.getRadarSize();
        int height = client.m_91268_().m_85446_();
        int width = client.m_91268_().m_85445_();
        switch (this.config.getAlignment()) {
            case TOP_LEFT: {
                this.translateX = offsetX;
                this.translateY = offsetY;
                break;
            }
            case TOP_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = offsetY;
                break;
            }
            case BOTTOM_RIGHT: {
                this.translateX = width - offsetX;
                this.translateY = height - offsetY;
                break;
            }
            case BOTTOM_LEFT: {
                this.translateX = offsetX;
                this.translateY = height - offsetY;
            }
        }
        guiGraphics.m_280168_().m_252880_((float)this.translateX, (float)this.translateY, 100.0f);
        this.renderCircleBackground(guiGraphics.m_280168_());
        for (int i = 1; i <= this.config.getRadarCircles(); ++i) {
            this.renderCircleBorder(guiGraphics.m_280168_(), (float)this.radius() * ((float)i / (float)this.config.getRadarCircles()));
        }
        if (this.config.isNorthUp()) {
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            this.renderAngle(guiGraphics.m_280168_(), delta);
        } else {
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(-player.m_5675_(delta) % 360.0f));
        }
        this.renderLines(guiGraphics.m_280168_());
        if (this.config.isShowItems()) {
            this.renderItems(guiGraphics, delta);
        }
        this.renderBoatsMinecarts(guiGraphics, delta);
        this.renderPlayers(guiGraphics, delta);
        guiGraphics.m_280168_().m_85849_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    private void renderBoatsMinecarts(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (Entity entity : minecraft.f_91073_.m_104735_()) {
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                this.renderEntity(guiGraphics, (Player)minecraft.f_91074_, (Entity)boat, delta, boat.m_142340_(), 1.0f);
                continue;
            }
            if (!(entity instanceof Minecart)) continue;
            Minecart minecart = (Minecart)entity;
            this.renderEntity(guiGraphics, (Player)minecraft.f_91074_, (Entity)minecart, delta, new ItemStack((ItemLike)Items.f_42449_, 1), 1.1f);
        }
    }

    private void renderItems(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (Entity entity : minecraft.f_91073_.m_104735_()) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity item = (ItemEntity)entity;
            this.renderEntity(guiGraphics, (Player)minecraft.f_91074_, (Entity)item, delta, item.m_32055_(), 0.0f);
        }
    }

    private void renderEntity(GuiGraphics guiGraphics, Player player, Entity entity, float delta, ItemStack item, float blit) {
        boolean notUseBlockLight;
        double z;
        double dz;
        double scale = (double)this.config.getRadarSize() / this.config.getRange();
        double px = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)delta;
        double pz = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)delta;
        double x = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)delta;
        double dx = px - x;
        if (dx * dx + (dz = pz - (z = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_(dx * scale, dz * scale, 150.0);
        if (this.config.isNorthUp()) {
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
        } else {
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(player.m_5675_(delta)));
        }
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(item, player.m_9236_(), (LivingEntity)player, 0);
        guiGraphics.m_280168_().m_85841_(this.config.getIconSize(), this.config.getIconSize(), 1.0f);
        guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
        boolean bl = notUseBlockLight = !bakedModel.m_7547_();
        if (notUseBlockLight) {
            Lighting.m_84930_();
        }
        Minecraft.m_91087_().m_91291_().m_115143_(item, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        guiGraphics.m_280262_();
        if (notUseBlockLight) {
            Lighting.m_84931_();
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderPlayers(GuiGraphics guiGraphics, float delta) {
        Minecraft minecraft = Minecraft.m_91087_();
        for (RemotePlayer player : this.playersInRange) {
            double z;
            double dz;
            if (!player.m_6084_()) continue;
            double v = (double)this.config.getRadarSize() / this.config.getRange();
            double px = minecraft.f_91074_.f_19790_ + (minecraft.f_91074_.m_20185_() - minecraft.f_91074_.f_19790_) * (double)delta;
            double pz = minecraft.f_91074_.f_19792_ + (minecraft.f_91074_.m_20189_() - minecraft.f_91074_.f_19792_) * (double)delta;
            double x = player.f_19790_ + (player.m_20185_() - player.f_19790_) * (double)delta;
            double dx = px - x;
            if (dx * dx + (dz = pz - (z = player.f_19792_ + (player.m_20189_() - player.f_19792_) * (double)delta)) * dz > this.config.getRange() * this.config.getRange()) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(dx * v, dz * v, 0.0);
            guiGraphics.m_280168_().m_85841_(0.9f, 0.9f, 0.0f);
            PlayerInfo entry = minecraft.f_91074_.f_108617_.m_104949_(player.m_20148_());
            guiGraphics.m_280168_().m_85841_(this.config.getIconSize(), this.config.getIconSize(), 0.0f);
            if (this.config.isNorthUp()) {
                guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else {
                guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(minecraft.f_91074_.m_5675_(delta)));
            }
            ResourceLocation location = entry != null ? entry.m_293823_().f_290339_() : new ResourceLocation("textures/entity/steve.png");
            guiGraphics.m_280411_(location, -4, -4, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85841_(0.6f, 0.6f, 0.0f);
            MutableComponent component = Component.m_237113_((String)(player.m_6302_() + " (" + (this.hideY() ? (int)Math.round(Math.sqrt(dx * dx + dz * dz)) : (int)player.m_20186_()) + ")"));
            minecraft.f_91062_.m_272077_((Component)component, (float)(-minecraft.f_91062_.m_92852_((FormattedText)component)) / 2.0f, 7.0f, 0xFFFFFF, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderCircleBackground(PoseStack stack) {
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        float radius = (float)this.radius() + 0.5f;
        for (int i = 0; i <= 360; ++i) {
            float x = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            buffer.m_252986_(stack.m_85850_().m_252922_(), x, y, 0.0f).m_193479_(this.bgColour).m_5752_();
        }
        tessellator.m_85914_();
        RenderSystem.disableBlend();
    }

    private void renderCircleBorder(PoseStack stack, float radius) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        float thickness = radius == (float)this.radius() ? 1.0f : 0.5f;
        Matrix4f pose = stack.m_85850_().m_252922_();
        for (int i = 0; i <= 360; ++i) {
            float x0 = (float)Math.sin((double)i * Math.PI / 180.0) * radius;
            float y0 = (float)Math.cos((double)i * Math.PI / 180.0) * radius;
            float x1 = (float)Math.sin((double)i * Math.PI / 180.0) * (radius + thickness);
            float y1 = (float)Math.cos((double)i * Math.PI / 180.0) * (radius + thickness);
            buffer.m_252986_(pose, x0, y0, 0.0f).m_193479_(this.fgColour).m_5752_();
            buffer.m_252986_(pose, x1, y1, 0.0f).m_193479_(this.fgColour).m_5752_();
        }
        tessellator.m_85914_();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderAngle(PoseStack matrixStack, float delta) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        float radius = (float)this.radius() + 0.5f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float thickness = 1.0f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.m_85836_();
        Matrix4f last = matrixStack.m_85850_().m_252922_();
        last.mul((Matrix4fc)Axis.f_252403_.m_252977_(Minecraft.m_91087_().f_91074_.m_5675_(delta)).get(new Matrix4f()));
        buffer.m_252986_(last, left, -radius, 0.0f).m_193479_(this.fgColour).m_5752_();
        buffer.m_252986_(last, left, 0.0f, 0.0f).m_193479_(this.fgColour).m_5752_();
        buffer.m_252986_(last, right, 0.0f, 0.0f).m_193479_(this.fgColour).m_5752_();
        buffer.m_252986_(last, right, -radius, 0.0f).m_193479_(this.fgColour).m_5752_();
        matrixStack.m_85849_();
        tesselator.m_85914_();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    private void renderLines(PoseStack matrixStack) {
        RenderSystem.enableBlend();
        GL11.glEnable((int)2881);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        float radius = (float)this.radius() + 0.5f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        float thickness = 0.5f;
        float left = -thickness / 2.0f;
        float right = thickness / 2.0f;
        matrixStack.m_85836_();
        Matrix4f last = matrixStack.m_85850_().m_252922_();
        int numberOfLines = 4;
        float rotationRadians = (float)Math.PI / (float)numberOfLines;
        for (int i = 0; i < numberOfLines; ++i) {
            buffer.m_252986_(last, left, -radius, 0.0f).m_193479_(this.fgColour).m_5752_();
            buffer.m_252986_(last, left, radius, 0.0f).m_193479_(this.fgColour).m_5752_();
            buffer.m_252986_(last, right, radius, 0.0f).m_193479_(this.fgColour).m_5752_();
            buffer.m_252986_(last, right, -radius, 0.0f).m_193479_(this.fgColour).m_5752_();
            Matrix4f mul = new Matrix4f();
            last.mul((Matrix4fc)Axis.f_252403_.m_252961_(rotationRadians).get(mul));
        }
        matrixStack.m_85849_();
        tesselator.m_85914_();
        GL11.glDisable((int)2881);
        RenderSystem.disableBlend();
    }

    public static void playPlayerSound(String soundName, UUID playerKey) {
        SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("block.note_block." + soundName));
        if (soundEvent == null) {
            return;
        }
        float pitch = 0.5f + 1.5f * new Random(playerKey.hashCode()).nextFloat();
        float volume = 1.0f;
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)pitch, (float)volume));
    }

    static {
        URL resource = Radar.class.getResource("/civmc");
        hideY = resource != null;
    }
}

